(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 9.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1063,         20]
NotebookDataLength[   1044234,      17964]
NotebookOptionsPosition[   1038464,      17752]
NotebookOutlinePosition[   1039084,      17775]
CellTagsIndexPosition[   1039041,      17772]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Introduction", "Section"],

Cell["\<\
This file contains interactive figures to accompany \
\[OpenCurlyDoubleQuote]Introduction to the Theory of Soft Matter: From Ideal \
Gases to Liquid Crystals,\[CloseCurlyDoubleQuote] by Jonathan V. Selinger.\
\>", "Text"],

Cell["\<\
Some of these figures allow you to change parameters and see what happens to \
a graph. Some allow you to rotate a plot or other graphics in 3D. Some do \
both.\
\>", "Text"],

Cell["To change parameters, you can either:", "Text"],

Cell["(a) Move the slider next to a parameter name, or", "Text"],

Cell["\<\
(b) Click on the + sign next to a slider, type the desired value for the \
parameter, and press enter.\
\>", "Text"],

Cell["\<\
To rotate a figure in 3D, just click and drag with the mouse.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 2: Ising Model for Ferromagnetism", "Section"],

Cell[CellGroupData[{

Cell["\<\
Figure 2.2: Magnetic order parameter of the non-interacting Ising model, as a \
function of h.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`kBTtest$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`kBTtest$$], 1, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.25, 4}}, Typeset`size$$ = {
    450., {132., 170.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`kBTtest$255$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`kBTtest$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`kBTtest$$, $CellContext`kBTtest$255$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[
         Tanh[$CellContext`h/$CellContext`kBT], $CellContext`kBT -> \
$CellContext`kBTtest$$], {$CellContext`h, -3, 3}, PlotRange -> {-1, 1}, 
        AxesLabel -> {$CellContext`h, $CellContext`M}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`kBTtest$$, 1, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.25, 4}}, 
      "Options" :> {TrackedSymbols -> {$CellContext`kBTtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {203., 210.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 2.3: Free energy of the non-interacting Ising model, as a function of \
M.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`hoverkBTtest$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`hoverkBTtest$$], 0, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`h}, -1, 1}}, 
    Typeset`size$$ = {450., {126., 163.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`hoverkBTtest$330$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`hoverkBTtest$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`hoverkBTtest$$, $CellContext`hoverkBTtest$330$$, 
         0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[(-$CellContext`hoverkBT) $CellContext`M + ((
            1 + $CellContext`M)/2) 
          Log[(1 + $CellContext`M)/2] + ((1 - $CellContext`M)/2) 
          Log[(1 - $CellContext`M)/
            2], $CellContext`hoverkBT -> $CellContext`hoverkBTtest$$], \
{$CellContext`M, -1, 1}, AxesLabel -> {$CellContext`M, $CellContext`F}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`hoverkBTtest$$, 0, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`h}, -1, 1}},
       "Options" :> {TrackedSymbols -> {$CellContext`hoverkBTtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {199., 206.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 2.4: Free energy of the interacting Ising model, with h=0, as a \
function of M.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`JqoverkBTtest$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`JqoverkBTtest$$], 0, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`Jq}, 0, 2}}, 
    Typeset`size$$ = {450., {127., 162.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`JqoverkBTtest$369$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`JqoverkBTtest$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`JqoverkBTtest$$, $CellContext`JqoverkBTtest$369$$, 
         0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[((-(1/2)) $CellContext`JqoverkBT) $CellContext`M^2 + ((
            1 + $CellContext`M)/2) 
          Log[(1 + $CellContext`M)/2] + ((1 - $CellContext`M)/2) 
          Log[(1 - $CellContext`M)/
            2], $CellContext`JqoverkBT -> $CellContext`JqoverkBTtest$$], \
{$CellContext`M, -1, 1}, AxesLabel -> {$CellContext`M, $CellContext`F}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`JqoverkBTtest$$, 0, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`Jq}, 0, 2}},
       "Options" :> {TrackedSymbols -> {$CellContext`JqoverkBTtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {199., 206.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 2.5: Free energy of the interacting Ising model, with h\[NotEqual]0, \
as a function of M.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`hoverkBTtest$$ = 
    0, $CellContext`JqoverkBTtest$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`JqoverkBTtest$$], 0, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`Jq}, 0, 2}, {{
       Hold[$CellContext`hoverkBTtest$$], 0, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`h}, -1, 1}}, 
    Typeset`size$$ = {450., {127., 162.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`JqoverkBTtest$408$$ = 
    0, $CellContext`hoverkBTtest$409$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`hoverkBTtest$$ = 
        0, $CellContext`JqoverkBTtest$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`JqoverkBTtest$$, $CellContext`JqoverkBTtest$408$$, 
         0], 
        Hold[$CellContext`hoverkBTtest$$, $CellContext`hoverkBTtest$409$$, 
         0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[((-(1/
             2)) $CellContext`JqoverkBT) $CellContext`M^2 - \
$CellContext`hoverkBT $CellContext`M + ((1 + $CellContext`M)/2) 
          Log[(1 + $CellContext`M)/2] + ((1 - $CellContext`M)/2) 
          Log[(1 - $CellContext`M)/
            2], {$CellContext`JqoverkBT -> $CellContext`JqoverkBTtest$$, \
$CellContext`hoverkBT -> $CellContext`hoverkBTtest$$}], {$CellContext`M, -1, 
         1}, AxesLabel -> {$CellContext`M, $CellContext`F}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`JqoverkBTtest$$, 0, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`Jq}, 0, 
         2}, {{$CellContext`hoverkBTtest$$, 0, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`h}, -1, 1}},
       "Options" :> {
       TrackedSymbols -> {$CellContext`JqoverkBTtest$$, \
$CellContext`hoverkBTtest$$}}, "DefaultOptions" :> {}],
     ImageSizeCache->{509., {219., 226.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 2.6: Ising order parameter M as a function of temperature T.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`hoverkBTtest$$ = 0.02, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`hoverkBTtest$$], 0.02, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`h}, 0, 0.2}}, 
    Typeset`size$$ = {450., {135., 170.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`hoverkBTtest$638$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`hoverkBTtest$$ = 0.02}, 
      "ControllerVariables" :> {
        Hold[$CellContext`hoverkBTtest$$, $CellContext`hoverkBTtest$638$$, 
         0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        $CellContext`Msol[1/$CellContext`ToverTc, $CellContext`hoverkBTtest$$, 
         If[$CellContext`hoverkBTtest$$ >= 0, 
          0.5, -0.5]], {$CellContext`ToverTc, 0.1, 1.5}, PlotRange -> {0, 1}, 
        AxesLabel -> {$CellContext`T/
          Subscript[$CellContext`T, C], $CellContext`M}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`hoverkBTtest$$, 0.02, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`h}, 0, 
         0.2}}, "Options" :> {
       TrackedSymbols -> {$CellContext`hoverkBTtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {207., 214.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>($CellContext`Msol[
        Pattern[$CellContext`JqoverkBT, 
         Blank[]], 
        Pattern[$CellContext`hoverkBT, 
         Blank[]], 
        Pattern[$CellContext`Mstart, 
         Blank[]]] := ReplaceAll[$CellContext`M, 
        FindRoot[{$CellContext`M == 
          Tanh[$CellContext`hoverkBT + $CellContext`JqoverkBT \
$CellContext`M]}, {$CellContext`M, $CellContext`Mstart}]]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 2.7: Ising order parameter M as a function of field h.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`JqoverkBTtest$$ = 0.9, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`JqoverkBTtest$$], 0.9, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`Jq}, 0.5, 2}}, 
    Typeset`size$$ = {450., {118., 153.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`JqoverkBTtest$682$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`JqoverkBTtest$$ = 0.9}, 
      "ControllerVariables" :> {
        Hold[$CellContext`JqoverkBTtest$$, $CellContext`JqoverkBTtest$682$$, 
         0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        $CellContext`Msol[$CellContext`JqoverkBTtest$$, $CellContext`hoverkBT, 
         If[$CellContext`hoverkBT >= 0, 
          0.5, -0.5]], {$CellContext`hoverkBT, -0.2, 0.2}, 
        AxesLabel -> {$CellContext`h/(
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)" $CellContext`T), \
$CellContext`M}, BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`JqoverkBTtest$$, 0.9, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"^(-1) $CellContext`Jq}, 0.5, 
         2}}, "Options" :> {TrackedSymbols -> {$CellContext`JqoverkBTtest$$}},
       "DefaultOptions" :> {}],
     ImageSizeCache->{509., {190., 197.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>($CellContext`Msol[
        Pattern[$CellContext`JqoverkBT, 
         Blank[]], 
        Pattern[$CellContext`hoverkBT, 
         Blank[]], 
        Pattern[$CellContext`Mstart, 
         Blank[]]] := ReplaceAll[$CellContext`M, 
        FindRoot[{$CellContext`M == 
          Tanh[$CellContext`hoverkBT + $CellContext`JqoverkBT \
$CellContext`M]}, {$CellContext`M, $CellContext`Mstart}]]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 2.8: Ising order parameter M as a function of temperature T and field \
h, in a 3D plot.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVnWVUlc3XxrG7sDCwAztQLHQUFcXCxBYTsQMDOzGx8xhYGNiimAdvDBTk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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mnfgV9Mbx+8491oVJZKVIgqFzEhpL9KQkKg0pSEjSYWsUMgoUloqoYWG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         "]], Polygon3DBox[CompressedData["
1:eJwtm3fgV9Mfxu8454uyipQGkrKKhFQks1CkPYSmpoY9orKKJA1RRkNmQ4ko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         "]], Polygon3DBox[CompressedData["
1:eJwt1nncllMex/G757l7KtFQRCWNVq20DNNCqtFqpGwVE6JIQzTDGBQTLcbW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         "]], 
        Polygon3DBox[{{1197, 729, 930, 1526, 1046, 
         1047}}]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k0vXFEYB/Az3pXiE8xkImqDfVMNS6Ermwa7aSJhURtRtLS6IbH1Eq2i
C+wxX0CnaUREdAymQ0uTbpom/QBC/G4s/vf3PGfOPefeMzeZGup+GQshzMqy
Iqrfu/zlZnEIdUwzwQxbmOVT/uYzXpeEcMs+mSsNYcv9D2VFBo3NG9tW18lq
9Jv5Y8aT6qR6Rt3CRT7hBjuZZg8zrLVGvflrktV/YJuMFIVwrH/FHEd5wjGe
cpxnfM083/AHJ1jgJM/5lhd8x5+c4q/oLHjJlHdtsN9nudJ/ZLsMe77v+n5+
4XPusIPrfMwFNnGaCcZlVF3FAd5Yu5f/2cVLtvKIzdxlnH/M/8dP9q3lEhvl
Qmr0hehsmWc1T1nFHB9E/xsro3VZwUOW84Bl3KdjDnu0VfhGW4evdAzhheZR
7P47uQPW5kgz
       "]]}, {
      Line3DBox[{935, 1252, 643, 934, 1527, 1141, 936, 1528, 1142, 937, 1529, 
       1143, 938, 1530, 1144, 939, 1531, 1145, 940, 1532, 1146, 941, 650, 942,
        1533, 1147, 943, 1534, 1148, 944, 1535, 1149, 945, 1536, 1150, 946, 
       1537, 1151, 947, 821, 1152, 1253}], 
      Line3DBox[{949, 1443, 1611, 948, 657, 950, 1538, 1153, 951, 1539, 1154, 
       952, 1540, 1155, 953, 1541, 1156, 954, 1542, 1157, 955, 1444, 1612, 
       956, 1254, 1297, 1697, 1158, 957, 1543, 1159, 958, 1544, 1160, 959, 
       1545, 1161, 960, 1546, 1162, 961, 1547, 1163, 962}], 
      Line3DBox[{964, 1445, 1613, 963, 1446, 1614, 965, 1548, 1164, 966, 1549,
        1165, 967, 1550, 1166, 968, 1551, 1167, 969, 1552, 1168, 970, 1256, 
       1257, 1447, 1686, 971, 1255, 1298, 1448, 1685, 972, 679, 973, 1553, 
       1169, 974, 1554, 1170, 975, 1555, 1171, 976, 1556, 1172, 977}], 
      Line3DBox[{979, 1449, 1615, 978, 1450, 1616, 980, 1451, 1617, 981, 1557,
        1173, 982, 1558, 1174, 983, 1559, 1175, 984, 1688, 1259, 1299, 1176, 
       985, 1240, 1262, 1452, 1678, 986, 1258, 1264, 1453, 1687, 987, 1266, 
       1301, 1454, 1690, 988, 1560, 1177, 989, 1561, 1178, 990, 1562, 1179, 
       991, 1563, 1180, 992}], 
      Line3DBox[{994, 1455, 1618, 993, 1456, 1619, 995, 1457, 1620, 996, 1458,
        1621, 997, 1564, 1181, 998, 1720, 1424, 1425, 999, 1689, 1260, 1300, 
       1261, 1000, 1241, 1263, 1242, 1679, 1001, 1243, 1265, 1244, 1680, 1002,
        1267, 1302, 1268, 1691, 1003, 1459, 1622, 1004, 1565, 1182, 1005, 
       1566, 1183, 1006, 1567, 1184, 1007}], 
      Line3DBox[{1021, 1186, 1569, 1020, 1185, 1568, 1019, 1628, 1461, 1018, 
       1627, 1460, 1017, 1510, 1626, 1303, 1272, 1016, 1683, 1250, 1271, 1249,
        1015, 1682, 1248, 1270, 1247, 1014, 1246, 1269, 1245, 1681, 1013, 
       1427, 1283, 1426, 1282, 1694, 1012, 1281, 1625, 1512, 1011, 1280, 1624,
        1279, 1010, 1511, 1623, 1278, 1009, 1693, 1277, 1276, 1008, 1692, 
       1274, 1273, 1275}], Line3DBox[CompressedData["
1:eJwVy0s+gnEYBeA3XYQNFBXZRe6XpFBRqIlbC8iEnViBBok5tqRFyGPw/M75
zvv/yoPHzjAREW2WUhEj1jMRi3Igv9MRC/qD/qVn9Xv9U5/Xp/LOd1mmyNh+
5K1tTfbpkba/2a70a1a5pPv/n9uF7FDinDYf3ifdmnqLIme82k/lnFtDnlDg
3V6XxyTcjmSNFaocEvZ9ecCN98tyj11myYhtObHvyDxbbPLrNrZX9A1yPPPE
C3/EwBxg
       "]], Line3DBox[CompressedData["
1:eJwVzzlOgmEUBdBnIjSG2hBCCDKJgjgguAoLO3BGHCrdjbYmDIIC6sqUHXgs
Tu793v2bP997OnlciYhjUqsR94mIBzbYZ5CMGLpv6R26FDhgaBvZtvVTzijy
w8g2ttX0cy4o0eTNvS4vmfnuV5Y5ZGLbkVfMbdeyQouprSGXLGw9uUmbd9uu
vKHPGke8+u7DtqffckeVsfvM/UV//v8n77n3OkV9IdOU9E+Zoax/ySwV/Vvm
+AMIqCF1
       "]], Line3DBox[CompressedData["
1:eJwVzssug2EUheEtKYNGFEVEGokL6sQlVBFa/Zk4lzq0TuMmNcAlIEXy45LE
QNXY08Gbd31rfYO9UEoWa0MRUcR8JmJ1JOJzOKIgr8gf8py8LL/Ls3JZTuUZ
+Y+XvO/4AfeY1nc41d/yFkYxpe/zm/6GN5FFXn/F10jwbP/mSf0FX6KGJ/0X
T+ib3MIGfvFoO+dx2ymfoYoTNJDTH/Orfz2u4Ah1jNkO+MV2yOvYx97gbtsP
d23bvIZd7KCNfzV4KE0=
       "]], 
      Line3DBox[{1057, 1285, 1469, 1695, 1056, 1286, 1576, 1202, 1058, 1287, 
       1577, 1203, 1059, 1288, 1578, 1204, 1060, 1515, 1579, 1205, 1061, 1517,
        1580, 1421, 1434, 1206, 1394, 1714, 1289, 1423, 1435, 1207, 1395, 
       1251, 1442, 1470, 1684, 1062, 1293, 1581, 1208, 1063, 1582, 1209, 1064,
        1583, 1210, 1065, 1584, 1211, 1066, 1585, 1212, 1067, 1586, 1213, 
       1068}], Line3DBox[{1070, 1471, 1640, 1069, 1472, 1641, 1071, 1587, 
       1214, 1072, 1588, 1215, 1073, 1589, 1216, 1074, 1719, 1420, 1217, 1436,
        1722, 1422, 1218, 1441, 1440, 1473, 1723, 1075, 1474, 1642, 1076, 751,
        1077, 1590, 1219, 1078, 1591, 1220, 1079, 1592, 1221, 1080, 1593, 
       1222, 1081}], 
      Line3DBox[{1083, 1475, 1643, 1082, 1476, 1644, 1084, 1477, 1645, 1085, 
       1594, 1223, 1086, 1595, 1224, 1087, 1596, 1225, 1088, 1597, 1226, 1089,
        1478, 1646, 1090, 1479, 1647, 1091, 1480, 1648, 1092, 1598, 1227, 
       1093, 1599, 1228, 1094, 1600, 1229, 1095, 1601, 1230, 1096}], 
      Line3DBox[{1098, 1481, 1649, 1097, 1482, 1650, 1099, 1483, 1651, 1100, 
       1484, 1652, 1101, 774, 1102, 1602, 1231, 1103, 1603, 1232, 1104, 1485, 
       1653, 1105, 1486, 1654, 1106, 1487, 1655, 1107, 1488, 1656, 1108, 781, 
       1109, 1604, 1233, 1110, 1605, 1234, 1111}], 
      Line3DBox[{1113, 1489, 1657, 1112, 1490, 1658, 1114, 1491, 1659, 1115, 
       1492, 1660, 1116, 1493, 1661, 1117, 1606, 1235, 1118, 1607, 1236, 1119,
        1494, 1662, 1120, 1495, 1663, 1121, 1496, 1664, 1122, 1497, 1665, 
       1123, 1498, 1666, 1124, 1608, 1237, 1125, 1609, 1238, 1126}], 
      Line3DBox[{1140, 1296, 864, 1139, 1677, 1509, 1138, 1676, 1508, 1137, 
       1675, 1507, 1136, 1674, 1506, 1135, 1673, 1505, 1134, 1672, 1504, 1133,
        1239, 1610, 1132, 1671, 1503, 1131, 1670, 1502, 1130, 1669, 1501, 
       1129, 1668, 1500, 1128, 1667, 1499, 1127, 863, 1294, 1295}]}, {
      Line3DBox[{453, 644, 1527, 454, 657, 480, 1614, 671, 494, 1616, 685, 
       508, 1619, 698, 521, 835, 1693, 710, 533, 1705, 348, 876, 419, 543, 
       1716, 399, 884, 339, 1700, 553, 849, 735, 1576, 563, 1641, 745, 575, 
       1644, 757, 589, 1650, 771, 603, 1658, 785, 617, 1667, 799, 631}], 
      Line3DBox[{455, 645, 1528, 456, 658, 1538, 481, 672, 1548, 495, 1617, 
       686, 509, 1620, 699, 522, 1623, 836, 711, 534, 896, 1629, 837, 877, 
       918, 919, 544, 1717, 913, 850, 885, 891, 892, 1701, 554, 851, 736, 
       1577, 564, 746, 1587, 576, 1645, 758, 590, 1651, 772, 604, 1659, 786, 
       618, 1668, 800, 632}], 
      Line3DBox[{457, 646, 1529, 458, 659, 1539, 482, 673, 1549, 496, 687, 
       1557, 510, 1621, 700, 523, 1624, 259, 304, 1307, 260, 378, 1388, 277, 
       1317, 314, 278, 1578, 565, 747, 1588, 577, 759, 1594, 591, 1652, 773, 
       605, 1660, 787, 619, 1669, 801, 633}], 
      Line3DBox[{459, 647, 1530, 460, 660, 1540, 483, 674, 1550, 497, 688, 
       1558, 511, 701, 1564, 524, 1625, 838, 839, 869, 897, 1706, 840, 878, 
       841, 909, 905, 1711, 914, 852, 886, 853, 902, 1708, 872, 854, 855, 
       1579, 566, 748, 1589, 578, 760, 1595, 592, 774, 606, 1661, 788, 620, 
       1670, 802, 634}], 
      Line3DBox[{461, 648, 1531, 462, 661, 1541, 484, 675, 1551, 498, 689, 
       1559, 512, 927, 1720, 928, 929, 842, 1694, 843, 870, 1698, 355, 879, 
       844, 906, 1712, 856, 887, 366, 1709, 873, 857, 858, 1580, 923, 921, 
       1719, 922, 579, 761, 1596, 593, 775, 1602, 607, 789, 1606, 621, 1671, 
       803, 635}], 
      Line3DBox[{463, 649, 1532, 464, 662, 1542, 485, 676, 1552, 499, 826, 
       1688, 827, 868, 828, 1689, 829, 832, 814, 1681, 910, 815, 871, 898, 
       1707, 899, 880, 845, 907, 1713, 859, 888, 904, 903, 1710, 874, 860, 
       908, 1714, 861, 926, 924, 932, 1722, 925, 580, 762, 1597, 594, 776, 
       1603, 608, 790, 1607, 622, 804, 1610, 636}], 
      Line3DBox[{8, 941, 23, 955, 38, 970, 53, 985, 68, 1000, 83, 1014, 98, 
       1028, 327, 113, 1043, 336, 1328, 128, 385, 1395, 143, 448, 1441, 158, 
       1089, 173, 1104, 188, 1119, 203, 1133, 218}], 
      Line3DBox[{465, 650, 466, 1612, 663, 486, 824, 1686, 677, 500, 811, 
       1678, 690, 513, 812, 1679, 702, 525, 816, 1682, 712, 535, 900, 1704, 
       901, 881, 920, 720, 545, 1718, 915, 916, 889, 893, 727, 1696, 555, 818,
        1684, 737, 567, 933, 1723, 749, 581, 1646, 763, 595, 1653, 777, 609, 
       1662, 791, 623, 1672, 805, 637}], 
      Line3DBox[{467, 651, 1533, 468, 822, 664, 1697, 487, 823, 1685, 678, 
       501, 825, 1687, 691, 514, 813, 1680, 703, 526, 817, 1683, 713, 536, 
       1630, 846, 882, 426, 546, 1721, 438, 931, 728, 1702, 556, 862, 738, 
       1581, 568, 1642, 750, 582, 1647, 764, 596, 1654, 778, 610, 1663, 792, 
       624, 1673, 806, 638}], 
      Line3DBox[{469, 652, 1534, 470, 665, 1543, 488, 679, 502, 830, 1690, 
       692, 515, 831, 1691, 704, 527, 1626, 833, 714, 537, 1631, 847, 721, 
       547, 1635, 930, 729, 1571, 557, 739, 1582, 569, 751, 583, 1648, 765, 
       597, 1655, 779, 611, 1664, 793, 625, 1674, 807, 639}], 
      Line3DBox[{471, 653, 1535, 472, 666, 1544, 489, 680, 1553, 503, 693, 
       1560, 516, 1622, 705, 528, 1627, 715, 538, 1632, 722, 548, 1636, 730, 
       1572, 558, 740, 1583, 570, 752, 1590, 584, 766, 1598, 598, 1656, 780, 
       612, 1665, 794, 626, 1675, 808, 640}], 
      Line3DBox[{473, 654, 1536, 474, 667, 1545, 490, 681, 1554, 504, 694, 
       1561, 517, 706, 1565, 529, 1628, 716, 539, 1633, 723, 549, 1637, 731, 
       1573, 559, 741, 1584, 571, 753, 1591, 585, 767, 1599, 599, 781, 613, 
       1666, 795, 627, 1676, 809, 641}], 
      Line3DBox[{475, 655, 1537, 476, 668, 1546, 491, 682, 1555, 505, 695, 
       1562, 518, 707, 1566, 530, 717, 1568, 540, 1634, 724, 550, 1638, 732, 
       1574, 560, 742, 1585, 572, 754, 1592, 586, 768, 1600, 600, 782, 1604, 
       614, 796, 1608, 628, 1677, 810, 642}], 
      Line3DBox[{477, 820, 821, 478, 669, 1547, 492, 683, 1556, 506, 696, 
       1563, 519, 708, 1567, 531, 718, 1569, 541, 725, 1570, 551, 1639, 733, 
       1575, 561, 743, 1586, 573, 755, 1593, 587, 769, 1601, 601, 783, 1605, 
       615, 797, 1609, 629, 864, 865, 866}], 
      Line3DBox[{630, 798, 863, 616, 784, 1657, 602, 770, 1649, 588, 756, 
       1643, 574, 744, 1640, 562, 734, 1695, 848, 552, 1699, 726, 890, 883, 
       912, 911, 1715, 542, 719, 917, 875, 895, 1703, 894, 532, 709, 1692, 
       834, 520, 697, 1618, 507, 684, 1615, 493, 670, 1613, 479, 656, 1611, 
       452, 643, 819, 867}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0mnk0Vn33/2UIKVFJIaWQIdJAKtkp0iCUQoMpkSFkKpVCCYnMzTIPoUJm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    "]],
  Axes->True,
  AxesLabel->{
    FormBox[
     FractionBox["T", 
      SubscriptBox["T", "C"]], TraditionalForm], 
    FormBox[
     FractionBox["h", 
      RowBox[{"\"\\!\\(\\*SubscriptBox[\\(k\\), \\(B\\)]\\)\"", " ", "T"}]], 
     TraditionalForm], 
    FormBox["M", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0.1, 1.5}, {-0.2, 0.2}, {-0.999999997236676, 
   0.999999997236676}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 3: Gases and Liquids", "Section"],

Cell[CellGroupData[{

Cell["\<\
Figure 3.2: Gibbs free energy of an ideal gas, as a function of the volume \
per molecule v=V/N.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`kBTtest$$ = 0.3, $CellContext`ptest$$ = 
    0.02, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`ptest$$], 0.02, $CellContext`p}, 0.01, 0.04}, {{
       Hold[$CellContext`kBTtest$$], 0.3, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.1, 0.5}}, Typeset`size$$ = {
    450., {128., 163.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`ptest$1228$$ = 
    0, $CellContext`kBTtest$1229$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`kBTtest$$ = 0.3, $CellContext`ptest$$ = 
        0.02}, "ControllerVariables" :> {
        Hold[$CellContext`ptest$$, $CellContext`ptest$1228$$, 0], 
        Hold[$CellContext`kBTtest$$, $CellContext`kBTtest$1229$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[-
          Log[$CellContext`v] + ($CellContext`p/$CellContext`kBT) \
$CellContext`v, {$CellContext`p -> $CellContext`ptest$$, $CellContext`kBT -> \
$CellContext`kBTtest$$}], {$CellContext`v, 0, 40}, 
        AxesLabel -> {$CellContext`v, $CellContext`G}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`ptest$$, 0.02, $CellContext`p}, 
         0.01, 0.04}, {{$CellContext`kBTtest$$, 0.3, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.1, 0.5}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`ptest$$, $CellContext`kBTtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {216., 223.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 3.5: Gibbs free energy for van der Waals theory, with the parameters \
a=1 and b=1.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`kBTtest$$ = 0.3, $CellContext`ptest$$ = 
    0.01, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`ptest$$], 0.01, $CellContext`p}, 0.005, 0.04}, {{
       Hold[$CellContext`kBTtest$$], 0.3, 
       "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.1, 0.5}}, Typeset`size$$ = {
    450., {124., 159.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`ptest$1660$$ = 
    0, $CellContext`kBTtest$1661$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`kBTtest$$ = 0.3, $CellContext`ptest$$ = 
        0.01}, "ControllerVariables" :> {
        Hold[$CellContext`ptest$$, $CellContext`ptest$1660$$, 0], 
        Hold[$CellContext`kBTtest$$, $CellContext`kBTtest$1661$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[(-$CellContext`kBT) 
          Log[$CellContext`v - $CellContext`b] - \
$CellContext`a/$CellContext`v + $CellContext`p $CellContext`v, \
{$CellContext`a -> 1, $CellContext`b -> 
          1, $CellContext`p -> $CellContext`ptest$$, $CellContext`kBT -> \
$CellContext`kBTtest$$}], {$CellContext`v, 0, 40}, 
        AxesLabel -> {$CellContext`v, $CellContext`G}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`ptest$$, 0.01, $CellContext`p}, 
         0.005, 0.04}, {{$CellContext`kBTtest$$, 0.3, 
          "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.1, 0.5}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`ptest$$, $CellContext`kBTtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {212., 219.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 3.7: Volume per particle as a function of temperature and pressure, in \
a 3D plot, for van der Waals theory with parameters a=1 and b=1.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJytvXlUj9HX/12ppJJGzfM8EA2GxHVliqRkaB4UKREZIpkpQ6WQECFDKVSG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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmwn4VsP7xt/znjnzRiVFi11FIlq00aIkaaMkaRVJipIUspV9J2RLiiIK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         "]], Polygon3DBox[CompressedData["
1:eJwtm3fgV9Mfxj/3nnvup4yyQykjSSSVSjREqZRfy84qUkKIyCYNCaGyR0XI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         "]], Polygon3DBox[CompressedData["
1:eJwt12e4VcUdhfHDbYC0UCyACChFioL0jiggXaQpRZp0uKBSBATslEiJaAAL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         "]], 
        Polygon3DBox[{{1524, 1073, 588, 589, 1074, 1525}, {1605, 813, 638, 
         637, 1003, 1463}}]}]}, {}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtkb1KA1EUhM81611LNTaChATFZxC2tLCJFhpJQImgnYLWomBrI8TKPEHS
pYtPEC1tFHwCIwFt1PgDKfwOk+LszJ0z5+feLe2fbB5PmNkykSNW+bTBJuJ3
AOHvYCcx24HPRLNdPHfwLp579FN4A/0DXxneBzOiTjxyHpFboWYNPALz6G0w
N6k+1+gP9Lk0ebz2gJgL8j+h95hVw/OHVgGrxBC+BV5E9SumqvU6n9Eg9wou
RO3iufkgv8/1+VPUbFC7jfZF7hB9AL4keofZqF2y8V38Hv4mV+zTx9My1S4R
vz4XzKd6o72oedl4n0XOP0E9C8Rn0HsO6dM1+X2XW3iL/tOc3/CUfLdEuvd/
ht/A1+GW6p85P+c+PaQz8B+wvTi3
         "]], Polygon3DBox[CompressedData["
1:eJwtkU8rhGEUxe/7zuthYYFBlDQTvoO9hQ3KIIpSlhRrUbY2aqzMbnYzn2Ds
7MZX8A1I5E8aSln4nc4sTt1zz733Ofc+1YOT2nEeEVVQgMpgRLsUUc4izgYi
6inilPwLvEI8Cnbhz/DZ5JouvJO7V1y94+CceISaBvoiM/+Ig5qr3LmHwmgT
L5WszVDzRO8KtI5Whb9lrtesyWQv8nSHvgG+4a9gnbgH7tH2tAPzmoVnfaFP
JEPetUOz/75m/5CbQnuE38LX6B+iv4vX6cw7HZFbpuYy/Jb2Uc975h00Sz2N
3FyzNsEv+jC5WuEbbvd967ba4ZDaXubdVsFN+Ea6RznZzwf6fPJOrdw57TqW
/JY8zBFvgVbYg7zoT/Q3uskF2gLY6fu6Jt4HnfBMzVZOtZ+Za/8BxjtCIg==

         "]], 
        Polygon3DBox[{{1555, 504, 496, 197, 1268}, {1283, 212, 875, 935, 
         1663}, {1631, 860, 693, 196, 1269}, {1607, 824, 653, 151, 1230}, {
         1681, 1108, 1106, 212, 1283}, {1788, 1105, 491, 492, 1552}, {1613, 
         835, 664, 166, 1239}, {1554, 503, 495, 182, 1253}, {1680, 1107, 1105,
          136, 1222}, {1553, 499, 489, 106, 1198}, {1621, 846, 678, 181, 
         1254}}]}]}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0jsvZVEYBuB1jvvdxC0IgogozC/gB4hoBIVEiEY0oyHRioJKQSJRKCUK
pU7JjPs1cZlxT/wB0QgGz6L49vN+e2d9e5+1Tu3gSOevRAhhWvULMXe5PLM3
NYRCduiH5Bp5jD85yVa+eFacHsIr31SV/J/lfOdHHJi0Vp/gLLutTcopKlWV
uZfGdFUnZ7CCmcxSlXI2c9Sc3GN9nvxo9qnxv+Uz/uE5N3nBLf7lNnfUP3mX
l9zjFfd5zQPe8JC3POIdj3nPwrQQTuJP4TrPvPvJd6zK7fKDvCQveN6mn4+z
3ZviBse5xmGusJeLbOcMWzjBZo6ymkNmvXDAvAL2sVQ1+aZ8fSPz2MBc1sc9
Yi2zWRP3j1XMZAXLVYZcFvebJfSaUBTPgj/iubAg+XVsYVlTkvj+b3wCUQw7
Jw==
       "]], 
      Line3DBox[{1168, 76, 1183, 91, 1198, 106, 1213, 121, 1222, 136, 1230, 
       151, 1239, 166, 1254, 181, 1269, 196, 1404, 276, 355, 211, 350, 281, 
       708, 212, 1106, 524, 505, 1112, 1573, 496, 504, 1572, 495, 503, 1571, 
       494, 1560, 502, 493, 1569, 492, 491, 501, 1111, 1568, 490, 1558, 500, 
       489, 499, 1566, 488, 1557, 498, 486, 1564, 487, 1168}]}, {
      Line3DBox[{1114, 1382, 1436, 1853, 1297, 1113, 1546, 1547, 1882, 1298, 
       1115, 1684, 1299, 1116, 1685, 1300, 1117, 1686, 1301, 1118, 1687, 1302,
        1119, 1688, 1574, 1754, 1120, 1689, 1303, 1121, 1690, 1304, 1122, 
       1691, 1305, 1123, 1692, 1306, 1124, 1693, 1307, 1125, 1694, 1308, 1126,
        1660, 1695, 1309, 1383}], 
      Line3DBox[{1127, 1367, 1452, 1507, 1575, 1871, 1451, 1449, 1480, 1862, 
       1310, 1128, 1548, 1549, 1883, 1311, 1129, 1696, 1312, 1130, 1697, 1313,
        1131, 1698, 1314, 1132, 1699, 1576, 1755, 1133, 1577, 1756, 1134, 
       1700, 1315, 1135, 1701, 1316, 1136, 1702, 1317, 1137, 1703, 1318, 1138,
        1704, 1319, 1139, 1705, 1320, 1140}], 
      Line3DBox[{1141, 1450, 1578, 1856, 1481, 1368, 1456, 1508, 1839, 1509, 
       1455, 1453, 1482, 1863, 1321, 1142, 1675, 1706, 1519, 1322, 1143, 1707,
        1323, 1144, 1708, 1324, 1145, 1709, 1579, 1757, 1146, 1580, 1758, 
       1147, 1581, 1759, 1148, 1710, 1325, 1149, 1711, 1326, 1150, 1712, 1327,
        1151, 1713, 1328, 1152, 1714, 1329, 1153}], 
      Line3DBox[{1155, 1582, 1760, 1154, 1454, 1583, 1857, 1483, 1369, 1459, 
       1672, 1840, 1510, 1424, 1665, 1715, 1437, 1330, 1156, 1875, 1520, 1521,
        1331, 1157, 1716, 1332, 1158, 1717, 1584, 1761, 1159, 1585, 1762, 
       1160, 1586, 1763, 1161, 1587, 1764, 1162, 1718, 1333, 1163, 1719, 1334,
        1164, 1720, 1335, 1165, 1721, 1336, 1166}], 
      Line3DBox[{1181, 1339, 1724, 1180, 1338, 1723, 1179, 1337, 1722, 1178, 
       1770, 1593, 1177, 1769, 1592, 1176, 1768, 1591, 1175, 1767, 1590, 1174,
        1876, 1525, 1524, 1877, 1173, 1491, 1490, 1867, 1172, 1415, 1522, 
       1414, 1846, 1523, 1171, 1448, 1370, 1438, 1864, 1655, 1484, 1170, 1511,
        1872, 1458, 1460, 1457, 1169, 1766, 1589, 1167, 1765, 1588, 1556}], 
      Line3DBox[{1196, 1340, 1725, 1195, 796, 1194, 1776, 1599, 1193, 1775, 
       1598, 1192, 1774, 1597, 1191, 1082, 1532, 1190, 1879, 1529, 1528, 1189,
        1847, 1417, 1526, 1416, 1527, 1878, 1188, 1505, 1385, 1492, 1384, 
       1031, 1187, 1371, 1439, 1865, 1656, 1485, 1186, 1512, 1461, 1462, 1858,
        1671, 1185, 1773, 1596, 1184, 1772, 1595, 1182, 1771, 1594, 1565}], 
      Line3DBox[{1211, 808, 1210, 1785, 1604, 1209, 1784, 1603, 1208, 1537, 
       1783, 1678, 1207, 1677, 1782, 1536, 1206, 1666, 1781, 1533, 1535, 1534,
        1205, 1676, 1880, 1531, 1530, 1373, 1204, 1843, 1372, 1493, 1495, 
       1494, 1868, 1203, 1443, 1444, 1386, 1406, 1842, 1664, 1202, 1441, 1442,
        1425, 1849, 1661, 1201, 1780, 1602, 1200, 1779, 1601, 1199, 1778, 
       1600, 1197, 1777, 1561}], 
      Line3DBox[{120, 630, 119, 629, 118, 628, 117, 460}], 
      Line3DBox[{1220, 1352, 1539, 1093, 1219, 1351, 1538, 1733, 1679, 1218, 
       1350, 1732, 1217, 1349, 1499, 1731, 1668, 1427, 1348, 1428, 1851, 1390,
        1410, 1409, 1388, 1347, 1418, 1844, 1667, 1389, 1408, 1413, 1407, 
       1387, 1346, 1850, 1464, 1426, 1374, 1486, 1859, 1605, 1463, 1870, 1506,
        1345, 1730, 1662, 1518, 1344, 1729, 1673, 1216, 1343, 1728, 1215, 
       1342, 1727, 1214, 1341, 1726, 1212, 809, 1567}], 
      Line3DBox[{1229, 1358, 1421, 1852, 1429, 1468, 1467, 1430, 904, 1398, 
       1357, 1399, 1740, 1658, 1412, 1396, 1420, 1419, 1397, 1739, 1657, 1500,
        1411, 1395, 1498, 1497, 1869, 1466, 1376, 1496, 1487, 1393, 1447, 990,
        1405, 1375, 1446, 1445, 1392, 1881, 1543, 1542, 1514, 1391, 1228, 
       1787, 1606, 1738, 1227, 1356, 1737, 1226, 1355, 1736, 1225, 1354, 1735,
        1224, 1353, 1734, 1223, 816, 1221, 1786, 1682}], 
      Line3DBox[{1252, 1381, 1435, 1380, 1841, 1670, 1251, 1423, 1432, 1422, 
       1848, 1250, 1540, 1470, 1472, 1469, 1860, 1249, 1551, 1515, 1517, 1874,
        1674, 1248, 1799, 1620, 1247, 1798, 1619, 1246, 1797, 1618, 1245, 
       1796, 1617, 1748, 1244, 1363, 1747, 1243, 1362, 1746, 1242, 1795, 1616,
        1241, 1794, 1615, 1240, 1793, 1614, 1570}], 
      Line3DBox[{1267, 1541, 1478, 1479, 1477, 1861, 1266, 1365, 1751, 1265, 
       1810, 1630, 1264, 1809, 1629, 1263, 1808, 1628, 1262, 1807, 1627, 1261,
        1806, 1626, 1260, 1805, 1625, 1750, 1259, 1364, 1749, 1258, 1804, 
       1624, 1257, 1803, 1623, 1256, 1802, 1622, 1255, 1801, 1562}], 
      Line3DBox[{1282, 1366, 1753, 1281, 1823, 1642, 1280, 1822, 1641, 1279, 
       1821, 1640, 1278, 1820, 1639, 1277, 1819, 1638, 1276, 1818, 1637, 1275,
        1817, 1636, 1752, 1274, 1816, 1635, 1273, 1815, 1634, 1272, 1814, 
       1633, 1271, 1813, 1632, 1270, 1812, 1563}], 
      Line3DBox[{1296, 1838, 1654, 1295, 1837, 1653, 1294, 1836, 1652, 1293, 
       1835, 1651, 1292, 1834, 1650, 1291, 1833, 1649, 1290, 1832, 1648, 1289,
        1831, 1830, 1647, 1288, 1829, 1646, 1287, 1828, 1645, 1286, 1827, 
       1644, 1285, 1826, 1643, 1284, 1825, 1683}], 
      Line3DBox[{1433, 1476, 1475, 1434, 1379, 1855, 1669, 1402, 1474, 1473, 
       1431, 1378, 1854, 1504, 1440, 1401, 1503, 1502, 1471, 1377, 1866, 1501,
        1489, 1400, 1545, 1544, 1516, 1745, 1659, 1488, 834, 1465, 1237, 1845,
        1612, 1394, 1550, 1873, 1611, 1513, 1236, 1791, 1610, 1744, 1235, 
       1361, 1743, 1234, 1360, 1742, 1233, 1359, 1741, 1232, 1790, 1609, 1231,
        1789, 1608, 1559}], 
      Line3DBox[{511, 620, 107, 621, 108, 622, 109, 623, 110, 1058, 434, 111, 
       937, 279, 112, 1004, 370, 624, 113, 258, 625, 114, 626, 115, 457, 627, 
       116, 1087}]}, {
      Line3DBox[{527, 1099, 723, 1882, 528, 994, 737, 1862, 556, 422, 997, 
       1839, 423, 571, 424, 1014, 1857, 765, 585, 1766, 777, 598, 1772, 788, 
       609, 1778, 799, 621, 810, 1726, 632, 816, 642, 1789, 825, 654, 1793, 
       836, 665, 1801, 847, 679, 1812, 861, 694, 1825, 1110}], 
      Line3DBox[{529, 724, 1684, 530, 1100, 738, 1883, 557, 996, 752, 1863, 
       572, 1042, 889, 966, 1840, 1049, 1050, 586, 1051, 998, 1872, 1015, 778,
        599, 1773, 789, 610, 1779, 800, 622, 811, 1727, 633, 817, 1734, 643, 
       1790, 826, 655, 1794, 837, 666, 1802, 848, 680, 1813, 862, 695, 1826, 
       876, 709}], 
      Line3DBox[{531, 725, 1685, 532, 739, 1696, 558, 1065, 1066, 1706, 1067, 
       1068, 950, 967, 951, 1715, 981, 1017, 1864, 890, 1016, 891, 1001, 1858,
        999, 1000, 611, 1780, 801, 623, 812, 1728, 634, 818, 1735, 644, 827, 
       1741, 656, 1795, 838, 667, 1803, 849, 681, 1814, 863, 696, 1827, 877, 
       710}], Line3DBox[{533, 726, 1686, 534, 740, 1697, 559, 753, 1707, 573, 
       1069, 1875, 1070, 1071, 1072, 952, 1846, 968, 953, 982, 1019, 1865, 
       892, 1018, 893, 969, 1849, 918, 919, 1058, 1056, 1057, 1729, 635, 819, 
       1736, 645, 828, 1742, 657, 839, 1746, 668, 1804, 850, 682, 1815, 864, 
       697, 1828, 878, 711}], 
      Line3DBox[{535, 727, 1687, 536, 741, 1698, 560, 754, 1708, 574, 766, 
       1716, 587, 1027, 1867, 1028, 1029, 1030, 1031, 938, 916, 917, 1842, 
       939, 993, 940, 920, 942, 941, 937, 1063, 1064, 1062, 922, 1730, 636, 
       820, 1737, 646, 829, 1743, 658, 840, 1747, 669, 851, 1749, 683, 1816, 
       865, 698, 1829, 879, 712}], 
      Line3DBox[{537, 728, 1688, 539, 742, 1699, 561, 755, 1709, 575, 767, 
       1717, 588, 1073, 1877, 1075, 1076, 1077, 1878, 1078, 970, 955, 1032, 
       1033, 1868, 1034, 921, 1021, 1020, 1004, 1002, 1043, 1870, 1003, 637, 
       821, 1738, 647, 830, 1744, 659, 841, 1748, 670, 852, 1750, 684, 866, 
       1752, 699, 1830, 880, 713}], 
      Line3DBox[{541, 730, 1689, 542, 1756, 744, 563, 1758, 757, 577, 1762, 
       769, 590, 1767, 780, 601, 1079, 1879, 791, 613, 1880, 1080, 1081, 971, 
       972, 803, 625, 943, 944, 924, 1005, 814, 1850, 639, 988, 989, 926, 
       1098, 1881, 823, 649, 1102, 1103, 1101, 1873, 832, 661, 1797, 843, 672,
        1806, 854, 686, 1818, 868, 701, 1832, 882, 715}], 
      Line3DBox[{543, 731, 1690, 544, 745, 1700, 564, 1759, 758, 578, 1763, 
       770, 591, 1768, 781, 602, 1082, 792, 614, 1781, 956, 804, 626, 895, 
       925, 957, 958, 1844, 959, 945, 897, 927, 990, 991, 650, 928, 1845, 833,
        662, 1798, 844, 673, 1807, 855, 687, 1819, 869, 702, 1833, 883, 716}],
       Line3DBox[{545, 732, 1691, 546, 746, 1701, 565, 759, 1710, 579, 1764, 
       771, 592, 1769, 782, 603, 1774, 793, 615, 1782, 1083, 805, 627, 1084, 
       896, 973, 975, 1851, 976, 640, 946, 898, 929, 1035, 1869, 1036, 651, 
       1055, 1006, 1023, 834, 663, 1799, 845, 674, 1808, 856, 688, 1820, 870, 
       703, 1834, 884, 717}], 
      Line3DBox[{547, 733, 1692, 548, 747, 1702, 566, 760, 1711, 580, 772, 
       1718, 593, 1770, 783, 604, 1775, 794, 616, 1783, 1085, 1086, 1087, 
       1088, 960, 974, 961, 1731, 1037, 1038, 899, 1039, 900, 1739, 947, 931, 
       1025, 905, 1024, 906, 1745, 1061, 1874, 1059, 1060, 675, 1809, 857, 
       689, 1821, 871, 704, 1835, 885, 718}], 
      Line3DBox[{549, 734, 1693, 550, 748, 1703, 567, 761, 1712, 581, 773, 
       1719, 594, 784, 1722, 605, 1776, 795, 617, 1784, 806, 628, 815, 1732, 
       641, 901, 930, 902, 1740, 948, 933, 949, 907, 1040, 1866, 908, 1026, 
       1009, 1007, 1860, 1104, 1008, 676, 1810, 858, 690, 1822, 872, 705, 
       1836, 886, 719}], 
      Line3DBox[{551, 735, 1694, 552, 749, 1704, 568, 762, 1713, 582, 774, 
       1720, 595, 785, 1723, 606, 796, 618, 1785, 807, 629, 1089, 1090, 1733, 
       1091, 903, 932, 904, 978, 992, 909, 1041, 1854, 910, 983, 979, 963, 
       1848, 1097, 964, 677, 859, 1751, 691, 1823, 873, 706, 1837, 887, 720}],
       Line3DBox[{553, 914, 915, 1695, 554, 750, 1705, 569, 763, 1714, 583, 
       775, 1721, 596, 786, 1724, 607, 797, 1725, 619, 808, 630, 1092, 1093, 
       1094, 1095, 1096, 977, 1852, 962, 652, 911, 934, 1855, 985, 984, 980, 
       986, 987, 1841, 965, 912, 1012, 1010, 1861, 1011, 692, 874, 1753, 707, 
       1838, 888, 721}], 
      Line3DBox[{714, 881, 1831, 700, 867, 1817, 685, 853, 1805, 671, 842, 
       1796, 660, 831, 1791, 648, 822, 1787, 638, 813, 1859, 1022, 1054, 1053,
        624, 802, 1052, 923, 1843, 894, 612, 790, 1847, 954, 600, 779, 1876, 
       1074, 589, 768, 1761, 576, 756, 1757, 562, 743, 1755, 540, 729, 1754, 
       538}], Line3DBox[{936, 913, 722, 1853, 526, 1044, 1045, 995, 1046, 
       1871, 736, 555, 1047, 1048, 1013, 1856, 751, 570, 1760, 764, 584, 1765,
        776, 597, 1771, 787, 608, 1777, 798, 620, 809, 631, 1786, 
       1109}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJzcu1dQVF3XNYqAICAGgqggyQSICQVBhEkQJEiOIjmDiEgGRRQQFSSDICBB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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["p", TraditionalForm], 
    FormBox[
     RowBox[{"\"\\!\\(\\*SubscriptBox[\\(k\\), \\(B\\)]\\)\"", " ", "T"}], 
     TraditionalForm], 
    FormBox["v", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0.01, 0.05}, {0.2, 0.35}, {0, 21}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 3.9: Gibbs free energy for van der Waals theory, with the parameters \
a=1 and b=1, near the critical point.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`kBTtest$$ = Rational[
    8, 27], $CellContext`ptest$$ = Rational[1, 27], Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`ptest$$], 
       Rational[1, 27], $CellContext`p}, 0.02, 0.05}, {{
       Hold[$CellContext`kBTtest$$], 
       Rational[8, 27], "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.25, 0.4}}, 
    Typeset`size$$ = {450., {128., 163.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`ptest$1759$$ = 0, $CellContext`kBTtest$1760$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`kBTtest$$ = 
        Rational[8, 27], $CellContext`ptest$$ = Rational[1, 27]}, 
      "ControllerVariables" :> {
        Hold[$CellContext`ptest$$, $CellContext`ptest$1759$$, 0], 
        Hold[$CellContext`kBTtest$$, $CellContext`kBTtest$1760$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[(-$CellContext`kBT) 
          Log[$CellContext`v - $CellContext`b] - \
$CellContext`a/$CellContext`v + $CellContext`p $CellContext`v, \
{$CellContext`a -> 1, $CellContext`b -> 
          1, $CellContext`p -> $CellContext`ptest$$, $CellContext`kBT -> \
$CellContext`kBTtest$$}], {$CellContext`v, 0, 14}, 
        AxesLabel -> {$CellContext`v, $CellContext`G}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], "Specifications" :> {{{$CellContext`ptest$$, 
          Rational[1, 27], $CellContext`p}, 0.02, 
         0.05}, {{$CellContext`kBTtest$$, 
          Rational[8, 27], "\!\(\*SubscriptBox[\(k\), \(B\)]\)T"}, 0.25, 
         0.4}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`ptest$$, $CellContext`kBTtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {216., 223.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 4: Landau Theory", "Section"],

Cell[CellGroupData[{

Cell["\<\
Figure 4.1: Free energy from Landau theory for an Ising ferromagnet.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Ttest$$ = 1.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`Ttest$$], 1.5, $CellContext`T}, 0.5, 1.5}}, 
    Typeset`size$$ = {450., {132., 168.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`Ttest$2040$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`Ttest$$ = 1.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`Ttest$$, $CellContext`Ttest$2040$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[(((1/
             2) $CellContext`aprime) ($CellContext`T - $CellContext`Tc)) \
$CellContext`M^2 + ((1/
            4) $CellContext`b0) $CellContext`M^4, {$CellContext`aprime -> 
          1, $CellContext`T -> $CellContext`Ttest$$, $CellContext`Tc -> 
          1, $CellContext`b0 -> 1}], {$CellContext`M, -1, 1}, 
        AxesLabel -> {$CellContext`M, $CellContext`f}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`Ttest$$, 1.5, $CellContext`T}, 0.5, 
         1.5}}, "Options" :> {TrackedSymbols -> {$CellContext`Ttest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {202., 209.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 5: Variational Calculus", "Section"],

Cell[CellGroupData[{

Cell["\<\
Figure 5.1: Bobsled race on the side of a valley, as an example of a \
variational calculus problem.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Xi]$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Xi]$$], 0.5}, 0.01, 3}}, Typeset`size$$ = {
    450., {116., 124.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Xi]$1758$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Xi]$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Xi]$$, $CellContext`\[Xi]$1758$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         Part[
          Plot3D[
          0.5 $CellContext`y^2, {$CellContext`x, -2.5, 
            2.5}, {$CellContext`y, -1, 1}, BoxRatios -> {5, 2, 0.5}, Axes -> 
           False], 1], Black, 
         Part[
          
          ParametricPlot3D[{$CellContext`x, 
            0.9 (Cosh[$CellContext`x/$CellContext`\[Xi]$$]/Cosh[
             2.2/$CellContext`\[Xi]$$]), 
            0.5 (0.9 (Cosh[$CellContext`x/$CellContext`\[Xi]$$]/Cosh[
               2.2/$CellContext`\[Xi]$$]))^2}, {$CellContext`x, -2.2, 2.2}, 
           PlotStyle -> Thick], 1], Blue, 
         Part[
          
          ParametricPlot3D[{$CellContext`x, 0.9, 0.5 
            0.9^2}, {$CellContext`x, -2.2, 2.2}, PlotStyle -> Thick], 1], 
         Green, 
         Sphere[{-2.2, 0.9, 0.5 0.9^2}, 0.1], Red, 
         Sphere[{2.2, 0.9, 0.5 0.9^2}, 0.1]}], 
      "Specifications" :> {{{$CellContext`\[Xi]$$, 0.5}, 0.01, 3}}, 
      "Options" :> {TrackedSymbols -> {$CellContext`\[Xi]$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {172., 179.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 6: Field Theory for Nonuniform Systems", "Section"],

Cell[CellGroupData[{

Cell["\<\
Figure 6.2: Ising model in the disordered phase near an aligning wall.  The \
order parameter profile M(x) is shown as a function of x.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Xi]$$ = 20, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Xi]$$], 20}, 1, 100}}, Typeset`size$$ = {
    450., {135., 171.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Xi]$472$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Xi]$$ = 20}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Xi]$$, $CellContext`\[Xi]$472$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Exp[(-$CellContext`x)/$CellContext`\[Xi]$$], {$CellContext`x, 0, 200},
         AxesLabel -> {"x", "M(x)"}, PlotRange -> {0, 1}, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`\[Xi]$$, 20}, 1, 100}}, 
      "Options" :> {TrackedSymbols -> {$CellContext`\[Xi]$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {205., 212.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 6.3: Ising model in the ordered phase, showing the profile M(x) \
through an interface between spin down and spin up.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x0$$ = 0, $CellContext`\[Xi]$$ = 20, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`x0$$], 0}, -50, 50}, {{
       Hold[$CellContext`\[Xi]$$], 20}, 1, 100}}, Typeset`size$$ = {
    450., {129., 165.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x0$516$$ = 
    0, $CellContext`\[Xi]$517$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x0$$ = 0, $CellContext`\[Xi]$$ = 20}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x0$$, $CellContext`x0$516$$, 0], 
        Hold[$CellContext`\[Xi]$$, $CellContext`\[Xi]$517$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[0.5 Tanh[($CellContext`x - \
$CellContext`x0$$)/$CellContext`\[Xi]$$], {$CellContext`x, -90, 110}, 
        AxesLabel -> {"x", "M(x)"}, PlotRange -> All, 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`x0$$, 0}, -50, 
         50}, {{$CellContext`\[Xi]$$, 20}, 1, 100}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`x0$$, $CellContext`\[Xi]$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {217., 224.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 8: Solids: Crystals and Glasses", "Section"],

Cell[CellGroupData[{

Cell["Figure 8.3a: Simple cubic (sc) crystal structure.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{{{{SphereBox[{1, 1, 1}, 0.3], SphereBox[{1, 1, 2}, 0.3]}, {
      SphereBox[{1, 2, 1}, 0.3], SphereBox[{1, 2, 2}, 0.3]}}, {{
      SphereBox[{2, 1, 1}, 0.3], SphereBox[{2, 1, 2}, 0.3]}, {
      SphereBox[{2, 2, 1}, 0.3], SphereBox[{2, 2, 2}, 0.3]}}}, 
   {AbsoluteThickness[
    3], {{Line3DBox[{{1, 1, 1}, {2, 1, 1}}], 
      Line3DBox[{{1, 1, 2}, {2, 1, 2}}]}, {Line3DBox[{{1, 2, 1}, {2, 2, 1}}], 
      Line3DBox[{{1, 2, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 2, 1}}], Line3DBox[{{1, 1, 2}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 2, 1}}], 
      Line3DBox[{{2, 1, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 1, 2}}], Line3DBox[{{1, 2, 1}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 1, 2}}], Line3DBox[{{2, 2, 1}, {2, 2, 2}}]}}}},
  Boxed->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 8.3b: Body-centered cubic (bcc) crystal structure.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{{{{SphereBox[{1, 1, 1}, 0.25], SphereBox[{1, 1, 2}, 0.25]}, {
      SphereBox[{1, 2, 1}, 0.25], SphereBox[{1, 2, 2}, 0.25]}}, {{
      SphereBox[{2, 1, 1}, 0.25], SphereBox[{2, 1, 2}, 0.25]}, {
      SphereBox[{2, 2, 1}, 0.25], SphereBox[{2, 2, 2}, 0.25]}}}, 
   SphereBox[
    NCache[{Rational[3, 2], Rational[3, 2], Rational[3, 2]}, {1.5, 1.5, 1.5}],
     0.25], 
   {AbsoluteThickness[
    3], {{Line3DBox[{{1, 1, 1}, {2, 1, 1}}], 
      Line3DBox[{{1, 1, 2}, {2, 1, 2}}]}, {Line3DBox[{{1, 2, 1}, {2, 2, 1}}], 
      Line3DBox[{{1, 2, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 2, 1}}], Line3DBox[{{1, 1, 2}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 2, 1}}], 
      Line3DBox[{{2, 1, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 1, 2}}], Line3DBox[{{1, 2, 1}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 1, 2}}], Line3DBox[{{2, 2, 1}, {2, 2, 2}}]}}}},
  Boxed->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 8.3c: Face-centered cubic (fcc) crystal structure.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{{{{SphereBox[{1, 1, 1}, 0.2], SphereBox[{1, 1, 2}, 0.2]}, {
      SphereBox[{1, 2, 1}, 0.2], SphereBox[{1, 2, 2}, 0.2]}}, {{
      SphereBox[{2, 1, 1}, 0.2], SphereBox[{2, 1, 2}, 0.2]}, {
      SphereBox[{2, 2, 1}, 0.2], SphereBox[{2, 2, 2}, 0.2]}}}, {
    SphereBox[NCache[{Rational[3, 2], Rational[3, 2], 1}, {1.5, 1.5, 1}], 
     0.2], SphereBox[
     NCache[{Rational[3, 2], Rational[3, 2], 2}, {1.5, 1.5, 2}], 0.2]}, {
    SphereBox[NCache[{Rational[3, 2], 1, Rational[3, 2]}, {1.5, 1, 1.5}], 
     0.2], SphereBox[
     NCache[{Rational[3, 2], 2, Rational[3, 2]}, {1.5, 2, 1.5}], 0.2]}, {
    SphereBox[NCache[{1, Rational[3, 2], Rational[3, 2]}, {1, 1.5, 1.5}], 
     0.2], SphereBox[
     NCache[{2, Rational[3, 2], Rational[3, 2]}, {2, 1.5, 1.5}], 0.2]}, 
   {AbsoluteThickness[
    3], {{Line3DBox[{{1, 1, 1}, {2, 1, 1}}], 
      Line3DBox[{{1, 1, 2}, {2, 1, 2}}]}, {Line3DBox[{{1, 2, 1}, {2, 2, 1}}], 
      Line3DBox[{{1, 2, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 2, 1}}], Line3DBox[{{1, 1, 2}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 2, 1}}], 
      Line3DBox[{{2, 1, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 1, 2}}], Line3DBox[{{1, 2, 1}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 1, 2}}], Line3DBox[{{2, 2, 1}, {2, 2, 2}}]}}}},
  Boxed->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 8.4: Density in a 2D square lattice as a function of position.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx0nXm8zuXz/w/HeiwHKVuJEoVsUVnyPpVsRVJKSCiyJ4QkRCSVJCTJFiJr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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxEnQW8VsX39Z97nzjn6bwgiNKiYoEdqKAoBnYnIoKdYIKoqFgg2C2iKNgt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         "]], Polygon3DBox[CompressedData["
1:eJwtnWO4JUcXhc/1vce6sZ1MvnBiT+yJMbEmntjWxLZt28nEtm3bzve+WfdH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         "]], Polygon3DBox[CompressedData["
1:eJwl13uUj9UaB/BXMWYwwxiDSIiciTFyzSGVQQeJ5dJU47YcaUnFoY7KULk0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         "]]}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl01toj3Ecx/GvDTvZqa1Y7CRc0LaalDFN0bI2qV3O1bbmMGHKhV3gglBL
SU654EJ2pwiFC4dIkeVsm8NGag4xESYhr4f6P/0+n/fn+/t+n//veZ7yto3N
G8ZFxEdXRVpEorePj3htPZobkWf97bpXEFEjL6WPpEcUKezH2rFKrFFhNbaI
Pi1v5Rv5A/ImrLMw4hLejq3k2+Rd9AX5WXM6sTvyHuwa353MoYvsG1Gzh38j
P4eVYXn0YeyEPn1YLx0Z+vEj/GL5eWiH2gz8D3aDvyjPTInokD/kc/S+y5dm
Rjzis+nRnIjV8sd8kb252GdsHfYEq8yKyMf66anyKr6A75IPYEvc/zS8EBvk
q+WT6U3yMnOeYsXyKVg5/yzpQ381Y7Oa53yJvBgbw7ZgL7D5+pRiQ3SpvIYv
57fKh7Gl5pbh07GX/AL5DHqb/BU/238d5EfUPeDT6SbPeoC/npz3hIhfzqnB
mbUkZ4295m/KT9LfsGPO7zaWZt8h7MrEiKx8z0Gv3fwq+UH5UKr75nd6R/ar
6ZFf1Wcttl5+WX6Gb+HH9GpNXjxzT7nHRnIZf1xeS/eaW69vFdZtXwWWpect
rEHfkuS50T+t8+y3LYb9l2rZJ+fhCOOHa7m9o3w2vdfM79Y1wrn2TKK/Jt+B
3LHFfjObPZsvdIN9ZNzXs05YkfLvVYsV4CdrvVx5HNa4T80c+TsF2saH5H2Q
v+Xdcuwy9721w9wqBcrjbfJuy0WxT6MGfUfoOvtSkzNWVGvuLH39YiE9M+X/
9/oX2Zl1oQ==
       "]]}, {Line3DBox[CompressedData["
1:eJwVzzdOg1EQReGBkiB+J6ihBht2QBKUBktgmyhsQ4NkdkFOEqFgK6SaEok9
kOMK+Fwczbxz56X+2lap2RYRa7jqiZhPR5QxhrlsxEBHxKi+M4lYVZNcxCWe
zSaZiGIqYgaDuOZT3Its195t7CDPP/J7+lfZvlpx1hnfjnF9Wl7m31pvUFP8
DTL8hLzCvcuG3FPnu7wnr5/Cg2yTa+pnUcIwGtyHPQV9zUwd1dZd/Dk+ZVnn
L3CLmMQtn+OqZr/kR+oBDlGQPcmO9d+yE7XX+q71Toy4Zxo/slNZlrtHn5kN
Z//yS+oF15CvY9l6BX+ybn/6B1WbMco=
       "]], Line3DBox[CompressedData["
1:eJwV0MsuQ2EUxfFtaoLgAUSFVARNVVwaDUox8wjM3eMVRCKSUkTaasTjiIiI
iUvrNsFL+HWwsvb6r/2d853Ts7a5utESEetUa4vIdUYU2iPOuyIW+XJ3xCBd
6V50eeyJ5mkJ/7P3jd90RMxhWfMsL+iusS+5xHPYI83Qoq6GfeqKfE/O4lPy
NK9iH+ZjvqObxB5ogs68r+ouCbxB41gJy/CK/XfnfuV93Rh2ak7zBTlJFWef
7aSwexqlPP5jr4GXPWMEy5iHm9+pu8Tq8hEfwu5otzXiQn7DD/l28z/haTnZ
vCf2aj7gW7oB7Jb66cS7yu7Ri9epDytiCZ5yZoX/AwIeN9M=
       "]], Line3DBox[CompressedData["
1:eJwVz8lO03EUhuHTPQkymLCFhVeBV4ATVVBUhLh0AXtdeQNuURyiibW1QLWE
YDAQQGxRBvECHFrQWk2DkhJijNPTxcn7nfO9v/TfzsujyZFERFw3+eaIxZaI
RHvEEn49FDHcFnHPPoSvDkc85fyR/5m/psp5y70kH2mKeKKft/+2L+AX/ap3
W/Kg2xvMcebwl/05VjjXOJvyRbcNnOLM4k/7Mzyq/8xbly+4reEkZwYP7B1+
+5P+vHzX9w7ghL7u3Vl535wzd3Q7vNv42tv+xv/CLLfMzct1t2nc5vXJ49wz
WNQ/5n2X98wPU278P+5pucs3ZPRT9l17Dkv6gndFOelWwDQni7XGN+JHzlXO
S7nXbQUfcdL4zZ7Bbv0H3gv5lNsypjgprNpL+prvfM85ab8ln8CHnBu6Y3LF
HDc3de94Y/igNaLH7T5esf8Hiw5hFQ==
       "]], Line3DBox[CompressedData["
1:eJwV0Lsy3GEcxvEfhRlEiNglkygUriApklugyw3IriEiYtM4jUMk3Ic41Qqd
NKkxBCPGoaRxCHbXWfBRfOd53+f5/t/Z2bp05n1nQUR8x2x5xOqziNTziDW5
XxHRIFcwkIjI2d86t9h/VkW0ygPOsXOTvVDmOWMybfuEZhxxTnQfOEXyjHOo
+2j7jDa8sR3r1r1fzDnn/HNvt33Bgj2JE91fTgnngjMuq/Xz6OR14JTTWBlR
arvkNDi/sC9iUtfFyXI2vPPE/XVJxITM6LvxFTl7jyzT1/tuF1fe+u0+h1/o
t894O8/Nuqc4T+U1b0r22gfRh3NO7vF/4VTKG86ZbsD2DUv6l7jUbfpdCc4t
58J9yP4Df+yvHn+HbouT5PznTMta/TJGeMO45mxzqm13nHfOe84dnIxzGjec
HVmjv+eM+u4B8K9XRQ==
       "]], Line3DBox[CompressedData["
1:eJwV0T0vg2EUh/EjXgeirTYRg8R38LJZMUkMJC0JTdNRvU02X4BJYi5lIaGq
XlsWEoNNxEx8AIkP4NfhyjnP9T/3fZ/kGcmX5lbbIqKIp/6I5WTECiZQSETM
ZiIe+VI6Yg2XqYidgYhjfhhN2QWXk1XVGXTzezjXN+QDsjT68cMn1QQeZJ/e
GeuNGFeXsIh7ftsbb2aHcOCeuvkr3Mm6uArO+H1smd3EreybX9dnzW6o0/JT
pPoibuQ1voFHNDEle1ZfWvvgz/lBXJvN2iXX2g+/siL/rq/Lun33oB1ffKfa
0dpRduLOcsthV3+MCmqygp1e+QzK3BEOUZV9OD/Jj3pjAfPI+wf/8ec7QA==

       "]], Line3DBox[CompressedData["
1:eJwNzckuw2EYxeG3xva/MYSNxMKOC1CJ8QJUiRUJrSFYoGKe3QyJDmFlnpJa
cjFuwbP45Zz3nPPl61vZmS2lImIZ9baIuY6IeYzgpysi3x0xzG/yWyh3RmRk
14j2iEd3BVXkUJY/0QXblH6f7mIPg7oeeoAG3SF9tn1BVjfqn0k06o51/bI/
HPF1myZ5jd7ItmUl3Ltf8ctX5Cf0zf2OPBbd2SRiil/1/psO2N2h2X2qL/iz
iDFU5R82LboL3RnOMSTvpZdo1V3RB7tbeRrT/CeK8rS+QBN5DV/yGSzJMrpx
/2zI1/gJPoeEX8c/iTsxDw==
       "]], Line3DBox[CompressedData["
1:eJwVz1srw3EYwPFnSVjYZpbrFZvYvBjnXHLPK3BecsghImFZlMO8C6d34Z7b
pUSKzy6evr//9/t71m/52YXR+UREzJnXVEQ9G1FLRzz0RlzidC6ibF60fq7K
9WUiLnCK/+FGTLon4py7s3+Gk1o3V9b+3D/lcthIRnTyJf7X95p7J9qNvWNM
asPaj7aqHXFZ50Os88/eUeQ/zAF3z+1jh70h5xm+3Xmv+RbfuzjBlcyT3Ty3
w2X85jaO89/coGmzt8VdecsmjmmtXFH7cn+DS2GFf+NatAJ+citcRa/ZXceE
NqA1tGVtletq3sNb/tFbCvy7WWr+f24Rq/av8R/r+Dc/
       "]], Line3DBox[CompressedData["
1:eJwVz8dKnVEUhuHlXBAbioJ6YtfYe0NFLDj0EryAeA0SEHQk4mXYJXYTu4m9
JJZbMGNHTnzOYPF+a3/v5t9/Ynxi7FtKREyal7SIrxkRo1kRNVidHnGRGbFu
/4Ov2RHPnCH7iBk2VZwe7m/9fGrEk77SPpjssFL/4l63fM7pwn+cMhzglGMF
Z4bTKZ9xOvAvpxj7OSXYpy/ntcunnDZ85CSwlzPl22X6E92a/Rgf9HPuHco9
zo5wFUt5K9jq7oGzFrzn/ucWyN26Qizh/dIv23/is/6O127vNB2mmNPM3dfP
esOtPs/epsvHL/on95rkPU4j3nBysIWTiwnONKdB3uXU4zUnC5s42cl/1Bfx
6uQdTi1ecTKwgfOm/0i+m7OtX5K38JLzrtuQ65xt4iIW8BYwxf7DhPlu/wRh
pkQq
       "]], Line3DBox[CompressedData["
1:eJwVzrkyg2EYhuHXviax1sSBMLbKLhwARRDbSTAKGkdj6SwzzNhqiT1hFNIq
FLhS3PP873O/3/996cXN2Y2qiMjiIxVx2xlxh/mOiJTcSUS864+6Ik5xjjPM
8RfyEif47o7oQ8nuWnvEOkbxx+X0A/aLXKZyFtMo62flDN64pPuOdSn82E+Y
W/HK3ciCPo0m3y1oxgtXcn5QP+K+VeTwrN/TLftewXAlzUW7T9yW3Eajf1zj
iOvFI1dvXuAaZMY7kvp91Jkf+EluCmP40k/IcRS4fvu7ul/zkDuXkEWeu3I+
z/WgbO/QzgHuuYTuENV2PrlaWVN5V1vEP9kUPUM=
       "]], Line3DBox[CompressedData["
1:eJwV0UkrhWEYxvFH7CwMB0URKaWknJOMEXJiyycg83DM88whkYiFMn4f6YQU
thZY+Qx+Fv+e6/5fz/321FvWP9WTSAshLCGeHUIyN4R97KE1EkI51+IczA8h
lhNCN7rwypdh1717XQbazNvmHWyh2V4pd6cbzQthg2sxX9jflM+dL+aY/lk/
gjW+iTvTrcunzjl9o2+V8KvcMurlE92KfKv/sfvEFaPB3U4+8B2I/9/ninRL
8gJi8q9uXl7EHOrcKeQH5Etdn/ODe0eKL8Asd6NLR7V52jyDKdS6l89d64a9
Z5KrMh97Z0I+cj6ao/qUfgjjfCV3qJuQPzO9zXci3Jh5BBXygX5UvrL7be+B
y0UvH8UX165LyjX2s3TD///S/Gb+A2gLPBQ=
       "]], Line3DBox[CompressedData["
1:eJwVzstKFGAYxvHXbS40tQvwUjQPzTSjOc1kHvJ0AbZS8wa01CFPTB5SxwNB
IBSIIAgu1CvQLLW1iIQtApGwhb8WL8/3/P/vC1913+tMf0lEDJre8oi3FRHv
TMK7pjIiKUf0/KOIYllELZbCvpu0GcDH+MLDiEtuQ47rTdxjfZ8/qoqYwOa4
K+yTzOvH+Bv+h91m8x5b4H7Z+Swn///lQUSd/oyf0jfxa/3a7VO301gLd2oy
Jsuv+ucBV2/vOdYgs3LG7hc+zf3BvnrPYjmuUX8h/5VGrLnPca36mXlphtwU
7C7jN3a35Ae9jXuiH/Lf/GkeK3K32LZc0E/wYf7cbrtZxNa4v3Z25Ed9le/g
ElinXMJ2uTv9t/sUv4y94n6aLnPBrftrkRvlurEk1iNX9D334fYe8WtMmg==

       "]], Line3DBox[CompressedData["
1:eJwVzcsr5XEYx/HnrOck4zJrxj9gzYY/gMZZWbNRRFFEyqVkYzOlNCUSks00
My5/gdzv98txGcP+SA7STF6zePf9PO/P8/x+xXUtqeZERLRjLDfiLi/iHn8w
mx/RzS3L3wsjlrwlBRGf8eljRJfullvUJfHNfGP+jWvMuO/kFnT9bi65EfM/
t1fyX28ByvVpfR8u+GE7b3xark1GTPtOB3duPsVX+VV/Js+7fXGXZ27n672V
eOZS/zt5yn2b7sT+EYbkjO5QPsYBJu208qU5ERVuqlGFXLTw+3bm3HzAoHnX
vIcdTLht5n7pev13ixswZ91uy0/eHJTpz/Q92OD77Tzym/JPXZYf960mfp1b
RY/8YGdN/mHnyU7S3MiP2a3hE/wXpORRrkG3ImfsFdl/B8pJUu8=
       "]], Line3DBox[CompressedData["
1:eJwNzrlKHQAQheFRxEblxhVXiIKg2IiIjSBBbGztxFQSIZWWPoC4lL6C4r5d
zVWvb+DSatqYpFBccF9x/YqfM3POzDDVvQNd/RkRMYitLxEnBRGnmFAvFkZM
0tD/LI7YTkT8yI+Y4pXSaTrEP5NnorEoIp+eY0a2ZH9f/od/wctCk7qQXuJQ
PSIvc2vW/BUvG838EnqNv+pRM8tuzZm54ZWhhf+Kbtmtfl5W7s4Crefv+DUt
O5It8lbsL9E7fSW+y1rNVanvsSxLmlmhx/px+a4bq7wkr8LtVTrMf5DnoM3+
V/qINdma2QP5P/4TLw/f1DX0Gf/VY/JKt36Zf+El0M6vpa/IzZG5k5K/6evQ
IX9Dj913/bqsyo0N2kf3/PlblrK3yVunafphtgGddj8BFu5Niw==
       "]], Line3DBox[CompressedData["
1:eJwVzkdOgmEUheHr2MSAYmwogr3jVpxrDMShYO/dTehW7L0kEolGR7oId+DD
4M0933v+m/9mC+WpUl1EFPGaiDhORhwh3xSR854wT5sj5hojvuUvvPAZjMkz
umf50M4BxrlbrpqKGJUfdfv8Hp7kSd27blj34L3L76DMj3BpbtC8M7f5LZR0
994dGNIV3fLL9ct9GECrLlf7t/mn27S3gV6uhesxT/iC3U/5Azd8Ct3ytO5a
Xrezhmyt5ypuzciXulV+BVdyXvem69RdeC/zS5jnu7hk7V7zzFzkK/UR53IC
aX7WHT++bavdjnY06BZ8W5X/AQCGNIM=
       "]], Line3DBox[CompressedData["
1:eJwNztkqhWEYhuF3madkLhHJSXAC9jkDdkSZilJizzzP0ykoh0DJAbBDZGYt
s5JN07Vx977fcz/f/391bT0t3YmIaEV+ccQH3rFdGjFUFLFl7pZHHJZE1JZF
1CCPH+TqCyNy7W94xabuse65zoY9W/aCZ+SgkTvj1rgs5yc8YkS+LhvwzRUz
Q5ZCU0FEptkvX5UfeENKd8m+iGX0cXNmut4nlzQfsCDr5ebNHfm+u9X+XYU0
vour8P6E/R53mNU90j3VmbH/6dzKbxBo4E64Ke6Xu5ZdYVg+LeuUTZjf5qW8
Wf6l/+PcgUluzzuS8jH7KMbRzl3oV+r+A3fJP3A=
       "]]}, {Line3DBox[CompressedData["
1:eJwVz00rhFEYxvFb2RjvxY4yWzRJlCbZaCywkBRl8jKSlVGIabY0srGxYm/K
B6CMT8ECaxtiimxIkZ/F1XXO/3+f85wnmduYztdExIo81UUcN0aMJyLGmiMm
dKo9ImO93hSRl3lstD4iq/u4svmM/UNDxBJWa3ZZ93N32BT3IVvYnmzLMz6D
JXTBXAn7sj7Qn3qO69JF7gQ7l1Npc/eZN5TlkbvAstilHrCvekvW2aSuYJ3c
tR7kOqyvnKvIDbZq7lYPca3Ymv2Ic3dYr9l7neaGsU0u5z379i/4t7zKJLfD
FbgS94MtYr96QRe5I+6Qa/n/J2mVtPvffPNdqlw3tov16Fkspf8AwkA2wQ==

       "]], Line3DBox[CompressedData["
1:eJwV0E0opWEYxvHbRnFwpI6y8jF7JTXla4GMhaKwQSiKWc1kpChfWWiWM4kN
CwsLURasprARCxay9rGjCaUxyjQUv7O4+j/v/b/u5317Swe+tn/JiIg5+Z0V
cZiIGMqLOMI6aU5GLOVG/DdbxN1UxFpOxIjnUfkmn/Q2uV6uRX/DeUuuzef5
GxzLjljhL+xm6pzjgc4zt6DzD5v473p3XELnFk91krisk48tOss6r85JnRe8
1CnDVZ0PuMnnmKX4BC7ik72/zus6T9hv1uudffiY/nb8g8d6z1jlnm3dajxx
XwlfKsXyoFOR/hf8vuzJZ3cV4hCfwiJpt3uGHXjvjh17DfbKderT5Ia5q/Q+
dvJvem1cpU4rVnNT3A1OY5dOgXcNch91BrCZ+8Hd4U8s42u5OqmRSZ1f9rr5
R+mRCfNpvXGc5bvMZrDR8ztdwkq6
       "]], Line3DBox[CompressedData["
1:eJwVzrsuRFEUBuCFyj2ISNB4AiceQmgGY0ahkLgmQ2IoPADN1AoZnQSdI0Mx
lCQSIXEZGomC2iu4JL4pvvx7/2vvfc7QQjG73hARc3w1Rxy2RhyxzWJvRKYl
Yse6sTOiifu2iLP2iH2zijznUffEHTXKZs9y0vkME4zqSh0ReescM9TcvdG/
yJJvpJwwa/ahuzX7lKm3DvzHqey276Fi/SO/eXBu3p1f6z+6GLA/1vfLPvt3
95N67x/Sei8HqfreBbsk9sOsuVNglbyzr7oN6yKbTHnnUp+VVf+Rk9NsmY05
+2Y2Lpd0Kyyz5/2CPpFlrrlihH9swzc4
       "]], Line3DBox[CompressedData["
1:eJwVz70vQ2EYhvGniYjW10RYJBIpG4IgnQxSIpYSElNTg49ouxjQ7sQiqd3A
roN/gKEd/Qsl0bELYfbrcOd6znU/73vOmSyUc6VERBxKJxnxMBixk4rYHI7Y
xdmRiA1zZSiiKkfcVn/EMc7rXuxve/4ciDjj+uwWcUHX4nK6wAqX5e6wKh1u
TzeOl3yNS7jrHgMPdFPdc7pHri5PMur+Z99Rl7bulStwb9jDvXN5Z2fc0eCm
dU1c5tPmhp2mtLiivQ9c1U1wZc9Z5764ObttzOjWuXNdyfd8c73mH9znL8zX
/I29pPmUS+EJVrGmu9WNmdPd/5U1d/963590dIvcFbeEeW4F/wFnZzM0
       "]], Line3DBox[CompressedData["
1:eJwVzjtok3EUhvEjGCG3Bodi26GihXjpJjhIhZbi0nhBXIqmCCYR6mAU1C61
bRB00k4pZAuG0sUpIip06FqN0kUEZ7VDIdFBpJv+Mrw83/+8zzl8x0r3rlUP
RMQT6SUjOumIOwMRn3BKWtmIQi7iJW4NRnzJRCzra7IiVzjvdTd1l3nvfG9K
13xV38OlVERT/9NuivMDtzkJbHAO4Yy+zvvtO8v5hV85o9jkHMVLnHVOwvww
5yDuSl7X4pzAtn5INyxH+tRv2Evr25KR2+a3/FcFU95lTOIOL4cT7rzB8/jZ
vVP6cXf+mZ3GV7zXug/eHfko990bw3nuccxLkfMN5/CPO2/tXbR/hlPAs7oH
uu/4EGf7/+nOjX7HuY6Tuue6PXyBRc4Ip6o7x7mLV3V1XRfX8KR+wXxa/wgb
+NdeWb8vFXlsVuMt4jNOyewpXvD+D/FiRPg=
       "]], Line3DBox[CompressedData["
1:eJwVzzkvxFEUxuEzjX2plAqVrbZWtBrxVxhRSCSiGUMQH8EykYyCQicxzSis
nZlRSIiZVhR8ATqxfADPFL+857zvvefc27O0lmRTEbGIr+aIs/aIAh7bIlKd
EcddAvqkX2+JeKEV+Qm/TO9RbI04xw5q+mVZlc66N4MEU7x8R0RaPYd5fJt1
yv+hRfzhFwuyD/efZZ+0AU1oRM6OqndMyw7U17hCRv9Ab3CLPFZ4NWcP1QNm
DmLYjD7vuJT10n6M8EYxhHFcyMZo1vkMVpHmvTu7qd7AFib0r/xJemRHCXfY
rv+b9yZLaMmfuvllumvuHirqHN2v75T9A3XOOC4=
       "]], Line3DBox[CompressedData["
1:eJwVz70rhXEYxvFbinC8pE7ZxKAUTsmgTikns8RgwWCQDIwoBqQUR0oxkZSX
KMpL/AcWrBSdQd5GJUoZfAzfrue5vr/ffT9PzeBY92heRAyhujiiAz1lEeOl
EZOYwGUyokrfjvXyiMeiiD79k1zz/sVn3EnybdgsiVjFQCJimOuXlfo0Hpy7
xrv+Vt6gXN+KM+e69KcyZf6C2Rd2JLiXwohzZ1/5CtnAN6ERBXwLOrmsvcc4
Qr5uStcsN7wv4uT/G3W/5qY8H9p1gHtzlvV38odr4Pb1e3hDlnuV31w9t+Ib
ZpDTz8lZfHJ1XM6ejH5e7mLaf2xxH2j1HyPOPvI7dl2Z2evOM1crf7ht3RK3
iLT7f3iaPA4=
       "]], Line3DBox[CompressedData["
1:eJwVz0tIlGEYxfEnEVIbr9O0aWNeCARRG0MCUcgCFwrSUoTEjaSgICLuZsyN
oIsCIcJBaCm4c23hKhftxnQlIi4CFS8heCHI3ywOz3nO+b/v+33PRibfTTyI
iCzVlkW8paGKiFwiIvMo4jut8EupiE3+qf41dVVGTJVH1Mvm9afOnGA+8k/0
3dSBmbOnMFlzSP8Hl+GT+k5qxwy4pwgzJh/EHGA+8FX6V9SCuZD34M4L36jL
Y96Y5YV3aBTzt8DIxtyVxv7AvDBL9C9pTV+Ha5D9srdhNzCtZrE9TcP6Fvt7
d9zi1vRHzt3w/0uxmH+yz7hPtG5P4b/JDnGP+Ttcs7xKn7Sv8jVmvz6Hq+av
MU3yBObUvsjP6O+8u4y5Na8wz+UPMWe6fdysfU+3gNk1LzGNsj7MJea3rJd2
aBqTN48x9Zhx/Zb9K3XRNo1ifppf/N89JaVFfA==
       "]], Line3DBox[CompressedData["
1:eJwVzr0rhXEYxvHbYPCe8rIwKINSSsmgFJ0yMCjhD5CZCRvqGDgWHRQ25Rgw
yOBtwoiFsEgoJdlIqaPDx/Dtep7ruu77/tUNjfaN5EXEKOoKI7qwXhSxgmZ0
VkbU8BI4Lo44Qk9pRJrfTav5HTjg72OwJGJBNkAr+O140rvBG/+O3qKc34Z+
M338tFuHmCuzi6ZoqfxM9xQneNWrpS1238sK0Iocb9eeoElzv/IZmi97MbPD
38YWcv/vQhUqkZGHXjMWzUxjCTn7VumzTpp+6j35zhZENOmueeMsfpDFN7+R
v+zGHB7152kKX7IG2aadCX6GXmPS3is6RT90JnTHMYYHvT33zuWXuMC7zjC/
3q6kmxlsoNf/H23/Q/A=
       "]], Line3DBox[CompressedData["
1:eJwVzksoJWAYxvHXkuPWaDYWDkuX2bIZuS5YMRbKQskcS8RqhpTEyoazOmzI
5pytLKhTQ7amxmUxUTZupcmUDCWN/Cye/u/7PM/39tUMj/eNFUTEN+ouivhR
HLFLXeZ0ScQS5T9GLONNYUQ2ETEga8dDGpVlZUfm8dKIY8zZB3V+u3Nh37Vf
4oL8Cvfsk/IJb+fwgXfA+4dpnUf8ad+Xz8uf3EnQKa8YV3VK8LP8jJfRyVGh
ubQsoghf/XVDXm7ekv3Bem/usAGH3v/tzifzX962TjVWUU6WxP/yHfolS/lT
q+6M7AOvzZzHdqzAE51mbzblPbw6Xi8e4hesx1udWfkzfuU18lJ4jiPY9H5H
/iIfdOs7r4M3hdc4jS3yTnOZ/yRpjdap0ptFWUan1t6vs2KecmcV7+1vZL9H
XQ==
       "]], Line3DBox[CompressedData["
1:eJwV0DsoxXEYxvHfcUK5TlLIZcCMXAplUg4GZ8KiTilKLlFKUUwoshkct9Ug
AwPF4JIdg0K5TC6LyWDgc4a37/O8z/N76/+vSIzFRyMhhGkTzwrhPCeEC9ND
b+aGsGFOC0JI4m9eCDNmUBbLDuHBjMkOZY/0rOwJj/hhnWd3PvhJnUu7T3pF
5wuv+BmdKdkqRnRv7NJwXSeKt/ylfE3+xxeZV7ti3NIpwVb5m92uzr7ZcDtp
0uh6+RlGdRvodGzEhDcHdBOdgec61W5Umj1ZFWbbHbvzhCPYoTsnK9OP0dfY
ieX4otPuTS9fw/fhPfZjLX7LF7xNT/0vu2a78dS34AS24J08Uz7kzqJdl90S
vuMytsm76UKdytQ/1WvK9/+w1P0T+TxdJxvQ2/Zmgd/BH/4fiVBBXQ==
       "]], Line3DBox[CompressedData["
1:eJwVz7EvnAEcxvHfDRaKwQmT5FgdmzDVQC0MJRJdTnviEouSJm5QNhEdiLCp
yURYpMNJSBAmIZGoOPwDhqqFhBh8DE+e5/d8n/fN+6ay33tHExGRp+ayiKny
iGlKywMVEY180r1YHVH4EDEuJ3UpqqJPNpfYAjbp/op36hLyNzn4LN6m+2mT
d/foW933pRGv1If/42ldzuaHzUebRndRv42nKyOu5FpdOzZik5Rr6Bz/i+V0
F/wPn6d6uxZsT1fn+V3+pGugDH6C/ZcfaQd74AXe5Bty2JzNFq3qNug33doc
YymbL9gzv9H9wl7kOX7mrpD78Tt+6s7rZ6jDsxP8UPeEf6aizYF7SL+Cl/jW
rLylu8a6bNblTdrHB9/fo8vwMf+/ZrOk3+c9umW7bn7gPrIbtnkDtgNERw==

       "]], Line3DBox[CompressedData["
1:eJwVzzsoBmAYxfHHpdyZlFwGRRhFZGCmRJFLmZiEPlGSAQObQRKjy+AyiYEi
KZFPJokyu242Zr9vOJ3znP/zvr1v5chkTyItImapJS9iqSBimZrl4cKIJr6b
HzFWHLEpX1I51VAZddt5xdbtzJvHne3SFcgTcj5vM6/gc/KgrtX8lxuRbe53
9ldu1E3bmdG122kwf+tP8fqiiC+5WteBTdmplKvoCX/HEro3fq87cc+BvtTu
va7W+SQvxOp0I3Yf8azUO+k29RZ+w0vwVezIHUXyvu6Y9ujTnMSqsSF3pJs/
aBPL4LvYhvwiV9gZsPPDn82L+jVqt7PAk7pMrDf1bn5nntRv4Tnem5AvdO9Y
t50z+Zyu8XGsUzfGD/kyXem38X7dDu/jt84+YKP+9g/rsUB0
       "]], Line3DBox[CompressedData["
1:eJwVz7srxXEYx/HHdBzXIoNcyoZ/wS2TBUWUGI7LYCCHAaPrxiHLEStlNYg/
wGTgWCxSKAqDyyAW5XWGd5/v83k/337fX8N4un+mICIm0VoccY6uoojt0ogM
tpCtinhORkyVRQxxnXYucYVpXU4O629KIvbt3psfsM49yjluVr8sP8yf2OG+
5Ipunvt2N4FC7HEPuqTzLn+EivKISvx5xwX36l0H9lZ0q3gzN9pvQoo/5Jqd
T9yt42pQm7/DJXSn/JWc8IY+XZvddpzpO+Q112L/mOs29yDH9coXbkn/I1Pm
UdxxY/JXt8aNuDtvXsAT96ZbdC7zvXqk+VlU27/lBuxs+I9NZDBozub/H+/O
//dtPZk=
       "]], Line3DBox[CompressedData["
1:eJwVzzsvw2EYhvGnWJTW5LAYRH0B7DWIwyYSTCTEYahDYsEo0VqKRQRJxRfo
ZjewGMyOaWJSiUHCWvw6XLnf576e93/oWdiYXE9ExBKyLRF3mEhGnKciTnGG
4/aIz+aI7XTEIjdu5xHr+ie5o3+Wy1ylNaKkfzdXUeQ+6jvcpr4oa+ZfnHB/
8kC3xdXc7UBn/Rlcl7zkykj5jjQSzvd2E3y+LaKAfTSY++0PYJ4vmwedr+33
8b3IoMwldTf8q8x5/4i9UdzqxmRFP+xdV3anzNN44GbkF7erb3QvZ17FG7cm
m3R5bsXdPXMeVa5Q/y8ug6xvGEK357zYneW/cag7wpxzyf4Ffpz/AaY7OfA=

       "]]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0nXW4VsX39lFCCQHpkpBukK5nQLq7pLvLoEG6G6Qbpb8i3QwcuqW7O48I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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["\[Rho]", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-1.5, 1.5}, {-1.5, 1.5}, {0., 4.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 8.8a: Calculation of the packing fraction for a simple cubic (sc) \
lattice.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[
    0.6], {{SphereBox[{1, 1, 1}, 0.5], SphereBox[{1, 1, 2}, 0.5]}, {
      SphereBox[{1, 2, 1}, 0.5], SphereBox[{1, 2, 2}, 0.5]}}, {{
      SphereBox[{2, 1, 1}, 0.5], SphereBox[{2, 1, 2}, 0.5]}, {
      SphereBox[{2, 2, 1}, 0.5], SphereBox[{2, 2, 2}, 0.5]}}}, 
   {AbsoluteThickness[3], Opacity[
    1], {{Line3DBox[{{1, 1, 1}, {2, 1, 1}}], 
      Line3DBox[{{1, 1, 2}, {2, 1, 2}}]}, {Line3DBox[{{1, 2, 1}, {2, 2, 1}}], 
      Line3DBox[{{1, 2, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 2, 1}}], Line3DBox[{{1, 1, 2}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 2, 1}}], 
      Line3DBox[{{2, 1, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 1, 2}}], Line3DBox[{{1, 2, 1}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 1, 2}}], Line3DBox[{{2, 2, 1}, {2, 2, 2}}]}}, 
    Text3DBox[
     FormBox[
      StyleBox["a",
       StripOnInput->False,
       FontSize->Large], StandardForm], 
     NCache[{Rational[3, 2], 0.95, 0.95}, {1.5, 0.95, 0.95}]], 
    Arrow3DBox[{{1.6, 0.94, 0.94}, {2, 0.94, 0.94}}], 
    Arrow3DBox[{{1.4, 0.94, 0.94}, {1, 0.94, 0.94}}]}},
  Boxed->False,
  ViewPoint->{0, -3, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 8.8b: Calculation of the packing fraction for a face-centered cubic \
(fcc) lattice.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[
    0.6], {{{SphereBox[{1, 1, 1}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
       SphereBox[{1, 1, 2}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}, {
       SphereBox[{1, 2, 1}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
       SphereBox[{1, 2, 2}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}}, {{
       SphereBox[{2, 1, 1}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
       SphereBox[{2, 1, 2}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}, {
       SphereBox[{2, 2, 1}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
       SphereBox[{2, 2, 2}, NCache[
        Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}}}, {
     SphereBox[NCache[{Rational[3, 2], Rational[3, 2], 1}, {1.5, 1.5, 1}], 
      NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
     SphereBox[NCache[{Rational[3, 2], Rational[3, 2], 2}, {1.5, 1.5, 2}], 
      NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}, {
     SphereBox[NCache[{Rational[3, 2], 1, Rational[3, 2]}, {1.5, 1, 1.5}], 
      NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
     SphereBox[NCache[{Rational[3, 2], 2, Rational[3, 2]}, {1.5, 2, 1.5}], 
      NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}, {
     SphereBox[NCache[{1, Rational[3, 2], Rational[3, 2]}, {1, 1.5, 1.5}], 
      NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
     SphereBox[NCache[{2, Rational[3, 2], Rational[3, 2]}, {2, 1.5, 1.5}], 
      NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}}, 
   {AbsoluteThickness[3], Opacity[
    1], {{Line3DBox[{{1, 1, 1}, {2, 1, 1}}], 
      Line3DBox[{{1, 1, 2}, {2, 1, 2}}]}, {Line3DBox[{{1, 2, 1}, {2, 2, 1}}], 
      Line3DBox[{{1, 2, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 2, 1}}], Line3DBox[{{1, 1, 2}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 2, 1}}], 
      Line3DBox[{{2, 1, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 1, 2}}], Line3DBox[{{1, 2, 1}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 1, 2}}], Line3DBox[{{2, 2, 1}, {2, 2, 2}}]}}, 
    Text3DBox[
     FormBox[
      StyleBox["a",
       StripOnInput->False,
       FontSize->Large], StandardForm], 
     NCache[{Rational[3, 2], 0.95, 0.95}, {1.5, 0.95, 0.95}]], 
    Arrow3DBox[{{1.6, 0.94, 0.94}, {2, 0.94, 0.94}}], 
    Arrow3DBox[{{1.4, 0.94, 0.94}, {1, 0.94, 0.94}}], Text3DBox[
     FormBox[
      StyleBox["d",
       StripOnInput->False,
       FontSize->Large], StandardForm], 
     NCache[{Rational[3, 2], 1, Rational[3, 2]}, {1.5, 1, 1.5}]], 
    Arrow3DBox[
     NCache[{{1.6, 1, Rational[3, 2]}, {
       Rational[3, 2] + Rational[1, 2] 2^Rational[-1, 2], 1, Rational[
        3, 2]}}, {{1.6, 1, 1.5}, {1.8535533905932737`, 1, 1.5}}]], 
    Arrow3DBox[
     NCache[{{1.4, 1, Rational[3, 2]}, {
       Rational[3, 2] + Rational[-1, 2] 2^Rational[-1, 2], 1, Rational[
        3, 2]}}, {{1.4, 1, 1.5}, {1.1464466094067263`, 1, 1.5}}]]}},
  Boxed->False,
  ViewPoint->{0, -3, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 8.9: Alternative view of the fcc lattice, showing the hexagonal layers.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.24720000000000014`, 0.24, 0.6], Opacity[0.7], 
   SphereBox[{1, 1, 1}, NCache[
    Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
   {RGBColor[0.6, 0.24, 0.4428931686004542], 
    SphereBox[{1, 1, 2}, NCache[
     Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[{1, 2, 1}, NCache[
     Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[{2, 1, 1}, NCache[
     Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[NCache[{Rational[3, 2], Rational[3, 2], 1}, {1.5, 1.5, 1}], 
     NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[NCache[{Rational[3, 2], 1, Rational[3, 2]}, {1.5, 1, 1.5}], 
     NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[NCache[{1, Rational[3, 2], Rational[3, 2]}, {1, 1.5, 1.5}], 
     NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}, 
   {RGBColor[0.6, 0.5470136627990908, 0.24], 
    SphereBox[{1, 2, 2}, NCache[
     Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[{2, 1, 2}, NCache[
     Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[{2, 2, 1}, NCache[
     Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[NCache[{Rational[3, 2], Rational[3, 2], 2}, {1.5, 1.5, 2}], 
     NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[NCache[{Rational[3, 2], 2, Rational[3, 2]}, {1.5, 2, 1.5}], 
     NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]], 
    SphereBox[NCache[{2, Rational[3, 2], Rational[3, 2]}, {2, 1.5, 1.5}], 
     NCache[Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}, 
   {RGBColor[0.24, 0.6, 0.33692049419863584`], 
    SphereBox[{2, 2, 2}, NCache[
     Rational[1, 2] 2^Rational[-1, 2], 0.35355339059327373`]]}, 
   {GrayLevel[0], AbsoluteThickness[3], Opacity[
    1], {{Line3DBox[{{1, 1, 1}, {2, 1, 1}}], 
      Line3DBox[{{1, 1, 2}, {2, 1, 2}}]}, {Line3DBox[{{1, 2, 1}, {2, 2, 1}}], 
      Line3DBox[{{1, 2, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 2, 1}}], Line3DBox[{{1, 1, 2}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 2, 1}}], 
      Line3DBox[{{2, 1, 2}, {2, 2, 2}}]}}, {{
      Line3DBox[{{1, 1, 1}, {1, 1, 2}}], Line3DBox[{{1, 2, 1}, {1, 2, 2}}]}, {
      Line3DBox[{{2, 1, 1}, {2, 1, 2}}], Line3DBox[{{2, 2, 1}, {2, 2, 2}}]}}}},
  Boxed->False,
  ViewPoint->{2, -2, 2},
  ViewVertical->{1, 1, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 8.11a: Stretching of a spring by a force F.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.24720000000000014`, 0.24, 0.6], Thickness[0.01], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Line3DBox[CompressedData["
1:eJwcm3VU1N/Tx+kGlxIJEcQCRQWUML5zRREpQWkVsVABA4swEBAEUQRRREBS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      "]]}}, Arrow3DBox[{{0, 1, 0}, {-2, 1, 0}}], Text3DBox[
    FormBox["F", StandardForm], {-1, 1, -0.5}], 
   Arrow3DBox[{{10.053096491487338`, 1, 0}, {12.053096491487338`, 1, 0}}], 
   Text3DBox[
    FormBox["F", StandardForm], {11.053096491487338`, 1, -0.5}], Text3DBox[
    FormBox["L", StandardForm], {3.7699111843077517`, 1, -2}], 
   Arrow3DBox[
    NCache[{{Pi, 1, -2}, {0, 1, -2}}, {{3.141592653589793, 1, -2}, {0, 
      1, -2}}]], 
   Arrow3DBox[{{4.39822971502571, 1, -2}, {7.5398223686155035`, 1, -2}}], 
   Text3DBox[
    FormBox[
     RowBox[{"\[CapitalDelta]", " ", "x"}], StandardForm], {
    8.79645943005142, 1, -2}], 
   Arrow3DBox[{{8.168140899333462, 1, -2}, {7.5398223686155035`, 1, -2}}], 
   Arrow3DBox[
    NCache[{{3 Pi, 1, -2}, {10.053096491487338`, 1, -2}}, {{
      9.42477796076938, 1, -2}, {10.053096491487338`, 1, -2}}]]},
  BaseStyle->{FontSize -> Scaled[0.05]},
  Boxed->False,
  ViewPoint->{0.9992677332085451, -3.0000354155509465`, 0.03537658559437482},
  ViewVertical->{-0.03673728338825908, -0.003179898544004829, 
   4.5301963301219095`}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 8.11b: Stretching of an elastic rod with initial length L and \
cross-sectional area A.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{CylinderBox[{{0, 1, 0}, {10.053096491487338`, 1, 0}}], 
   {RGBColor[0.24720000000000014`, 0.24, 0.6], Thickness[0.01], 
    Arrow3DBox[{{0, 1, 0}, {-2, 1, 0}}], Text3DBox[
     FormBox["F", StandardForm], {-1, 1, -0.5}], 
    Arrow3DBox[{{10.053096491487338`, 1, 0}, {12.053096491487338`, 1, 0}}], 
    Text3DBox[
     FormBox["F", StandardForm], {11.053096491487338`, 1, -0.5}], Text3DBox[
     FormBox["L", StandardForm], {3.7699111843077517`, 1, -2}], 
    Arrow3DBox[
     NCache[{{Pi, 1, -2}, {0, 1, -2}}, {{3.141592653589793, 1, -2}, {0, 
       1, -2}}]], 
    Arrow3DBox[{{4.39822971502571, 1, -2}, {7.5398223686155035`, 1, -2}}], 
    Text3DBox[
     FormBox[
      RowBox[{"\[CapitalDelta]", " ", "x"}], StandardForm], {
     8.79645943005142, 1, -2}], 
    Arrow3DBox[{{8.168140899333462, 1, -2}, {7.5398223686155035`, 1, -2}}], 
    Arrow3DBox[
     NCache[{{3 Pi, 1, -2}, {10.053096491487338`, 1, -2}}, {{
       9.42477796076938, 1, -2}, {10.053096491487338`, 1, -2}}]], 
    {RGBColor[0.6, 0.24, 0.4428931686004542], 
     Arrow3DBox[{{11.553096491487338`, 1, 1}, {10.053096491487338`, 1, 0.5}}],
      Text3DBox[
      FormBox["A", StandardForm], {11.953096491487338`, 1, 1.1}]}}},
  BaseStyle->{FontSize -> Scaled[0.05]},
  Boxed->False,
  ViewPoint->{0.9992677332085451, -3.0000354155509465`, 0.03537658559437482},
  ViewVertical->{-0.03673728338825908, -0.003179898544004829, 
   4.5301963301219095`}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 8.12: Shear deformation of a material.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0.87, 0.94, 1], Opacity[0.1], EdgeForm[{Thickness[Large], 
    Dashing[{Small, Small}]}], 
    HexahedronBox[{{0, 0, 0}, {4, 0, 0}, {4, 3, 0}, {0, 3, 0}, {0, 0, 2}, {4, 
     0, 2}, {4, 3, 2}, {0, 3, 2}}]}, 
   {RGBColor[0.87, 0.94, 1], Opacity[0.9], EdgeForm[Thickness[Large]], 
    HexahedronBox[{{0, 0, 0}, {4, 0, 0}, {4, 3, 0}, {0, 3, 0}, {1.2, 0, 2}, {
      5.2, 0, 2}, {5.2, 3, 2}, {1.2, 3, 2}}], 
    {GrayLevel[0], Text3DBox[
      FormBox[
       RowBox[{"\[CapitalDelta]", " ", "x"}], StandardForm], {0.6, 3, 2.3}], 
     Arrow3DBox[{{0.3, 3, 2.3}, {0, 3, 2.3}}], 
     Arrow3DBox[{{0.8999999999999999, 3, 2.3}, {1.2, 3, 2.3}}], Text3DBox[
      FormBox["L", StandardForm], {-0.3, 3, 1.}], 
     Arrow3DBox[{{-0.3, 3, 1.3}, {-0.3, 3, 2}}], 
     Arrow3DBox[{{-0.3, 3, 0.7}, {-0.3, 3, 0}}], Text3DBox[
      FormBox["\<\"Area A\"\>", StandardForm], {2.6, 1.5, 2}], 
     {Thickness[0.01], Arrow3DBox[{{3.2, 1.5, 2}, {6., 1.5, 2}}], Text3DBox[
       FormBox["F", StandardForm], {5.8, 1.5, 2.3}], 
      Arrow3DBox[{{2., 1.5, 0}, {-0.8, 1.5, 0}}], Text3DBox[
       FormBox["F", StandardForm], {-0.6, 1.5, -0.3}]}}}},
  BaseStyle->{FontSize -> Scaled[0.04]},
  Boxed->False,
  ViewPoint->{-1, -3, 0.6},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 8.13: Schematic illustration of someone holding a material on top of \
his fingers, to determine whether it is a solid or a liquid.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0.24, 0.6, 0.33692049419863584`], Opacity[0.1], EdgeForm[{
    Thickness[Large], Dashing[{Small, Small}]}], 
    HexahedronBox[{{-1, -1, 0}, {1, -1, 0}, {1, 1, 0}, {-1, 1, 0}, {-1, -1, 
     1}, {1, -1, 1}, {1, 1, 1}, {-1, 1, 1}}]}, 
   {RGBColor[0.24, 0.6, 0.33692049419863584`], Opacity[0.9], EdgeForm[
    Thickness[Large]], 
    HexahedronBox[{{0, -1, -0.2}, {1, -1, 0}, {1, 1, 0}, {0, 1, -0.2}, {
      0, -1, 0.8}, {1, -1, 1}, {1, 1, 1}, {0, 1, 0.8}}], 
    HexahedronBox[{{0, -1, -0.2}, {-1, -1, 0}, {-1, 1, 0}, {0, 1, -0.2}, {
      0, -1, 0.8}, {-1, -1, 1}, {-1, 1, 1}, {0, 1, 0.8}}]}, 
   CylinderBox[{{-1, -1, -0.35}, {-1, 1, -0.35}}, 0.35], 
   CylinderBox[{{1, -1, -0.35}, {1, 1, -0.35}}, 0.35], Text3DBox[
    FormBox["\<\"Finger 1\"\>", StandardForm], {-1, -1, -0.35}], Text3DBox[
    FormBox["\<\"Finger 2\"\>", StandardForm], {1, -1, -0.35}], 
   {Thickness[0.01], Arrow3DBox[{{0, 0, -0.2}, {0, 0, -1.005}}], Text3DBox[
     FormBox["\<\"Gravity\"\>", StandardForm], {-0.3, 0, -0.7}], 
    Arrow3DBox[{{-1, 0, 0}, {-1, 0, 1.3}}], 
    Arrow3DBox[{{1, 0, 0}, {1, 0, 1.3}}], Text3DBox[
     FormBox["\<\"Normal force\"\>", StandardForm], {1, -0.4, 0.5}, {0, 0}, {
     0, 1}]}},
  BaseStyle->{FontSize -> Scaled[0.04]},
  Boxed->False,
  ViewPoint->{1, -3, 0.5},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 8.14: Escape of a test atom (shown in blue) from a cage of its \
neighbors (shown in yellow), as part of a microscopic model for viscosity.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], Opacity[0.8], SphereBox[{1, 1, 1}, 0.27], 
   SphereBox[{1, 1, 2}, 0.27], SphereBox[{1, 2, 1}, 0.27], 
   SphereBox[{1, 2, 2}, 0.27], 
   SphereBox[NCache[{Rational[3, 2], Rational[3, 2], 1}, {1.5, 1.5, 1}], 
    0.27], SphereBox[
    NCache[{Rational[3, 2], 1, Rational[3, 2]}, {1.5, 1, 1.5}], 0.27], 
   SphereBox[NCache[{Rational[3, 2], Rational[3, 2], 2}, {1.5, 1.5, 2}], 
    0.27], SphereBox[
    NCache[{Rational[3, 2], 2, Rational[3, 2]}, {1.5, 2, 1.5}], 0.27], 
   SphereBox[NCache[{Rational[1, 2], Rational[3, 2], 1}, {0.5, 1.5, 1}], 
    0.27], SphereBox[
    NCache[{Rational[1, 2], 1, Rational[3, 2]}, {0.5, 1, 1.5}], 0.27], 
   SphereBox[NCache[{Rational[1, 2], Rational[3, 2], 2}, {0.5, 1.5, 2}], 
    0.27], SphereBox[
    NCache[{Rational[1, 2], 2, Rational[3, 2]}, {0.5, 2, 1.5}], 0.27], 
   {RGBColor[0, 0, 1], 
    SphereBox[NCache[{1, Rational[3, 2], Rational[3, 2]}, {1, 1.5, 1.5}], 
     0.27]}, 
   {GrayLevel[0], Arrowheads[0.1], 
    Arrow3DBox[TubeBox[
     NCache[{{1.27, Rational[3, 2], Rational[3, 2]}, {
       2.1, Rational[3, 2], Rational[3, 2]}}, {{1.27, 1.5, 1.5}, {2.1, 1.5, 
      1.5}}], 0.02]], Text3DBox[
     FormBox["\<\"Escape\"\>", StandardForm], {2.15, 1.5, 1.55}]}},
  BaseStyle->{FontSize -> Scaled[0.04]},
  Boxed->False,
  ViewPoint->{1.3664711219934211`, -2.3323518324126455`, 2.0354094434779997`},
  ViewVertical->{0.7130139496858132, 0.2081687950039015, 
   0.7910771729883539}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 9: Tensors", "Section"],

Cell[CellGroupData[{

Cell["\<\
Figure 9.2: Proposed method for visualizing a tensor (with a total of nine \
degrees of freedom).  The visualization has three parts:  isotropic (one \
degree of freedom), anisotropic symmetric (five degrees of freedom), and \
antisymmetric (three degrees of freedom).\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Txx$$ = 
    0.8648594855799372, $CellContext`Txy$$ = 
    0.5591865872801267, $CellContext`Txz$$ = 
    0.9392815909393706, $CellContext`Tyx$$ = 
    0.5144948525797242, $CellContext`Tyy$$ = -0.22634754114296607`, \
$CellContext`Tyz$$ = 
    0.9596721224824152, $CellContext`Tzx$$ = -0.47240365628588377`, \
$CellContext`Tzy$$ = -0.7159889505159249, $CellContext`Tzz$$ = \
-0.4982009562843377, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`Txx$$], 0.8648594855799372}, -1, 1}, {{
       Hold[$CellContext`Txy$$], 0.5591865872801267}, -1, 1}, {{
       Hold[$CellContext`Txz$$], 0.9392815909393706}, -1, 1}, {{
       Hold[$CellContext`Tyx$$], 0.5144948525797242}, -1, 1}, {{
       Hold[$CellContext`Tyy$$], -0.22634754114296607`}, -1, 1}, {{
       Hold[$CellContext`Tyz$$], 0.9596721224824152}, -1, 1}, {{
       Hold[$CellContext`Tzx$$], -0.47240365628588377`}, -1, 1}, {{
       Hold[$CellContext`Tzy$$], -0.7159889505159249}, -1, 1}, {{
       Hold[$CellContext`Tzz$$], -0.4982009562843377}, -1, 1}}, 
    Typeset`size$$ = {450., {221., 229.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`Txx$2412$$ = 0, $CellContext`Txy$2413$$ = 
    0, $CellContext`Txz$2414$$ = 0, $CellContext`Tyx$2415$$ = 
    0, $CellContext`Tyy$2416$$ = 0, $CellContext`Tyz$2417$$ = 
    0, $CellContext`Tzx$2418$$ = 0, $CellContext`Tzy$2419$$ = 
    0, $CellContext`Tzz$2420$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`Txx$$ = 
        0.8648594855799372, $CellContext`Txy$$ = 
        0.5591865872801267, $CellContext`Txz$$ = 
        0.9392815909393706, $CellContext`Tyx$$ = 
        0.5144948525797242, $CellContext`Tyy$$ = -0.22634754114296607`, \
$CellContext`Tyz$$ = 
        0.9596721224824152, $CellContext`Tzx$$ = -0.47240365628588377`, \
$CellContext`Tzy$$ = -0.7159889505159249, $CellContext`Tzz$$ = \
-0.4982009562843377}, "ControllerVariables" :> {
        Hold[$CellContext`Txx$$, $CellContext`Txx$2412$$, 0], 
        Hold[$CellContext`Txy$$, $CellContext`Txy$2413$$, 0], 
        Hold[$CellContext`Txz$$, $CellContext`Txz$2414$$, 0], 
        Hold[$CellContext`Tyx$$, $CellContext`Tyx$2415$$, 0], 
        Hold[$CellContext`Tyy$$, $CellContext`Tyy$2416$$, 0], 
        Hold[$CellContext`Tyz$$, $CellContext`Tyz$2417$$, 0], 
        Hold[$CellContext`Tzx$$, $CellContext`Tzx$2418$$, 0], 
        Hold[$CellContext`Tzy$$, $CellContext`Tzy$2419$$, 0], 
        Hold[$CellContext`Tzz$$, $CellContext`Tzz$2420$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`t = {{$CellContext`Txx$$, $CellContext`Txy$$, \
$CellContext`Txz$$}, {$CellContext`Tyx$$, $CellContext`Tyy$$, \
$CellContext`Tyz$$}, {$CellContext`Tzx$$, $CellContext`Tzy$$, \
$CellContext`Tzz$$}}}, 
        With[{$CellContext`sym = ($CellContext`t + Transpose[$CellContext`t])/
           2, $CellContext`antisym = ($CellContext`t - 
            Transpose[$CellContext`t])/2}, 
         With[{$CellContext`traceless = $CellContext`sym - 
            Tr[$CellContext`t] (IdentityMatrix[3]/3), $CellContext`pseudovec = 
           Table[
             Sum[Part[
                LeviCivitaTensor[
                3], $CellContext`i, $CellContext`j, $CellContext`k] 
              Part[$CellContext`antisym, $CellContext`j, $CellContext`k], \
{$CellContext`j, 3}, {$CellContext`k, 3}], {$CellContext`i, 3}]}, 
          With[{$CellContext`eigensys = Eigensystem[$CellContext`traceless]}, 
           
           With[{$CellContext`eigenvals = 
             Part[$CellContext`eigensys, 1], $CellContext`eigenvecs = 
             Part[$CellContext`eigensys, 
               2], $CellContext`isotropiccenter = {-3, 0, 
              0}, $CellContext`ellipsoidcenter = {0, 0, 
              0}, $CellContext`pseudoveccenter = {3, 0, 0}}, 
            With[{$CellContext`offset = ReplaceAll[$CellContext`x, 
                
                FindRoot[(($CellContext`x + 
                    Part[$CellContext`eigenvals, 1]) ($CellContext`x + 
                    Part[$CellContext`eigenvals, 2])) ($CellContext`x + 
                   Part[$CellContext`eigenvals, 3]) == 
                 1, {$CellContext`x, -Min[$CellContext`eigenvals] + 0.1}]]}, 
             Graphics3D[{
               Text[Tr[$CellContext`t]/3, $CellContext`isotropiccenter], 
               Sphere[$CellContext`isotropiccenter, 1], 
               Part[
                
                ParametricPlot3D[$CellContext`ellipsoidcenter + (((
                    Part[$CellContext`eigenvals, 3] + $CellContext`offset) 
                    Part[$CellContext`eigenvecs, 3]) 
                   Sin[$CellContext`\[Theta]]) 
                  Cos[$CellContext`\[Phi]] + (((
                    Part[$CellContext`eigenvals, 2] + $CellContext`offset) 
                    Part[$CellContext`eigenvecs, 2]) 
                   Sin[$CellContext`\[Theta]]) 
                  Sin[$CellContext`\[Phi]] + ((
                    Part[$CellContext`eigenvals, 1] + $CellContext`offset) 
                   Part[$CellContext`eigenvecs, 1]) 
                  Cos[$CellContext`\[Theta]], {$CellContext`\[Theta], 0, 
                  Pi}, {$CellContext`\[Phi], 0, 2 Pi}], 1], 
               Arrow[
                
                Tube[{$CellContext`pseudoveccenter - $CellContext`pseudovec, \
$CellContext`pseudoveccenter + $CellContext`pseudovec}]]}, 
              PlotRange -> {{-5, 5}, {-2.5, 2.5}, {-2.5, 2.5}}, 
              SphericalRegion -> True]]]]]]], 
      "Specifications" :> {{{$CellContext`Txx$$, 0.8648594855799372}, -1, 
         1}, {{$CellContext`Txy$$, 0.5591865872801267}, -1, 
         1}, {{$CellContext`Txz$$, 0.9392815909393706}, -1, 
         1}, {{$CellContext`Tyx$$, 0.5144948525797242}, -1, 
         1}, {{$CellContext`Tyy$$, -0.22634754114296607`}, -1, 
         1}, {{$CellContext`Tyz$$, 0.9596721224824152}, -1, 
         1}, {{$CellContext`Tzx$$, -0.47240365628588377`}, -1, 
         1}, {{$CellContext`Tzy$$, -0.7159889505159249}, -1, 
         1}, {{$CellContext`Tzz$$, -0.4982009562843377}, -1, 1}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`Txx$$, $CellContext`Txy$$, \
$CellContext`Txz$$, $CellContext`Tyx$$, $CellContext`Tyy$$, \
$CellContext`Tyz$$, $CellContext`Tzx$$, $CellContext`Tzy$$, \
$CellContext`Tzz$$}}, "DefaultOptions" :> {}],
     ImageSizeCache->{811., {258., 265.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 10: Liquid Crystals", "Section"],

Cell[CellGroupData[{

Cell["\<\
Figure 10.3: Landau-de Gennes free energy density f as a function of the \
nematic order parameter S.  The parameters b and c are held fixed, with b=-1 \
and c=1, and the parameter a is varied.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`atest$$ = Rational[2, 9], Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`atest$$], 
       Rational[2, 9], $CellContext`a}, 0.2, 0.3}}, Typeset`size$$ = {
    450., {129., 164.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`atest$256$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`atest$$ = Rational[2, 9]}, 
      "ControllerVariables" :> {
        Hold[$CellContext`atest$$, $CellContext`atest$256$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[((1/2) $CellContext`a) $CellContext`S^2 + ((1/
            3) $CellContext`b) $CellContext`S^3 + ((1/
            4) $CellContext`c) $CellContext`S^4, {$CellContext`a -> \
$CellContext`atest$$, $CellContext`b -> -1, $CellContext`c -> 
          1}], {$CellContext`S, -0.4, 1}, 
        AxesLabel -> {$CellContext`S, $CellContext`f}, 
        PlotRange -> {-0.006, 0.03}, 
        Ticks -> {{{2/3, "-\!\(\*FractionBox[\(2  b\), \(3  c\)]\)"}}, {}}, 
        Epilog -> Text[0, {0, -0.002}], 
        BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], "Specifications" :> {{{$CellContext`atest$$, 
          Rational[2, 9], $CellContext`a}, 0.2, 0.3}}, 
      "Options" :> {TrackedSymbols -> {$CellContext`atest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {199., 206.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure 10.7: Maier-Saupe free energy F",
 Cell[BoxData[
  FormBox[
   RowBox[{"/", 
    SubscriptBox["Nk", "B"]}], TraditionalForm]]],
 "T as a function of the effective potential strength U."
}], "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`kBToverJqtest$$ = 0.2202, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`kBToverJqtest$$], 0.2202, 
       "\!\(\*FractionBox[\(\*SubscriptBox[\(k\), \(B\)]\\ T\), \(J\\ \
q\)]\)"}, 0.21, 0.24}}, Typeset`size$$ = {450., {146., 181.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`kBToverJqtest$333$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`kBToverJqtest$$ = 0.2202}, 
      "ControllerVariables" :> {
        Hold[$CellContext`kBToverJqtest$$, $CellContext`kBToverJqtest$333$$, 
         0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        ReplaceAll[$CellContext`FMSoverkBT, $CellContext`kBToverJq -> \
$CellContext`kBToverJqtest$$], {$CellContext`U, -1, 3}, 
        AxesLabel -> {$CellContext`U, 
          "\!\(\*FractionBox[\(F\), \(N\\ \*SubscriptBox[\(k\), \(B\)] \
T\)]\)"}, BaseStyle -> {FontSize -> Scaled[0.05]}, PlotStyle -> 
        Thickness[0.005]], 
      "Specifications" :> {{{$CellContext`kBToverJqtest$$, 0.2202, 
          "\!\(\*FractionBox[\(\*SubscriptBox[\(k\), \(B\)]\\ T\), \(J\\ q\)]\
\)"}, 0.21, 0.24}}, 
      "Options" :> {TrackedSymbols -> {$CellContext`kBToverJqtest$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {217., 224.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`Snem = 
       Integrate[(Sin[$CellContext`\[Theta]] LegendreP[2, 
             Cos[$CellContext`\[Theta]]]) Exp[$CellContext`U LegendreP[2, 
              Cos[$CellContext`\[Theta]]]], {$CellContext`\[Theta], 0, Pi}]/
        Integrate[Sin[$CellContext`\[Theta]] Exp[$CellContext`U LegendreP[2, 
             Cos[$CellContext`\[Theta]]]], {$CellContext`\[Theta], 0, 
          Pi}]; $CellContext`FMSoverkBT = (-(1/(
           2 $CellContext`kBToverJq))) $CellContext`Snem^2 + $CellContext`U \
$CellContext`Snem - 
        Log[(2 Pi) 
         Integrate[Sin[$CellContext`\[Theta]] Exp[$CellContext`U LegendreP[2, 
               Cos[$CellContext`\[Theta]]]], {$CellContext`\[Theta], 0, 
            Pi}]]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 10.9: Two hard rods interacting through the excluded-volume \
interaction, in the Onsager theory of the isotropic-nematic transition. The \
pink parallelepiped shows the volume that is forbidden to the second rod \
because of the first rod, at fixed relative orientation \[Theta].\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    0, $CellContext`z$$ = 0, $CellContext`\[Theta]$$ = Rational[1, 4] Pi, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Theta]$$], Rational[1, 4] Pi}, 0, Rational[1, 2] 
      Pi}, {{
       Hold[$CellContext`x$$], 0}, 
      Dynamic[-($CellContext`L (Sin[$CellContext`\[Theta]$$]/2)) - 
       2 $CellContext`R], 
      Dynamic[$CellContext`L (Sin[$CellContext`\[Theta]$$]/2) + 
       2 $CellContext`R]}, {{
       Hold[$CellContext`y$$], 0}, -0.02, 0.02}, {{
       Hold[$CellContext`z$$], 0}, 
      Dynamic[-($CellContext`L/2) - 
       2 $CellContext`R + ($CellContext`L (Cos[$CellContext`\[Theta]$$]/
          2)) ($CellContext`x$$/($CellContext`L (Sin[$CellContext`\[Theta]$$]/
           2) + 2 $CellContext`R))], 
      Dynamic[$CellContext`L/2 + 
       2 $CellContext`R + ($CellContext`L (Cos[$CellContext`\[Theta]$$]/
          2)) ($CellContext`x$$/($CellContext`L (Sin[$CellContext`\[Theta]$$]/
           2) + 2 $CellContext`R))]}}, Typeset`size$$ = {353., {266., 274.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`\[Theta]$6622$$ = 0, $CellContext`x$6623$$ = 
    0, $CellContext`y$6624$$ = 0, $CellContext`z$6625$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        0, $CellContext`z$$ = 0, $CellContext`\[Theta]$$ = Rational[1, 4] Pi},
       "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$6622$$, 0], 
        Hold[$CellContext`x$$, $CellContext`x$6623$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$6624$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$6625$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         Opacity[0.1], 
         Hexahedron[{{$CellContext`L (Sin[$CellContext`\[Theta]$$]/2) + 
            2 $CellContext`R, 
            2 $CellContext`R, $CellContext`L/
             2 + $CellContext`L (Cos[$CellContext`\[Theta]$$]/2) + 
            2 $CellContext`R}, {-($CellContext`L (
               Sin[$CellContext`\[Theta]$$]/2)) - 2 $CellContext`R, 
            2 $CellContext`R, $CellContext`L/2 - $CellContext`L (
             Cos[$CellContext`\[Theta]$$]/2) + 
            2 $CellContext`R}, {-($CellContext`L (
               Sin[$CellContext`\[Theta]$$]/2)) - 2 $CellContext`R, 
            2 $CellContext`R, -($CellContext`L/2) - $CellContext`L (
             Cos[$CellContext`\[Theta]$$]/2) - 
            2 $CellContext`R}, {$CellContext`L (Sin[$CellContext`\[Theta]$$]/
              2) + 2 $CellContext`R, 
            2 $CellContext`R, -($CellContext`L/2) + $CellContext`L (
              Cos[$CellContext`\[Theta]$$]/2) - 
            2 $CellContext`R}, {$CellContext`L (Sin[$CellContext`\[Theta]$$]/
              2) + 2 $CellContext`R, (-2) $CellContext`R, $CellContext`L/
             2 + $CellContext`L (Cos[$CellContext`\[Theta]$$]/2) + 
            2 $CellContext`R}, {-($CellContext`L (
               Sin[$CellContext`\[Theta]$$]/2)) - 
            2 $CellContext`R, (-2) $CellContext`R, $CellContext`L/
             2 - $CellContext`L (Cos[$CellContext`\[Theta]$$]/2) + 
            2 $CellContext`R}, {-($CellContext`L (
               Sin[$CellContext`\[Theta]$$]/2)) - 
            2 $CellContext`R, (-2) $CellContext`R, -($CellContext`L/
              2) - $CellContext`L (Cos[$CellContext`\[Theta]$$]/2) - 
            2 $CellContext`R}, {$CellContext`L (Sin[$CellContext`\[Theta]$$]/
              2) + 2 $CellContext`R, (-2) $CellContext`R, -($CellContext`L/
              2) + $CellContext`L (Cos[$CellContext`\[Theta]$$]/2) - 
            2 $CellContext`R}}], 
         Opacity[0.5], 
         Tube[{{0, 0, 0} - {0, 0, $CellContext`L}/
           2, {0, 0, 0} + {0, 0, $CellContext`L}/2}, $CellContext`R], 
         Tube[{{$CellContext`x$$, $CellContext`y$$, $CellContext`z$$} - \
$CellContext`L ({
              Sin[$CellContext`\[Theta]$$], 0, 
              Cos[$CellContext`\[Theta]$$]}/
            2), {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$} + \
$CellContext`L ({
               Sin[$CellContext`\[Theta]$$], 0, 
               Cos[$CellContext`\[Theta]$$]}/2)}, $CellContext`R], 
         Opacity[1], 
         PointSize[0.03], 
         Point[{0, 0, 0}], 
         Point[{$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}]}, 
        PlotRange -> {{-$CellContext`L - 3 $CellContext`R, $CellContext`L + 
           3 $CellContext`R}, {(-3) $CellContext`R, 
           3 $CellContext`R}, {-(3 ($CellContext`L/2)) - 3 $CellContext`R, 
           3 ($CellContext`L/2) + 3 $CellContext`R}}, Boxed -> False], 
      "Specifications" :> {{{$CellContext`\[Theta]$$, Rational[1, 4] Pi}, 0, 
         Rational[1, 2] Pi}, {{$CellContext`x$$, 0}, 
         Dynamic[-($CellContext`L (Sin[$CellContext`\[Theta]$$]/2)) - 
          2 $CellContext`R], 
         Dynamic[$CellContext`L (Sin[$CellContext`\[Theta]$$]/2) + 
          2 $CellContext`R]}, {{$CellContext`y$$, 0}, (-2) $CellContext`R, 
         2 $CellContext`R}, {{$CellContext`z$$, 0}, 
         Dynamic[-($CellContext`L/2) - 
          2 $CellContext`R + ($CellContext`L (Cos[$CellContext`\[Theta]$$]/
             2)) ($CellContext`x$$/($CellContext`L (
              Sin[$CellContext`\[Theta]$$]/2) + 2 $CellContext`R))], 
         Dynamic[$CellContext`L/2 + 
          2 $CellContext`R + ($CellContext`L (Cos[$CellContext`\[Theta]$$]/
             2)) ($CellContext`x$$/($CellContext`L (
              Sin[$CellContext`\[Theta]$$]/2) + 2 $CellContext`R))]}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`\[Theta]$$, $CellContext`x$$, \
$CellContext`y$$, $CellContext`z$$}}, "DefaultOptions" :> {}],
     ImageSizeCache->{412., {375., 382.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`R = 0.01; $CellContext`L = 1); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 10.11a: Visualization of splay.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   TubeBox[NCache[{{
      Rational[-1, 3] 2^Rational[-1, 2], 0, -2 + 
       Rational[1, 3] 2^Rational[-1, 2]}, {
      Rational[1, 3] 2^Rational[-1, 2], 0, -2 + 
       Rational[-1, 3] 2^Rational[-1, 2]}}, {{-0.2357022603955158, 
       0, -1.764297739604484}, {
      0.2357022603955158, 0, -2.2357022603955157`}}], 0.1], 
   TubeBox[NCache[{{
      Rational[-1, 3] Cos[Rational[1, 8] Pi], 0, -1 + 
       Rational[1, 3] Sin[Rational[1, 8] Pi]}, {
      Rational[1, 3] Cos[Rational[1, 8] Pi], 0, -1 + 
       Rational[-1, 3] Sin[Rational[1, 8] Pi]}}, {{-0.3079598441704289, 
       0, -0.8724388558783034}, {
      0.3079598441704289, 0, -1.1275611441216966`}}], 0.1], 
   TubeBox[NCache[{{Rational[-1, 3], 0, 0}, {
      Rational[1, 3], 0, 0}}, {{-0.3333333333333333, 0, 0}, {
      0.3333333333333333, 0, 0}}], 0.1], 
   TubeBox[NCache[{{
      Rational[-1, 3] Cos[Rational[1, 8] Pi], 0, 1 + 
       Rational[-1, 3] Sin[Rational[1, 8] Pi]}, {
      Rational[1, 3] Cos[Rational[1, 8] Pi], 0, 1 + 
       Rational[1, 3] Sin[Rational[1, 8] Pi]}}, {{-0.3079598441704289, 0, 
       0.8724388558783034}, {0.3079598441704289, 0, 1.1275611441216966`}}], 
    0.1], TubeBox[
    NCache[{{Rational[-1, 3] 2^Rational[-1, 2], 0, 2 + 
       Rational[-1, 3] 2^Rational[-1, 2]}, {
      Rational[1, 3] 2^Rational[-1, 2], 0, 2 + 
       Rational[1, 3] 2^Rational[-1, 2]}}, {{-0.2357022603955158, 0, 
       1.764297739604484}, {0.2357022603955158, 0, 2.2357022603955157`}}], 
    0.1]},
  Boxed->False,
  ViewPoint->{0, -2, 0},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 10.11b: Visualization of twist.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   TubeBox[NCache[{{
      Rational[-1, 3] 2^Rational[-1, 2], Rational[1, 3] 
       2^Rational[-1, 2], -2}, {
      Rational[1, 3] 2^Rational[-1, 2], Rational[-1, 3] 
       2^Rational[-1, 2], -2}}, {{-0.2357022603955158, 
       0.2357022603955158, -2}, {
      0.2357022603955158, -0.2357022603955158, -2}}], 0.1], 
   TubeBox[NCache[{{
      Rational[-1, 3] Cos[Rational[1, 8] Pi], Rational[1, 3] 
       Sin[Rational[1, 8] Pi], -1}, {
      Rational[1, 3] Cos[Rational[1, 8] Pi], Rational[-1, 3] 
       Sin[Rational[1, 8] Pi], -1}}, {{-0.3079598441704289, 
       0.12756114412169658`, -1}, {
      0.3079598441704289, -0.12756114412169658`, -1}}], 0.1], 
   TubeBox[NCache[{{Rational[-1, 3], 0, 0}, {
      Rational[1, 3], 0, 0}}, {{-0.3333333333333333, 0, 0}, {
      0.3333333333333333, 0, 0}}], 0.1], 
   TubeBox[NCache[{{
      Rational[-1, 3] Cos[Rational[1, 8] Pi], Rational[-1, 3] 
       Sin[Rational[1, 8] Pi], 1}, {
      Rational[1, 3] Cos[Rational[1, 8] Pi], Rational[1, 3] 
       Sin[Rational[1, 8] Pi], 
       1}}, {{-0.3079598441704289, -0.12756114412169658`, 1}, {
      0.3079598441704289, 0.12756114412169658`, 1}}], 0.1], 
   TubeBox[NCache[{{
      Rational[-1, 3] 2^Rational[-1, 2], Rational[-1, 3] 2^Rational[-1, 2], 
       2}, {Rational[1, 3] 2^Rational[-1, 2], Rational[1, 3] 
       2^Rational[-1, 2], 2}}, {{-0.2357022603955158, -0.2357022603955158, 
       2}, {0.2357022603955158, 0.2357022603955158, 2}}], 0.1]},
  Boxed->False,
  ViewPoint->{0, -2, 0},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 10.11c: Visualization of bend.", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   TubeBox[NCache[{{
      Rational[1, 3] 2^Rational[-1, 2], 0, -2 + 
       Rational[-1, 3] 2^Rational[-1, 2]}, {
      Rational[-1, 3] 2^Rational[-1, 2], 0, -2 + 
       Rational[1, 3] 2^Rational[-1, 2]}}, {{
      0.2357022603955158, 0, -2.2357022603955157`}, {-0.2357022603955158, 
       0, -1.764297739604484}}], 0.1], 
   TubeBox[NCache[{{
      Rational[1, 3] Sin[Rational[1, 8] Pi], 0, -1 + 
       Rational[-1, 3] Cos[Rational[1, 8] Pi]}, {
      Rational[-1, 3] Sin[Rational[1, 8] Pi], 0, -1 + 
       Rational[1, 3] Cos[Rational[1, 8] Pi]}}, {{
      0.12756114412169658`, 0, -1.307959844170429}, {-0.12756114412169658`, 
       0, -0.6920401558295711}}], 0.1], 
   TubeBox[NCache[{{0, 0, Rational[-1, 3]}, {0, 0, Rational[1, 3]}}, {{
      0, 0, -0.3333333333333333}, {0, 0, 0.3333333333333333}}], 0.1], 
   TubeBox[NCache[{{
      Rational[-1, 3] Sin[Rational[1, 8] Pi], 0, 1 + 
       Rational[-1, 3] Cos[Rational[1, 8] Pi]}, {
      Rational[1, 3] Sin[Rational[1, 8] Pi], 0, 1 + 
       Rational[1, 3] Cos[Rational[1, 8] Pi]}}, {{-0.12756114412169658`, 0, 
       0.6920401558295711}, {0.12756114412169658`, 0, 1.307959844170429}}], 
    0.1], TubeBox[
    NCache[{{Rational[-1, 3] 2^Rational[-1, 2], 0, 2 + 
       Rational[-1, 3] 2^Rational[-1, 2]}, {
      Rational[1, 3] 2^Rational[-1, 2], 0, 2 + 
       Rational[1, 3] 2^Rational[-1, 2]}}, {{-0.2357022603955158, 0, 
       1.764297739604484}, {0.2357022603955158, 0, 2.2357022603955157`}}], 
    0.1]},
  Boxed->False,
  ViewPoint->{0, -2, 0},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 10.12: Semi-infinite liquid crystal, with strong surface anchoring \
that requires \[Theta]=0 at x=0, and a magnetic field that favors \[Theta]=\
\[PlusMinus]\[Pi]/2 in the bulk.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[
  {Thickness[0.005], Arrow3DBox[{{0, -1.7, 0}, {0, 1.7, 0}}], Text3DBox[
    FormBox["y", StandardForm], {0, 1.9, 0}], 
   Arrow3DBox[{{0, 0, -1.7}, {0, 0, 1.7}}], Text3DBox[
    FormBox["z", StandardForm], {0, 0, 1.9}], 
   Arrow3DBox[{{0, 0, 0}, {4.8, 0, 0}}], Text3DBox[
    FormBox["x", StandardForm], {5, 0, 0}], 
   Arrow3DBox[{{2, -0.5, -0.7}, {2, 0.5, -0.7}}], Text3DBox[
    FormBox["H", StandardForm], {2, 0, -1}], {
    TubeBox[NCache[{{0, 0, Rational[-1, 3]}, {0, 0, Rational[1, 3]}}, {{
       0, 0, -0.3333333333333333}, {0, 0, 0.3333333333333333}}], 0.1], 
    TubeBox[NCache[{{
       1, Rational[1, 3] Tanh[1], 
        Rational[-1, 3] (1 - Tanh[1]^2)^Rational[1, 2]}, {
       1, Rational[-1, 3] Tanh[1], 
        Rational[1, 3] (1 - Tanh[1]^2)^Rational[1, 2]}}, {{
       1, 0.2538647186519216, -0.21601809122129514`}, {
       1, -0.2538647186519216, 0.21601809122129514`}}], 0.1], 
    TubeBox[NCache[{{
       2, Rational[1, 3] Tanh[2], 
        Rational[-1, 3] (1 - Tanh[2]^2)^Rational[1, 2]}, {
       2, Rational[-1, 3] Tanh[2], 
        Rational[1, 3] (1 - Tanh[2]^2)^Rational[1, 2]}}, {{
       2, 0.32134252669193897`, -0.0886007429446932}, {
       2, -0.32134252669193897`, 0.0886007429446932}}], 0.1], 
    TubeBox[NCache[{{
       3, Rational[1, 3] Tanh[3], 
        Rational[-1, 3] (1 - Tanh[3]^2)^Rational[1, 2]}, {
       3, Rational[-1, 3] Tanh[3], 
        Rational[1, 3] (1 - Tanh[3]^2)^Rational[1, 2]}}, {{
       3, 0.3316849178955768, -0.0331093091398111}, {
       3, -0.3316849178955768, 0.0331093091398111}}], 0.1], 
    TubeBox[NCache[{{
       4, Rational[1, 3] Tanh[4], 
        Rational[-1, 3] (1 - Tanh[4]^2)^Rational[1, 2]}, {
       4, Rational[-1, 3] Tanh[4], 
        Rational[1, 3] (1 - Tanh[4]^2)^Rational[1, 2]}}, {{
       4, 0.333109766579689, -0.012206331157895368`}, {
       4, -0.333109766579689, 0.012206331157895368`}}], 0.1]}, 
   Line3DBox[{{4, 0, 0}, {4, 0, 0.5}}], {{}, {}, 
    {GrayLevel[0], Line3DBox[CompressedData["
1:eJxF0mtMk2ccBfBGoFoiTuYUHYyB1FZYJxZccB1CCxWRaJiOMSHDO17QjSEV
kYJso1bBeAWcVRRokaGhQNMyDNr+C8ilpdf3NVoqlSygOJmUixbFods++Dwn
OV9+H09O4M7MzemzKBTKF//VjfI+87mDeczY4VASnmbQFPWF4uj3PpFU9VrK
IoHmX/a2VH0W+ctVEWbechL285n91vwy5KF6UdP4xyQoaz3PJQivIU+959Vg
opHg/VVcx44hGfK+8tj4ihcEpMsdVazMOuQnxakNLTYCbI2Fy1nJcuS509wS
v1YCTBPUsuDxJuSVXcYtM6UETCoH/s7dpUS+9Z/pRxf3EyCUReSyOpuRT/sM
1UjXEHCPW1GsetWCvM0nTBpBI+Bx5MaxX75tRW50MPwdpBWyw0eUjUV3kJdc
XSE8csUK9Fn87O+qNMij0meY2hQr2F0ZRSeztMgpfY+ToxZbIdC8h3lB2Ib8
vOqDHLXBAonOBTeSf2tHnj/b1E0/ZgF72oTHq7oO5E8aXf0jKy2w9f668gLZ
XeQuwa16p8IMqaGKfpu8E/nano+sVKoZNEmTHqHVXchbY/SfHI81QdFOHTyQ
diOv8fZQH8w3wptiSUOOpAf5rgy3viu3DUCzXAfZUR1yA+3oX56DvSA8P/Cp
xx498uclcSNvvHvBza6+HBnZi1wg9Xquj9KDOZ6z5PVsA3LJfar62WYd8BbW
nmp3YM/kEJwbP/VAYRBPsO6aEf8kfmT0raAbEhYxXb57TcjnSxIC6o50QZL2
QyeDbsZ/COd7vjveCVE/XHDNNWL/fnXiu6S8u1DsXMGdWmNBrkgLnj4s7ICU
08/2VZ7CbnxA+C4raAfj04DJlyT2MWdIcvbuNih2/0a11N+K/LKXfG1aqhZc
zcN/rN6GPcCyIYZ7QAPsUfbCiGrsmeyvt8/h3QHWphlbgR37ICMvg+7bCtGX
KFmieQRyzSB/ixNa4Ez3Bk5cDPbqc2f5rBPNME7tV9J/xM5h8yuClijhUJX2
uuES9hd+IS2bFE3gvj5MrFBjVz46tEjlqIdS7dSJyofYRbUS8W3n7+AeuEPM
mML+5a/z5txMlMFBhpwSPpfEu6UP37SLroLa76FE4If9Fi1L/GdFKYwO+YSw
grHnyMe8Dk+dBh3TUZPyOfauoKzqvUoR9D0B/b6V2G0bm44FqwQwYG4r/zkM
O+2ii6f7jK9hh/8fMvpfBd/XaA==
      "]]}}, Text3DBox[
    FormBox[
     RowBox[{"\[Theta]", "(", "x", ")"}], StandardForm], {4, -0.45, 0.45}], 
   {Opacity[0.5], EdgeForm[Thickness[Large]], 
    Polygon3DBox[{{0, 1.1, 1.1}, {0, 1.1, -1.1}, {0, -1.1, -1.1}, {
      0, -1.1, 1.1}}], 
    {Thickness[0.003], Line3DBox[{{0, -0.76, -1.1}, {0, -0.76, 1.1}}], 
     Line3DBox[{{0, -0.38, -1.1}, {0, -0.38, 1.1}}], 
     Line3DBox[{{0, 0., -1.1}, {0, 0., 1.1}}], 
     Line3DBox[{{0, 0.3800000000000001, -1.1}, {0, 0.3800000000000001, 1.1}}],
      Line3DBox[{{0, 0.76, -1.1}, {0, 0.76, 1.1}}]}}},
  BaseStyle->{FontSize -> Scaled[0.05]},
  Boxed->False,
  ViewPoint->{2.2, -2.5, 0.5},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 10.14: Finite liquid-crystal cell, with strong surface anchoring that \
requires \[Theta]=0 at x=0 and x=d, and a magnetic field that favors \
\[Theta]=\[PlusMinus]\[Pi]/2 in the interior.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[
  {Thickness[0.005], Arrow3DBox[{{0, -1.7, 0}, {0, 1.7, 0}}], Text3DBox[
    FormBox["y", StandardForm], {0, 1.9, 0}], 
   Arrow3DBox[{{0, 0, -1.7}, {0, 0, 1.7}}], Text3DBox[
    FormBox["z", StandardForm], {0, 0, 1.9}], 
   Arrow3DBox[{{0, 0, 0}, {4.8, 0, 0}}], Text3DBox[
    FormBox["x", StandardForm], {5, 0, 0}], 
   Arrow3DBox[{{2, -0.5, -0.7}, {2, 0.5, -0.7}}], Text3DBox[
    FormBox["H", StandardForm], {2, 0, -1}], {
    TubeBox[{{0, 0., -0.3333333333333333}, {0, 0., 0.3333333333333333}}, 0.1],
     TubeBox[{{1, 0.26504674956904706`, -0.20214186022195882`}, {
      1, -0.26504674956904706`, 0.20214186022195882`}}, 0.1], 
    TubeBox[{{2, 0.32118606180573095`, -0.08916627620819578}, {
      2, -0.32118606180573095`, 0.08916627620819578}}, 0.1], 
    TubeBox[{{3, 0.26504674956904706`, -0.20214186022195882`}, {
      3, -0.26504674956904706`, 0.20214186022195882`}}, 0.1], 
    TubeBox[{{4, 0., -0.3333333333333333}, {4, 0., 0.3333333333333333}}, 
     0.1]}, 
   {Opacity[0.5], EdgeForm[Thickness[Large]], 
    Polygon3DBox[{{0, 1.1, 1.1}, {0, 1.1, -1.1}, {0, -1.1, -1.1}, {
      0, -1.1, 1.1}}], 
    Polygon3DBox[{{4, 1.1, 1.1}, {4, 1.1, -1.1}, {4, -1.1, -1.1}, {
      4, -1.1, 1.1}}], 
    {Thickness[
     0.003], {Line3DBox[{{0, -0.76, -1.1}, {0, -0.76, 1.1}}], 
      Line3DBox[{{0, -0.38, -1.1}, {0, -0.38, 1.1}}], 
      Line3DBox[{{0, 0., -1.1}, {0, 0., 1.1}}], 
      Line3DBox[{{0, 0.3800000000000001, -1.1}, {
        0, 0.3800000000000001, 1.1}}], 
      Line3DBox[{{0, 0.76, -1.1}, {0, 0.76, 1.1}}]}, {
      Line3DBox[{{4, -0.76, -1.1}, {4, -0.76, 1.1}}], 
      Line3DBox[{{4, -0.38, -1.1}, {4, -0.38, 1.1}}], 
      Line3DBox[{{4, 0., -1.1}, {4, 0., 1.1}}], 
      Line3DBox[{{4, 0.3800000000000001, -1.1}, {
        4, 0.3800000000000001, 1.1}}], 
      Line3DBox[{{4, 0.76, -1.1}, {4, 0.76, 1.1}}]}}}},
  BaseStyle->{FontSize -> Scaled[0.05]},
  Boxed->False,
  ViewPoint->{2.2, -2.5, 0.5},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure 10.17: Finite liquid-crystal cell with strong surface anchoring at a \
pre-tilt angle ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "pre"], TraditionalForm]]],
 ", which is not perpendicular to the magnetic field direction."
}], "Subsection"],

Cell[BoxData[
 Graphics3DBox[
  {Thickness[0.005], Arrow3DBox[{{0, -1.7, 0}, {0, 1.7, 0}}], Text3DBox[
    FormBox["y", StandardForm], {0, 1.9, 0}], 
   Arrow3DBox[{{0, 0, -1.7}, {0, 0, 1.7}}], Text3DBox[
    FormBox["z", StandardForm], {0, 0, 1.9}], 
   Arrow3DBox[{{0, 0, 0}, {4.8, 0, 0}}], Text3DBox[
    FormBox["x", StandardForm], {5, 0, 0}], 
   Arrow3DBox[{{2, -0.5, -0.7}, {2, 0.5, -0.7}}], Text3DBox[
    FormBox["H", StandardForm], {2, 0, -1}], {
    TubeBox[{{0, 0.09850673555377984, -0.318445496375202}, {
      0, -0.09850673555377984, 0.318445496375202}}, 0.1], 
    TubeBox[{{1, 0.28176317100933634`, -0.1781028539183878}, {
      1, -0.28176317100933634`, 0.1781028539183878}}, 0.1], 
    TubeBox[{{2, 0.32118606180573095`, -0.08916627620819578}, {
      2, -0.32118606180573095`, 0.08916627620819578}}, 0.1], 
    TubeBox[{{3, 0.28176317100933634`, -0.1781028539183878}, {
      3, -0.28176317100933634`, 0.1781028539183878}}, 0.1], 
    TubeBox[{{4, 0.09850673555377984, -0.318445496375202}, {
      4, -0.09850673555377984, 0.318445496375202}}, 0.1]}, 
   {Opacity[0.5], EdgeForm[Thickness[Large]], 
    Polygon3DBox[{{0, 1.1, 1.1}, {0, 1.1, -1.1}, {0, -1.1, -1.1}, {
      0, -1.1, 1.1}}], 
    Polygon3DBox[{{4, 1.1, 1.1}, {4, 1.1, -1.1}, {4, -1.1, -1.1}, {
      4, -1.1, 1.1}}], 
    {Thickness[
     0.003], {Line3DBox[{{0, -0.4197301254294144, -1.1}, {
        0, -1.1002698745705857`, 1.1}}], 
      Line3DBox[{{0, -0.0397301254294144, -1.1}, {
        0, -0.7202698745705856, 1.1}}], 
      Line3DBox[{{0, 0.3402698745705856, -1.1}, {
        0, -0.3402698745705856, 1.1}}], 
      Line3DBox[{{0, 0.7202698745705858, -1.1}, {
        0, 0.03973012542941451, 1.1}}], 
      Line3DBox[{{0, 1.1002698745705857`, -1.1}, {
        0, 0.4197301254294144, 1.1}}]}, {
      Line3DBox[{{4, -0.4197301254294144, -1.1}, {
        4, -1.1002698745705857`, 1.1}}], 
      Line3DBox[{{4, -0.0397301254294144, -1.1}, {
        4, -0.7202698745705856, 1.1}}], 
      Line3DBox[{{4, 0.3402698745705856, -1.1}, {
        4, -0.3402698745705856, 1.1}}], 
      Line3DBox[{{4, 0.7202698745705858, -1.1}, {
        4, 0.03973012542941451, 1.1}}], 
      Line3DBox[{{4, 1.1002698745705857`, -1.1}, {
        4, 0.4197301254294144, 1.1}}]}}}},
  BaseStyle->{FontSize -> Scaled[0.05]},
  Boxed->False,
  ViewPoint->{2.2, -2.5, 0.5},
  ViewVertical->{0, 0, 1}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 10.19f: Defects in a 2D polar phase with topological charges +1 and \
-1, combining to make 0.\
\>", "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Delta]x$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]x$$], 5, $CellContext`Separation}, 0, 10}}, 
    Typeset`size$$ = {450., {221., 229.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Delta]x$6686$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Delta]x$$ = 5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Delta]x$$, $CellContext`\[Delta]x$6686$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`r1 = (($CellContext`x - $CellContext`\[Delta]x$$/
             2)^2 + $CellContext`y^2)^Rational[1, 2], $CellContext`\[Theta]1 = 
         ArcTan[$CellContext`x - $CellContext`\[Delta]x$$/
           2, $CellContext`y], $CellContext`r2 = (($CellContext`x + \
$CellContext`\[Delta]x$$/2)^2 + $CellContext`y^2)^
          Rational[1, 2], $CellContext`\[Theta]2 = 
         ArcTan[$CellContext`x + $CellContext`\[Delta]x$$/2, $CellContext`y]}, 
        With[{$CellContext`\[Phi] = $CellContext`\[Theta]1 - $CellContext`\
\[Theta]2}, 
         With[{$CellContext`n = {
             Cos[$CellContext`\[Phi]], 
             Sin[$CellContext`\[Phi]]}}, 
          Graphics[{
            Thickness[0.004], 
            Part[
             
             VectorPlot[$CellContext`n, {$CellContext`x, -5, 
               5}, {$CellContext`y, -5, 5}, VectorPoints -> {16, 16}], 1]}, 
           PlotRange -> {{-5.5, 5.5}, {-5.5, 5.5}}]]]], 
      "Specifications" :> {{{$CellContext`\[Delta]x$$, 
          5, $CellContext`Separation}, 0, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {277., 284.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure 10.20g: Defects in a 2D nematic phase with topological charges +",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]]],
 " and -",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]]],
 ", combining to make 0."
}], "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Delta]x$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]x$$], 5, $CellContext`Separation}, 0, 10}}, 
    Typeset`size$$ = {450., {221., 229.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Delta]x$6751$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Delta]x$$ = 5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Delta]x$$, $CellContext`\[Delta]x$6751$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`r1 = (($CellContext`x - $CellContext`\[Delta]x$$/
             2)^2 + $CellContext`y^2)^Rational[1, 2], $CellContext`\[Theta]1 = 
         ArcTan[$CellContext`x - $CellContext`\[Delta]x$$/
           2, $CellContext`y], $CellContext`r2 = (($CellContext`x + \
$CellContext`\[Delta]x$$/2)^2 + $CellContext`y^2)^
          Rational[1, 2], $CellContext`\[Theta]2 = 
         ArcTan[$CellContext`x + $CellContext`\[Delta]x$$/2, $CellContext`y]}, 
        With[{$CellContext`\[Phi] = (1/2) $CellContext`\[Theta]1 - (1/
            2) $CellContext`\[Theta]2}, 
         With[{$CellContext`n = {
             Cos[$CellContext`\[Phi]], 
             Sin[$CellContext`\[Phi]]}}, 
          Graphics[{
            Thickness[0.004], 
            Part[
             
             VectorPlot[$CellContext`n, {$CellContext`x, -5, 
               5}, {$CellContext`y, -5, 5}, VectorPoints -> {16, 16}, 
              VectorStyle -> "DoubleDart"], 1]}, 
           PlotRange -> {{-5.5, 5.5}, {-5.5, 5.5}}]]]], 
      "Specifications" :> {{{$CellContext`\[Delta]x$$, 
          5, $CellContext`Separation}, 0, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {277., 284.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure 10.20h: Defects in a 2D nematic phase with topological charges +",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]]],
 " and +",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]]],
 ", combining to make +1."
}], "Subsection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Delta]x$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]x$$], 5, $CellContext`Separation}, 0, 10}}, 
    Typeset`size$$ = {450., {221., 229.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Delta]x$6811$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Delta]x$$ = 5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Delta]x$$, $CellContext`\[Delta]x$6811$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`r1 = (($CellContext`x - $CellContext`\[Delta]x$$/
             2)^2 + $CellContext`y^2)^Rational[1, 2], $CellContext`\[Theta]1 = 
         ArcTan[$CellContext`x - $CellContext`\[Delta]x$$/
           2, $CellContext`y], $CellContext`r2 = (($CellContext`x + \
$CellContext`\[Delta]x$$/2)^2 + $CellContext`y^2)^
          Rational[1, 2], $CellContext`\[Theta]2 = 
         ArcTan[$CellContext`x + $CellContext`\[Delta]x$$/2, $CellContext`y]}, 
        With[{$CellContext`\[Phi] = (1/2) $CellContext`\[Theta]1 + (1/
             2) $CellContext`\[Theta]2}, 
         With[{$CellContext`n = {
             Cos[$CellContext`\[Phi]], 
             Sin[$CellContext`\[Phi]]}}, 
          Graphics[{
            Thickness[0.004], 
            Part[
             
             VectorPlot[$CellContext`n, {$CellContext`x, -5, 
               5}, {$CellContext`y, -5, 5}, VectorPoints -> {16, 16}, 
              VectorStyle -> "DoubleDart"], 1]}, 
           PlotRange -> {{-5.5, 5.5}, {-5.5, 5.5}}]]]], 
      "Specifications" :> {{{$CellContext`\[Delta]x$$, 
          5, $CellContext`Separation}, 0, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{509., {277., 284.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 10.24: Schematic representation of the packing of chiral molecules by \
the packing of hard screws.  In the most efficient packing, molecules are not \
parallel to their neighbors, but rather are at a slight twist angle with \
respect to their neighbors.  Based on J. P. Straley, Phys. Rev. A 14, 1835 \
(1976).\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[{
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[{
      CylinderBox[
       NCache[{{0, 0, Rational[-3, 2] Pi}, {0, 0, Rational[3, 2] Pi}}, {{
         0, 0, -4.71238898038469}, {0, 0, 4.71238898038469}}], 1], 
      GraphicsComplex3DBox[CompressedData["
1:eJx1nHlcTtv3x5MGKjJUZAxlHi6lDLFDpYRICIVCxoypEIlIyBAiUTKlTAmR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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnQnYVdMXxvd3zxGZh0TGRjKTJiHNZEwqQ2kkKaSSeaiIyJSMZUzmMTRo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           "]]]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJx1XHlcjV3XTpEpQ4mQqdJAGSIy1NmZp4iQMkWGRKKUzBQhUknKTHOkKM3R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        "]], GraphicsComplex3DBox[CompressedData["
1:eJxdnXlcjs33x2nVplARspbszzdFljShUqIoWbNlDVlTlkhklyUqa8meXRKt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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnQnYVdMXxvd3zxGZh0TGRjKTJiHNZEwqQ2kkKaSSeaiIyJSMZUzmMTRo
npRmJZRoNER/mYeM//f3rfc+fc/jPOe9q733PWftc+/3rnetdVXp2rv1FYWU
0onlU8p0vlkvXihJab3wv8KvC28U/lb4JeENwpuFXxb+Qvgn4VeEvxT+TfhV
4a+E39D5G521bPpT9tf0+mvhN3X+VuftdeR6w3f1+kfht3T+n8476nhb+Dud
d9Jxq+aO0+vvhWtq/CLhXEeJ8Hidf5B9jM6bdN5BxzvCm3XeWce2GjNRr39i
LeHJwr8Iz9L5L53307GH7FP1+jfhaTr/rvPeOqYL/6FzJR0zhLfovI+OXTV+
il7/yj0ITxL+WXi2zn/rvL+OGrIv1OtMx6w8pWo63hOuJPv7Ov/HewvPE046
DhSezz3pqCq8QOeCjorCc3T+V8PaC/8mfKiOxTq20XGw7B/ovK2OQ4SP1JhP
hHfSsVTHdoyXfZnO5XUcJvyhztvrOJxr1nUdpGO5Xh+juSt03plxwh/pvKOO
2sIrdd5Fx1quScdxmttA9lXCu+k4UfgznXfXsVpHBR31NGaJzuV01BReo/Oe
OuoL19P4T4V31bFOx146Gsi+Xue9dRwv/J6u6xAdG/S6qcZ/pfO+OloIf63z
fjpaCm/UeX8dpwt/o/MBOs4S/ha/6mgtvEnnyjoaCX+h8z48azqq6GjO86xz
NR0nC3/HHvA+wt/rXF3HKcIzdf5T5311/CBcg/cXnqNrPFzHT3rdVuv/zP3y
TOs4SMepGnOe7L+yRzo6Cv+Oj3UsEm6m57sfz4SOY3Wcx+dO51o6zhW+SGO2
CB+h4xLhP3U+kudXx1E62mhM0hq1hc8X/Fvno7kW4bm6rqN0lOjfr9bcbXVu
oH+7Ungb4frCPYULwnWFLxfOhesJ9xMuJ3wcvtb5TJ37a83rZN9Or4/X6394
bnS0k/1G2cvLfgLPl84n6txN9kGy76HXzXkudW6kc3c+n8KNuSfhXYSbCPcQ
fl/XW0vHrrLtqOMk2S+WfbDWqaDXLfR6qHBF4VN4JnQ+Q+er+PwLNxS+SHiI
xuyp1yfrdRfhP3jmddwrvJfsLfk86nyazn35bAufzn0LD9OYvfX6VL3+XMce
Oury2ZbtLOGrhY8TvlT4AeHnNf5gvT5Pr58VPkj4XOEHhSsLtxZ+RLiq8DnC
I4SrCbfhWdH5fJ0Hap0nZK+u1215VnS+QOdBss+XP+rrOFK2w3VcKPtg2Q8V
bi98q/Bhwh2EbxM+Qrij8O3CBwi3Er5G+CWtf5Red9brp4VrCLcTflX4GOEu
wm8I1xLuymdS5546D9fcCbLX0euL9XqScF3h7nzOdb5E5/s1pr5wD+FhwmM1
prZeX8TnWede+EP2BbqP43WcKNt8jWmqc1/921vCxwp3Ez5B58t0fkjj52ls
HR0HyjZVYxrqfIX+bbZwY+ErhecKNxHuIzxDuJFwb+Gbhd8Ubib8gXBz4av4
nPN5wAd8H8p+hl7fyOdc52t0fkb2lsLXCo8SPlX4OvZW+DTh64VHC3+suWfp
9U16vVDX2FDH6Xq9UvZWOt/MZ1jnwTq/yXeg7K31eoBerxc+R3ggn1Wdb9X5
dY35R/Zeev0onyudb2NPZP9M9rP1+ha+I3S+Xecxsp8vfAf+E75AeIjw28Ib
Nb6DXt+l15uEOwoPFd4s3En4br6jhDsL3yP8i3AX4XuFfxfuKnwf31G6p8Y6
2uv1n7J30/l+PpM6P6DzVL6jhIcJTxHuLjxceJrwlxrfRq8H8TnX+UGdp8t+
qfDDwjOFF2vtZjp68uzoeIg99N9f/ubW9N9fvnv5G7eNxl6pcSP5HOr8jM6L
Zd9O9j56/bhe7yDcV/gJ4Z2F+wk/yXeEzk+xVxp/jfAo4SXC/YWf5l6FrxV+
ludF+HdzG/jMEq3TQsf1sn2t48WS4EjfmxfBhQr69956PUKvfzZHghddJzxa
eKnwX+ZIcKH/zIvgV/As+NJe5kibzD3gNv8z94Ajfee/QXCkzeYwcJ7vzT0K
8vmEkuBFcLBvzWe2MV+Ca+1gXgRv2c4cDI60s/kMHOk/YYjhY3q9m7kTnAeu
BEc6yHwJjgQPqWBeBI+6RXg3f+74uwnXgodc7O9h/pZVM+eB58Cd/knBSfaS
fW5JcJ59zH/gS/ubO8GXDjJHgl9VNo+COx1i3gU/hOfsUBJcAr5Uzt/hcBL4
EvwEjgQvgs+cYS4Bf4AvwZHgJPBNuFYdrk9jPi4JXnSUORJcq5Z5F9ypvvkS
3OZ48xw4UkPzJTgSXIm/Kc1S/H2BL8FD4E5wJLhHHfMxeBfcCd4FP4EvwZHg
HvAxuNMp5k6VSoJvwAnhfnCtxlrny5LgPCebR8GdTjWPgjs1My8q5Vfat/46
P5WCJ8Np4Y1wKPjSOSm4zcElwTfgUfClNuZO8Ki25lRwp3bmUfAl+Ew7vdcv
JcGR4FFwJDjP+eZOcCS4DRwG/tDJvBe+1NXcib/jPcyL4ELnmO/B8eBH8KKu
mtvBvAvODC+Cq8AN4C3wq4vNteBd3c2j6pQED+mluZl50RXmSPCiPuZIcKer
zKPgSNeYL8Gv4HLwMbjN9eZd8KXy5kV9ZL/JPKrIl+At8JBW5rFw1x3Mf+Ak
O5kv9Td3gi/BQ3Y0p7rKPKppSfytH6B1dvdn8FZ/HuFg+5gvwSsqmfMMFL7T
/Aq+dLe5E/zqPnMt+BJcCx4I33jAPAqOtJ95EdxjpHkO3OYh4SrmP/ubhww2
Jzm7JPjJo+ZI8KJ65g88e0+aI8GF4GLwtAGyP2OOBG8ZbQ4D14LzdCoJzlDT
3AlOcog50jDzJTjSA+ZL8Ci4DdwNDnaf8Mta82hzpDfNi+BCdc1zntSYF8zx
4HuvmVPBnfhe/tPf1W+bR8Fn3jUXgjtNNo+CO40z54EjwevgbHAkeBTcEn7S
xtxgsvAC8xz40vvmP3Ce482X4Cdwp8tLgp9M05iTzJcWm2sRa8w0j4IjLXUM
Ai9qaZ4DrzjZXAju0dzfCa+l+H6AO8FVTjFHgtvAh+GKz6TgS3AkOMl75mPw
NLjTDSXBT5bLfmYheFdb8xz4w+fmTvCcteY88KUN5k7wpa/MneAVn5qDwbXa
mWvBSc4zL4JvfG/+A+f5xHwPznaueRRcBa4LRx2VglPBo2YIf6PxF5pH/c+c
Ch4F17qzJDjMId53/sb9ZH4Fp/rDnAoe1cOcB17RzXxpQQruBI+Ck1xs7gQP
6W6+BLe5yvxkVQoeBUeCt8CjHikJXrGLOQ885xaegUJwyCyPv+NwknLmJ3Cn
8uZR8KUdzZ3gSykP/snf/X7mS5+m4Ehwrc/4W6kxQwvBYa4xX1qdgjvBc9ak
4DzPsYd81wk/XxJ86RTNvb0Q+BudNxZCU4LLwcc+F26pMXfYfqrwkELwq+90
/p/xjzr/UAh+9Y/OfxeCR52m8XfafrrwXYXgb1t0/sPX/KvOv9j+qzkwvPdM
jb/b6+ySxT3+6s8zHIzP947GaE1wNTgb/Ao9C65V3q/B8Dc0rO88jzmbPHZf
2+FvCG/4BM42tiS43M4+NnuN/YzheC/pOqvmMe4vc3U4+Vmy3eN1Kvm9uPYs
C3/C/VppzL3GbYQf8D2Wz8JvcMLWst9vvGMWPoQTniP7MOOzhe8rBG/cPQu/
/eZ7/92+gbtv8eejXBb7yPi2mjvc48vbh9ul4JTMPdjHH15jH69Tyccffp9N
hdAqN9g/f9mvvbX+a4XgCXtncb9wyHayP1gIbokf//a8w4zhn0s15gP791wd
D3nuK8I18uCp+2Zx73DRC2R7tBA89nzhRwrBRc8TfthjDsjCn9irZOFDxl+o
MSMLwSerZ7EXcNo9s9jHUt1PYx6z/eAs/Aa/5bsGjodv4aZw1Lr2F1wX/9U1
ruc9gPfWtG8Zj7/rex04MAd8GN57aBa+4to66BpG+H0P8xje/1LZXygEV8F3
2/vfP5R9mf31mo6aeXDxBh4DJ6/n6+H9j8jCz3Dpk7LwCXy1q+Y9XQj+fFwW
fgB3kv2JQvDtY7PwOTy5s+xPGp+QxTXDt+tmsUdw8m4a84ztvPee9g9HBfuQ
A36OX5sZw8+bewz8vKPWedzX3MLrwM+7yP6U3wt/VvT7nGwMV79IY0b5HvHF
3vZNS2M4/EfosvbdGzoOy4PfMx/Oz9gmWVwDvL15Fj6B2/fQ2OcLEcs08Hiu
5WLZn/X4o7N4PvFhd9lHe+4lws8VIi44LYt7YZ1TsvDt/t77v/y5OTOLPeIZ
uD0Lra+Fr7O6fUI8QFzQzj4kjsCv5xgTO+DDqvZzO88lXmhje1v7p4bXHoMe
lkccQvxAHEE8cq7HYDvVduZ9orEf24/EAMQC8P82WexFTV9rNe9nL417yfZz
s/AbsUm3LJ55YtjLNeaVQsQXF2bhN+KUK2R/1bhzFnvBd9EFWfiZ8VdqzOte
pw97XIhYpp2vjfu9TPaX/b7dNfdFj+mZB65s3xHvnGM/H21bN2PutavHYDs7
i+e/sv1by++JL07y+L556GbEPpdm4QcwMRKxEnENvq5tP19iTNx0WRbXTKy0
Uuus8D710zHG9v5ZfD8TK/XNwlfEUL2z8GdpbKXxbxn3F37bYy72NXMtV8v+
jtd5W/iYPOK3a7PwLTHXNbKNNe7ne7zK/iEWwzd9jIm/uP+G9lVfY+Zdq3XG
FSJe470b+Vq498a2jdWY2nnEYDdksacn+P0YT+x2nn2I7/t7LnEcBzEdsdsq
rfGp76eH7bzPdXo9vhAx3cAs/ElMd73sE4xvEp5UiNjttix8yOfxBtnfNb4j
C38S690o+0Tje7LwFbHeXVn4lnVu1pjJtnMvZ9gnt8g+pRAxIL4iRsOX/Nvp
tt2mMTMLEa8NtH2Qzvdn4c9T/Zo1b7VPzvT73GpMXMlBjEn8iI9a2W+DjYkl
P9d7feY9GK+jXh5x5vAs/Nbac87yXgzQv0+1faDwtELEoQ9n4U/wY1n4jXh2
gO+R+xik8dNtv1V4RiFi1aey8D/3+3gWvsVOzElMRxz6tPEzOj+XhQ/P8/23
tz9u15qzbef9zvf732dMbMu4C/zvwzyX97nf9mH2Wwev/a7WbJBHnIzfLrRv
hxsTe3IQhxJHD9bYWYWIr9cIr7ZPH/CazHsxCx8SL9+hf3vP+JUs/Elc/HoW
viKOvlNj5hqPycJvxMh3yf6+8TtZPDPExUNln2c8RHiO1xyfxbURU0/MwlfE
1HdrzHzb7xFeYPuoLJ7hc+07Yvn77Lcetj1lzP486THYbrdPBttXPe1nYmBi
c+LiSXqvE/OIvfFhL/tnlDGxOT69zP/+rPFonadk4Tfi9HVaY6336V4dC22f
l4UfiP3vk31RIeL3WVn4k/h6ThY+RBOYojGN8oi3h+m8xPbpWfiQuQ/Adb3m
wiz8hj4wXPalxg/C5QqhD+ALdAB885rx636er/a/v26MbsDzfY39uSSLvbjK
/4Yd3YADDWGMfXWtPxf4By0C2/26hsW+xzG2oy1woDOgJ2zQmPXeg9G2s8bP
et9PChHfPeO9Y82PsvAhOsDqLPyAzvAwvMv2FVm8L9rCI7J/ZLwqC3+iUTyW
x/rMfRSOYfu6LHyIXoGugb6BLvFFFv5Euxip8SuNJ/tZYuxDsn9YCG3kDc/F
ryP4e+o18dtg//tUY3QM/HO7/x3/3GGfTTeekcJfQ+zDGcYzdf5S63/h52Ya
f8fy0DimeU3W+DqLa0MP+TYLX6GHPM7fLNufEF5l+7IsnmHu5bssfIgO80MW
vkIneUrjPzd+ku9wj4F3o5XDw8Fo5fDDZzRmTSF0FXQT9BM0ky1Z+JNYeBSf
I2N8Osw+XmDMPO5ruPdlqtdh7CLb0V6+1jpf2Re8RpNZYr89ZJ/gu4ftWzQa
tBp0kg9sX2r/P2hfztBazfPQbv7Owm9oNTfqfJnxs/r3dYXQYUrsEzSc0Tzn
xrn9hp7znPAG4235ri6EtvNvFnvBOs+zv7a/IPxlITSf7e1P8E7225O+T+6R
+3gRP9iOHoQutMq+etr+XGg7PkarIC9FnP29MXoGa46yb7/Rmhvti89tX22/
Pev3X22MpoQfR/t6ButabiiExrTG9rUp6pfQmnQq1YjIweUptKYXbB9QCE2K
HB6aEvk7ual0z9C4uBZ0J+bukUKzYu5uKfQlcoIVUuhI4G1SaE3k9fZMoY+R
16uYQpsCb5tCXyLPV9SNwNsZk6sr6kZgdBE0K9YsZzt5waKuQ15wH2PsaEr/
sx2dabHvZZHt5A6LmhO5w6KeBC5qVIxBp3razw/fmbvmUYOFLoVOQG4JLQH9
hxxi1RS6E7nFyim0pvH21W44Pot8JLoTecYqKbSmifYtuhD23VPoTuQfq6XQ
gabaV+hO5B+rp9DlJtvP6E5T7Gf0FvKAx6TQl5iLvoF+Ncn7xZrkLIva0jT7
HEy+uahXzSjZqunOsJ/B5DKLse9M+xNMnqyoIc2yb7d4zUq2k+NEI3k1Dy2J
ejB0ptn+jKBNkes8KoUux33VSKFfzbFv0aPIgR6dQoN63/7cPQ/NiLzpb1n8
jeC78eU8tELq59Cd5tu3aD+L7B/0K3Kpx6bQoBbYz+hO5FJrp9CdFvp6mEs+
FY0EXWiRv5/L2Y5v0YfIoaI9oPEssW+39fNT1JzIv6JLoJtxbbU8d6n9XM5z
0Wa295qHGZPfRTtBZ/rQvkVPIyfbMIWm9JH9uUceeha5W3QbcrUnpdBAPrE/
0ZTItzbic5mHbkVdHPrSCj9X6EgrfZ1oTeDGKTQf8rxNUmh98/y5QLP61L5F
j1plf6JB8XetWQqNC3vTFLr7jf7+R2f63H6GK5GPeTqFlkMOGE0DzWm1/QMm
T1zUmdbYz2DyxGgme3tuURNaa/9jJ3+MXoKO9JX982Ye2hM1eGhW5IjPkL1C
HjodeWW0FvK4xLXoS8w9M4V2td57hL5ErvmsFDrS1/YzWhM591YpNCvynmen
0JS+sT/RGMnttk6hXXxrX6GBkJMuakib7E80q43eF+zkp4saEvnptsbY4RLV
bEfzQU/7ws8PdnLYRS2KHHZRW/q+ZKu+tdk+R7sgL3xhCu2CvPDlKTSnH+1b
9J9f7Z+38tCwqBtEayL33SGF1vSz/bxnHvoU+XK0JvLgHVPoQqzDe6E7/Wbf
oiOR/+6aQnf63b5FD6fuonMK3Ym8eZcU2hjXhpaDvrTFfka/Ym6nFLrRn/Yz
mNx8UVv6y75Fr/rbvgWTXy/qNP/Yh2By7UUN6V/7E0y+/BKvyToXpdCT/vNz
hYbEH+6i5gRGF3knD92H+saD/BzyuUC/Il/fi+c/Dw2LXD4aFHt0WQqdijH4
HE3vDz976FHsHX5GHyA3fWcK/Yf8PfoG+hW5fvyDBkV+v3cK3QmMn9GdyO9f
mUJbYi77gi6EvYvt5P7RSdCByPHjHzQncv9FvQqMT9CQyPfjW7QX8uIDbGdu
f89lzW5ek1qBorYEvsSYWgF0lHF56FbUW6IvUSdwfQp9aTf7cK88aumoJ0Br
QuO9IYW+tIf9iV61i/cFrYlaghtT6EvUEtyUQneq4M8F+hL2K3yP3BeaD/oV
9QY3p9CdqDG4JYVetJf9iU5V0T5HtyCXf1sKnbCc10RnqmTfovfsZ/9gpwZi
UArNaR/7GUx9Q1Fz2tfXw1xqFwbbvp/fq5Xt+BbtiJqHu1LoTwfYtxPy0KGo
XURTqmzfnuZrG8h3bx76FHUSrMlc9AZ0p6r2M1oTtRBDU2hK1exbtKbq9i06
G7UQ96TQOmrYh2g41Crcm0JrOsj+RF+i7gENBP2Kde5OoS0d7OcKDalmYav+
BC5qS9RVDPO97O3PRXvb8S360KH2Zwfv0XCPwY5+cpn/3i1P8fdutb+H0Vqo
50AvQfOhBuOxFPrTEfbPxDz0LGpi0Z2owXg0he50lD+z6E7HeF8q5aFVUduB
BkVtxogU2lEd+wcNinqMkSk0qGPtE7Sm2vYt2gv1DC+m0JqY+0QKLauW9wjd
iXqRooZU134GU+NS1JnqF7ZqgfXtTzC1FM+k0CqOs6/A1CiMSqEnNbA/e3jN
+22nFqSoLVELMtoYO7oT2tIJ9i3aGvf1uPDk3BpWITSihvbnPnnoU9SRoEdh
fyGFjkENxqspdAzqVIiv0aAa27doPs3sHzQoaldeTqFlNbGf0aCoS3klhQbV
1NeD7kTdCToTelQzvxeaU3P7Fq2ImhX0DTSnFvYtGL5U1JmoU0EPQUfi2l7y
3FPs5/6ei8ZyndccZUwtS1FnOtW+RWc6zb6dmofWRt0vug21JeNS6Etn2Ff7
5qGDUO+CvkS9ynivyTroMWhNZ/m5Ql9q5etEdwJPSKEvUQ/zbgrdr1Hxc5GF
Hd+iO7W2P9GL2KNJKXQq7BP9nXm4nwc0pzb2MxoCNSGfpNB7qKGZnkJ/amv/
gKmzKWpO7exnMPU06Bt3eG5RizrX/sdObc0M4f3y0JKorUF/op5mZgr96QL7
BE2Jepv3Umgn1L6gCaA7dbCfh3hN9gjdiTqfOSm0po72M5oSNTlzU2hN1Hu8
n0Ib7Gx/EvNSqzMvRQzVxb5Ca6K+Yn4Kfamr/Yl+1cn7gtZETU9RW6KmZ6Fx
N38uHrAdfWl6HvoaNdXYqfspak7U/RR1pu6FrRrVxfZ5R+/dYO9dW6+JztTD
vh1YiBogvl+xUyeEdoKOdan9PDMPHaqnv4N7+Xt4/zw0KeqH0I562f/oUdQR
fZRCL+pjX6FHUVP0cQo9qrf9vK2fJfz8kK8N3eZ5z12RQte6wvuFHkX90soU
GlRf+xzdiTqkouZELVRRY7vKfgZTn1TUb/rbn2Dqiora0tX2Lev0835hp4ap
qDNRw7TG+Bo/b6Nt/8D3cok/F9ipc1orfEAemhT14WhSN9iOvnWd/U9dE1oT
WsegQmhQ0Fl0Neq3irVb7N+HKTQn9KxCCk0LvJ7PoPeXMZcZEzOyHus+bzzA
61fOQ8PZJUXNDLVA6DPMYy32eomvn2unvp16pF1T9KZRu4JuQM/d7Z6LHsSa
aHsne+66FD19rM890n9HzQ86D7Xu1Aih1dA3R61RqSZTiPoiMD16YLQd6uSH
GlNLf6fXod5+iNend4810Yh28HVWTVEDT/3MgSnq3qn/qZyi/w5cJUXd+33G
+xkzt6LnMp6+LfL+xGvUxg+zH6iHp1aneooadWpX0Blq2I5OQj38cOOaxugt
1LdTV3Nkin495qI/HGY761Dr/rDt9NlR94JuQK07tS5oEbWN0SLop6O+BZ2h
qq+TazvIc7Ef4zWZS538CK95onGxvp3amxNT1LdTW0Is3NQYTYBa9yeMWxg3
SlGv/qRxS+PGKXruRnodauOfsp3aeOpGmqTo3XvK+CzbifHptRzqZ4b6+Wds
p6admo3TU/TcgYmXW3sMOkAz7x126t5Hex+pyyVHBj+hbpw6CmJe+uxeMKY2
nloOYuqOxsTR9Ag8b3yJ5xIXd7Gd+JH6duol2qfos6OegViS3jrqIojZe3oM
sef5toM7eDxj6FMjF0+8Qw38q16nla+T9+pnO3EotfGvGVOvTm0AsRv9etRC
EG9SM/+G8Y3GXVPUulPv0TNFjwbjO6fo3WMd4jv676glIHa73tdG/HW135fx
fTyG8e3tc3xInfzbnkudPHUFxGhDjVlniMdgr+bnmWebOvlx9gP13uR84eH0
ypFbJ/a505iYiJ47cv3EWdS9TzB+xJh4ivr2SZ5LzdK7tj9tO3ETtevktYek
qHUnR0/cRD38ZI951hj78x4zIEX/INdMTPSS1yEeGeH34jqpe59m+6vGxCkT
fI/EI9TAkx8npnjLmHiEGviZxmON8Qm9e9M9nhr12V6Hmnbyy4+k6Jub6+d/
pMfzvpM8njhlgH14XYqeO+YSC9BbR+4Yzvmm1wG/ZjtjiL2IwcjRz/VnDZ5P
rx/5a7g9PXfkBOHG1MbPt32RMfECdfILjD8whvNTu77Ic6d5nedT9OJhhz9T
607uFQ5MLx45XLg0NfNLjKmlJ+cLZ6bnjhwcPGeN7cx9z3NZc73XJAahZn6Z
8ZfG8Gd67siNwkupM19uvMkYLkq9+kfGm43hkNS9f2y83OuMTdGjhx2OSo8e
uWZ46Vpj7NTGr7D9M98j9/W77fBVevfIjcJFv/H9zk5RS7/SY8h3kTOjdpq8
Fr395Laonyf/CE+jpp1cIdyPfjfs8D3q3j83pkcPDPejvnq1MX15zIXX0a+3
2utQw7zWdngQfAgeSOKOHCi8lDp28p7wT2rXyWMSp9CntsrXRh07OU24JX1/
rAnHOzAPTgOfgb+A16f4TQPqz7MUXIsc4YYUHO1b2/n3b21nDPwJ/gPH2VTY
+nsI1KXnHs86+q/U9p3XwbebPYb1sX/hMZuL2PfynsfAdeA57MMP3gvOP3od
eND3nnuLv8N7ecxP3kdyZfAqeBQ17/xGA3XvpbXeha2/28C/lfOYX/1ePAO/
ejwYrgZPIyf5m8fD1373GP5Ww9uosafWfovHMH5LGfufxnAx+NmPHsNcrpN/
Zxw5U36Dgtp+8qSc/7GdnCp4o+3/GmOHa8IZ4Ib/2c6+sxE8A+QjwdTJk6uE
17Kn5GP/9XsxvsRj4IMF4yp54AP9DGSey/v+6Wtjzcz3xZjcGDv3WzlFzhM7
+zvO340j/ZywL3BdcqRwaDA5THhzBe879p+8DlwWHguH3c529re854KZ+7PX
LF8Gw5urpuCMcNxfvKc7+r143x3L2Hcy5n3L+b0Yw9xqKTj4Dl6f52EXP3s8
h2B6Dchtwu0q2g6fhq/CnXfzGPZud49hPJh+AfK68P69PGYP23mvXcusD/+u
4b3b0/sFB6/g8eRKsf9rf5bzXpBrreg9qp4HX4erw8338njWrGjMM7y3xzMX
TL8AudlK3hcwnP5o7xHxBoEZ44kf4PzEAft4LmP29Vw4+/4ezzr7GuPnA7x3
xAHEBiW2H2hMHvIAY/KrB3qPsDOeWICcKLlR6vx5BqqUGbOf12cudnoWyA9X
9X6BiTGIL+Br1TymNDYqMwZM/0JpDtn7UpqLzoLjEaMcVGYM+WZ6DfD5ofY/
11bV67OPB3sdeDf8m/pqctHEWsRZrEOcQ4xDfHOI12RuTePSWM3vS674MO8F
eV1iFeIU4h5ioZ08BkwsQ0xzuP3G3h3huYw5wuNLYzjvO3nmI8tg7NTes3fH
ei+wE18RW5XmnG0vjds8nnirljH+OczXwHjW2cXXc6SvgXupbT/zXrU9hniL
e6RPgb2r6zGMr2s7uet6Zfa3nu3EdnW8Dnt3nMeQx25gn4PJee/ua2N8oxRr
Mp4+joPz8OGJfgYa2E78d7wxe3eC12Qu9iYp8pPEPMQ75NKJY+v4fYkVm6aI
C4kV6bNgv07ye5G3Psl28r2NyuxpI9vxM/EtPRGH5rHO6X4emng8ue7mHsM6
2OmtYExTY+zEosShxKPNbGf95t5r1mlqTG68hX2FndiVuJW891m+L/x/iscw
HkxfBnnvln5uGdPSdsYQ0xKLEcueajvx2cm+fp6H0zyX3Pvp9jNrYj/AY043
Zo+4ngP9vsTGxMXYz/Rc1jnTY/icnuG57OmJfjYYQ0xLPEvsSwxMfwR718Y+
L42zs+hZIL4/237AJ2fbTv6f+J/Yn3w5c2t6fGuPIa/e1nsBJtdObwWxeDuP
533bGh+Rh7299+5cz2XNhr5+8vDnldkjrrO1x5/n9Xkv4vwO9v+F3gvmXuD7
JYff3nb2pb3tjMEnF9p+gd+L8axDjwlrdjQmj93F/kRXON/XwOelo/cI/aCV
94V10Bc6+ru0s8cwvrO/V0s1Bq9PDyl1hui9xP1dPYbcJrE3sTZ1BNQT0KvC
3nW3T7g2cu30vDDmItu5notsp9YAbeUcj0eP6Oxn4BKvSd6+p/3J3l3qPWJN
NI4uKbSNHh6feQw9LOT20SMu99yetqN5XOxrODoPTQQ9pJRTewy1A9R51De+
3PvysnE9Xxv6Czx8jHHRfpkx13Clfc466CZoJvgZTYc+l5c9voM/F1f6fdFI
7vD1v+W59b1mX88t53U6ec2+fq9XfP1c89v2A+PJ85Pvp3+E2oTr7ENqGahp
oHcGfLX34jXjBn4vNB10m9c9l/Hv2N7Ac9GMentf0J5O8HvdYDzWY5j7hu1c
Q3mP7+r37e/7Yi7a0JV+32t9beNsZ0327mbvI3UKg+xn7MRL9NEcm4fegdaB
5jHA9jH2Cfu4m8cX93SQfYWedKsx66MloSPt7vdtZt/e6s9FOV8/PmHvbvP1
UBMxuMyeglt4zduM+Yx08+f6Xb8XdvgnPBPeiM/R1OjZqWjc23uNvkaPD++F
XoYGNdEYO7UY6GI3eZ27vKeTbC+uif6F9kUtxr32P3t3j9+ronFL7+m9xlzz
Y/bPZK/T0u97l9dn7+73mnsZ0x803t8t9OlgR49Dc5tiXBwz3PtYxbi11xzm
MXXz0PXQ9Ni7h70vaG/ocfT77O3xaHfodg95nT3tQ3xS2XPP8TPwiHFlr4Om
V9X2G7y/d9jPVe0H+oa4fnRDenyo6UDvG+p9Qd9s6/HodGh0042Zy5jHvY8z
PLet13ncmL17ynuKRohu2M72p42rewy4hu3sb3WPR2NkzRF+L/ZuVJkxT3j9
GrbTX0ONybPeIzBaJDokuuZoj+Henysz5jn74WD7ZIDXZDza5myvwxhqOKjl
oM+IvXvFPp/s92X9qR4zxJ+XEfYb+uRLHn9cHtoouiga58tec6rHgKkfedX+
n2bcxeuge6J5MgY9FC10ju2MYb9e99xjjOl7ok7kDe/1XM/t6vFvGLOnYzyG
OhTqUeiBAr/lfZlhTM8UOuvbxtRoTPW1zfRcxtfymoyh7mOsfTvTuLg+esRI
79d4j6ltTF8VNS8TyuzpBNsZg56LljvfGPs8r8n67ONEz6UuBt0ZzbmO7d09
ZpJxLd/XCI9BF37C+zXFe3eSMX1SCzymuzHaMT1H1I+g26LZohlP83g0YzRl
+qHYu+n2W0Nj7NRZzCizvzNsZ+9m2d7Q66BLN7KdfiXqXOban4yfbTtj0JfR
ltm7Ob7HE/K4NjTtxrbTt9XYc0d4/NwydnRtNO0lxn38vtTZ0NtFTc1878s8
474egw6OVvyBMXb2bmGZ8fN8/U1t7+cxi4ybGT/hMejvr3iPptrPS20vjl/i
fWnuPULbX2A76yy2f/DVMu8d46n7oP5jqPfuI/uc2hpqbOgzou7mQ9sXGmM/
KQ9tHV39DM+lzwutfbnHUIPzsfeFayB/cLPXRNNHz19ufJPHr/AY6mvQ4tHh
W3ku+7LIaxbHkwNA///ImLns3SqPp5bnM+/LEmN6yliTPAE5go+NsbN3qz3+
bOMBHr/KY7i2Nd4XxpA/eNf7vsbjP7EdvNj3hR/Yu3WeSz3Ren+OlhoP9Prr
jNH10f3pH1nofXnec6kbo9+Nuh/qf+gXo/6IPAo5lGXGjGE8+QlyEyuNB/kZ
2Oi9+NDrjDXe6DUZg56Olk6u4xvbl/v5YS71QZu8F8t8ba96fzf5GWuSx1xy
Jau8Jnb27jvP7Wh8t+2bjbGTOyE38ZkxdvbuB+9jJ2N636hF+tH70snrFPf6
R48hr/KTcSdjci7s3c+eu8LP4UCv+bP3gjG/GHf2HpGX6WI7zy2aKn1K6Kvo
1fT2oHtT9/S794KaJvJJk/1e2Ok3YR3yQ+R01hhjZ++2lNlH5tKX19X2IiYP
RA6ImiNqj+hZY+/+tv8vN37U9n+MqScinzTPe/Sv932t12R96oz+816sMmZ9
3otkynLvETVJjLnCmD47aprIdc31mILtjCEvRU5qvTH2dV7zMe9X7rnUQ5Eb
w+e9bR/pMdsY9/J9vecxxNvE2nymtvXcK43p49vgMczlt2v4rWl+owatGv0a
nZtcWXmPJz9GnoxeP/Zoe/utjzF2aq/I1c33Pu5gO/7cyfY+XodcW1/bqV9C
U6cf6UD7f2fbGUNuj7wedUP0le3ie+HayOWRk6FnjBxNP88lf4cGTA8POjC6
Hf0n6HhoPPRIoBERb1GnTqwH96eumlgADkjtLzwQjkA9K5yB7yTqMvle4vuD
ekS+Q9AJ6BlAT+BZox6OZ4+cIXlEegapdaLea53vhfqqcf7e285+JkdErohc
E3vC7wkdkKLvq5oxtVPY9/fn6Dd/Btk/fjuHnib6b+k9nZmiD4ffxD4hRW8S
v919RIrf2wHzGzvoqeiq6Pq85vdj6MHh92SYW8lr1PQ66Jrom2ii/FY0v9Vx
QYrftOa3Uk5L0aNyuDF6GLoYGhu/I0CfOrXE/A4Lc+nR4D2YS88LvRlHeU1+
DwTMb3SgqaCzoM3we8/81sWlKfoQahnzOxhgfk+DuJxYndia1/zGAzX2/DYw
+NoU6xZ/M4Oa+zq2E8MR+xEX8hsR2PldCA5+z4B6cn4fhnvkPvitZex3pPjd
A15zr8QHxAzEH9Sd1/eYLt67+7wnNbwv9PLzW8f8JgD8Av4BT4HfwfPgrfxb
sWed3w8GP5einrihMT389GQX+9yxY+N3ebG/k6JPmd/RpaeYPm7+jWeHv138
DePvLf/OszQrRZ031/ZwihrQZrZTk9rYa7IWvbnULvLbt+BlKWocWxjzWaD+
j3pH8uP0yq5PkT8Fkxsll03t44YU+VAwuTZynfTZfpGiF5g1qT8kH4e9mLuk
55ZcJDloMDlr8sX03JJ35j4a+F7IUWIn50hOkF5ccojkdvm7VswRYycHTX3m
N35f8nr8vauc4pka6+eHHCU9qOQ90VvoZa2SIn9KHyw5UHJ24Kop8qH0spID
JW/F3OopcnPYq6XIUdLnSb6SfA29neSGyG/Sv0qOklwVmHwWuR56RMkxkQeh
55BcDDlB5qL/kM9iTfJi5O/oiSVXSP4ITC6JvBv9luQEyc3R/0lOjfwOmDwO
uTP6P8mLkZcBk38hv0bPJ7kzNHwwORfySqxJ/oj8F32Y5KTIZ9FvSR6K3Ap2
8ibkR7CT7yAHyn2RSyVPRB8muS3yUPRYkmMilwFunCJvwphGKbQ4errQ0Ep1
3Ty0UHIQ9FU2TaHD05eIZk6eiN5LdHs0fHCzFDka+hvJ+6D/g9H5yZvQu0h+
hFwM65C7QYfHjlZP3oFeRPIL6PD0NKKfk9egp5F8B3kB+hjR28lPcW3kttD0
sKOBk0NhLnkZtG7WRAMnd0B/IPkI9GowmnCpPpyHlouGT38g+QI0XjB6Lxo+
vXzo9ujAYLRTdHV6AtHtyS+wDjkC9FXsnVNoqvQKdkmhq4OL+jx9hujq5IN4
Dpuk0Gyxd02hr9KDh16ae4+KGjh2tHRyDfgHPfMt7x36JzEg/TPEg2i/9N2h
5aJh0t+F/laqReeho75jjPaIJkzfHRryOM9FxxtrO7oieix9bmizpTWDeehX
aK30thV1XTDaXWltYB7aF9oUfVNoUHt6LpreeK+Jloj+SQ8beuYk46JeSj8b
micaI/17aJJTjAek0A/pOURvnGpc1BLpMUNjnGaMpjTZa6KhodHRJ4bGhS5H
Txca4HTb0ZFm2I4WVMH3hYaMzkb/GBogWhw9Y2hos4zRamZ6DFoQ8Qi9KMQa
5bwv5BGI9+nFQj9Bo6CfCt0A7Ys+LjSxOcZoJmg79GKhd801Rt9AR6I3qahH
sQ6a1Tzb0SXQT+jFQodBi6AXC92grp8f9B80GXqW0B+O8rWh6S20HX2gjuei
Uy3ymsS86Cr0C6E/LDYuaiz0MhFro3XQv4Rm8oExMTL6Bj1LaB1LjYkr0Tro
a0LHaOJ10GqW2U78SwxLHxHx6RnGRV2C3iE0hNl+DtHNltte1BPoFyJmPNt7
VNQNsKMzwF/pDeBvNDU8/C2jNolYm34hYkbiVnppiHNX2E7sRpxOrxcx+Epj
YkBibXp1iK9XeS4x1Ke2E8sQq9KHQ/xLTEFfDXEEcSg9OcXYFkyMA5emJ4fY
BD7FbybAqbp6LlzrM69JbEVMSh8Osd5aY2IHYjR6V4jFiKfoVyFGW29MbEUM
Qu8TMdQGY+IRYhz6VeDzXxgT76zzmsR9xDX0rhAfEbPQr0K886XtxDtf2U4P
SxffFzE4MQO/z0AcwJnfayAumOX7JQ4gPnjJdrgl/88eeP1rxsQBcHlew+fh
4PSVw7exvW47/z8devmL3BwMn+f8pjHz3vLcOV4HPsz/R4Y+a/g1vJieVngv
Nnqw4er8f1vgS3BzzvQVw51m+9q45nmeC+8+xmsyF9sEr8n/64S+zmJsAYbX
8f8NoT+xyJfBcGPOk435f3DQi1fky2B4LOepxqw30Wvy/7agD6v0N47y6MuC
Aze1Hcz/n4I+Kbgwe/Kqn8PmtsOBiedmeb9eMSbO499negz6GD14aGvEX+95
L/Anfa3EIPgNPxIDEYvMsf/HGBOHET/N9V68bUyMRUwzz76t5XXYi/G2Ew/B
6xf5fvEDviaOgT8vsG+JLRbah/w2wMe+him2E5fU99xO9htrEjcQQyy2r2YY
E1sQI9BfRNzA88zvnhDz8tsnH9hvnJcaVzNmLJ99fuODWJj4gHXg6vzmxzI/
V3wuPiwz9sN8a+zL71Ac7+eEeyTu4XcpludbY2FiY8byueB+iVuX286YT7x3
E/15Ye+Ixfms8dsExLz0v6+yzyn+XeE94rzS+Chj5vH8M4dYtZbnYqOH/tN8
a4xLPzlxLj4nFq1n2+fe6zrGjKU3erX3hefnE9/Tas/FTn/5Z57L54t+YOJ3
eoLX+hngvC7f+lmj33V0il7V9X42OG8wbmjMWD539HASq9LH+YWft+O9ZgP/
+5f5Vm2DvsSZKZ7PL70GfYpf+Vn62PfCc4jt63xrbEr8RnxKj91GPxvNPIa1
eWaI7xj7f9QEyII=
           "]]]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJxdXXdcjm8XT8jKKKWUWUrDljKqK9lkk8zISCRK2aRkRCpJZUbbCC1Nz9Xe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        "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nXd8T9cbx9UMNWKrGXuF2iIiN3YokqKKErNGjBIjQeyd2Hvvqs2P2OEb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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3XW8LlX1x/GBe869c0RQuku6u6S7u7s7BeluRFRUQrpFFBQQCYkfLaKg
IC0gEgKChBLSv/W++/u88I/j+bpYs2eemb2fM3et9Vl7xh323WCfcbuuO2Wi
rhtVvyca3XVvlLhynK5bf6TrZqqfq0tvWL9nrZ9flt64fs9RP9eW3rR+z10/
15fesn4vWD83ll63fs9QPz8vPV+NOWqo6x4svXnZ5qufG0rPXfau7A+U3rFs
y9TPHaV3rt/L18+dpWcpn4/reu4pPVvpz0rfV3rb+u+L189vS29dvxepn5tL
L1g+o2vMP5ZepPRI6YdLb1Z6ztKvlN6j9FKl3y29TOmJSj9WeqXSU5R+qvSq
pacu/Uzp5UtPWvqJ0kuW/lrpR0svXvqrpf9ceo3S05V+tvTapWcs/bx7Unqe
0q+W3qb0/KVfL719Xe+S9XMbXfaFyv6G+1x6ttIvuv+lZy79QumdSi9a+l+l
fzem674z3HVP1oPbtexLlP3tsj9b+mellyr7QaVXK/1R2Q8tvWbpT0ofWXqd
0p+VPrr0+qW/KH1y6U1LD9WxB5ReufSHZb+09P6lJyv7CaU3Kj1u6YtK71t6
ktI/Lr1j6a+WPqv0LqUnKH1O6d1Lf730+aX3Kj1R6e+V3rp0X/rU0luUHl36
itIHlp6i9FWlDyk9Vek/lD6n9AKl9yu9Qun369p+XfrY0jOW/ZbSJ5eepfRt
pU8tPVvpG0ufUHqm0teWPqr09KV/Ufrw0tOU/r/S3ys9R+m7S59eeq7SD5c+
v/RCpR8pfVHpRUrvXXrZ0v+pa3i89KWlFyv7A6XPKj1f6ftK/7j0PKWfLH1F
6SVKn156u9JfKf230r8ovUzpQ+qZLlPP9LLSb5T9prKvUvqt0r8tvVrpd0vf
XnqN0u+VvrP0WqU/Ln1/6fVKv1b6htIrlZ68xvx76R1Lf1j2e0qvU3qSsj9f
evvSfelHS29eerzSj5fesvQEpZ8qvXXpCUv/tfS2pccp/cfSG5X+rMb8fekN
Sk9V9pdL71x62tKvlt619HKl+/pcR5XeoPRUpU8tPWvpd8pn79LzlP6g9LdK
z1f6o9IHlJ6j9H9K71t6ptL/Kr1n6RlK/7P07qUXLv1p6YNKL1b6i9KHlF6x
9Hh1rmNKr1J6gtLHlR5V+k/ls0np1UtPWPYTSi9derj0EaW/WXrc0oeVXqv0
JKVPKv1Kfd7r6tgVSq9b9snLfkrpF8v+y7IvV3q7ss9a9h+X3rH0HKXPLL1L
6blLn11699LzlT6n9L6lFyl9QektS89U+vTSp5Ver/S1pfcqvWDp80qfXHrt
0teUPrz08qWvKH1U6ZVKX1n62NKrlr6q9Iml1yj9i9IHll6y9CWl9y+9eOmL
Sv+g9Ialry/9o9KblL6h9K9LH1z6wdKbl56h9PdLn1d629K/LX1J6Z1L31H6
8tK7lb6z9IWldyh9W+mflN6q9M2lzyy9eekbS19Zes/Sd5f+eel9St9b+ubS
h5V+qPStpY8s/afSG5eetvRppe8ofUzpR0pfV/rbpR8ofU3pb5W+v/RdpY8v
/ZfSC5X+uJ7RgaXvLX1S2R8vPWfpDzPH/lL6zLL/rfQTpX9S+u+lny59XumX
Sj9X+sLSr5R+ufTlpf9Z+s+lf1T6udJflP6/0p9a46UvKf1q6U9L31b649Lv
lL629L9L/6f0r0u/V/qD0jeW/qD0R6VvKf3f0v8s/fPSb5V+tfSVpd8sPW5f
96/056WHS99X2h/y2Uv/o/Tkpc+qvzP/LT1z6a+X/eHSY0pPVvqx0uOVnrL0
k6XHLz1x6UdKj5Qer/QfSg+VHin9QOlxS09T+pnSXys9fennSk9Yeq7Sr5ee
svS8pd8sPXXpf9U1X1P6nbrOBcr+dulpyz5L6ZdKT1r6G6VfKD1x6UVK/7v0
9KUfqmN/UPqv1njZ3y89Y9lXqHU3Zf4un1ufsav/P3vZzys9buk5Sp9fesjf
/tIXlB5deq7SF5X+ir/Npc8p/XmNOVvpTUq/O6q921xYui+fuev/b1T6nVHt
/WfSsr1Z+qrS65T9X3lfWq/0W6PaO88Gpd8e1d6dLik9QR0zX/3/i0t/tfS8
pTcr/e9R7d1pi9L/GdXeixaq//6VvMP8pOyf1rXNWv9tu9IfjGrvPDt5pqPa
+9KM5f/JqPa+tEPZPxzV3iu2Kf3+qPZetFXp90a1d7O5yv/z0r8rPXvpcYba
O9WipcfP+9ISpb+ed5uz69iP6xpmqWOWKvvEef+Zv/SYvNfNU3oo73LLlp4s
71QP1rM7rY59up7dymWfJu9XL5T+Vf72beq5lX657Bt5Pnn/2dx9yjvbVqUX
yHvUDqUXy/vSOqVnybvW8aU3KD1Ojblt6YXzrnVY6XXz/rNP6RXzt/tbpVfJ
u8S3S6+ed56DS6+Vd6fdSi+d96udS38z72DHlN44704nlt4s70U/LX1o3mF+
W/q7eSf5funt885zRuld8750duk98r70w9I75d3gu6W3yXvRKaW3zLvZuaX3
zjvVBaX3yzvVr0ofUXq60leXPjrvNnuWXi7vuteVPi7vP5eVPijvdReXPiDv
cjeUPjHvVGuW/kbeaW8qfUreo1YrPX3eje8vfXbec35f+ty8//yx9AV5Z/tT
6YvzHvXX0j8tvWTpe0qfkXetf5e+K+82j5a+LO9ab5e+I+8/L5W+Pn9n/1H6
N/lb/Hrpm/PO82bpW/Pu9Fzpq/M+/FTpq/IO9n7pe/Pu9N/Sv8t70dQ1V1/L
O8ydZf9h3gnHlP3PpTcrPVL6ibwvfbX003lfGir9l7xXfF7HPpT3ok9KP5h3
s6+Vz7N5p5qo9N/yTjVd6TfyvjRj6bfybnN7Hfv9vMfOXPZ38/4zRelX8l43
aekX8y43W+n38k41f+nP8h61SOluuL0j7Va29+q5TeLfPmUfyTvP8qW/mve0
lUp/Le9Oa5SeNO9Iu5aeP+8wS5YenXekPUovlPeZxUuPGm7vYGuXniLvTtuW
nrn0j0pvVXq2vOdsX3rOvC+tV3rqvFPtVHqevDutWnqivL/tXXrRvAudXnrT
vLf8uPQWeW85qPSyec85ovTKeUc6uvRqeUc6tPQKed+evP6mPJW/g5eWffe8
zxxQeqm8I+1Xeom8px1Xes28X51Veuu8z5xTeru852xSesa8q5xfese8L51S
ev28v3239Dqlf1X6e6U3yvveVHU9f83f4g3LPl3ema8ovVfer24qfUjpP1qz
pQ/Pe9otpY/Ku9P/lT4h70jPlL4o7zC/LH1g3pFeKn1p6ddL/6L0/nkHu7v0
yXl3erj0j/P395HSZ+U957HS5+R96b7Sp+ad6snS5+fd6bbSx+b97YXSV+Rd
aFR9xvvz3jK69O/z3vJG+fwy7znvlr4h70jvlb4p70hvlb4u7xKT1LGP513l
Z2XfN++Tr5X+Rd6RXin9s7ynfVj6t3m/+lod+8fSo+vYr5b+U95zLiqfXfLu
OmHZH8370mdlvzPvbx+Xvj3vZl353JP3vT+U/fT8vZu27M/nHWnZ+rm31tzb
5f7t+nu6+kh7J5m1fF7N+8/cpf+Vd6f5Sr+Td6c5Sv8z73IzlX4570hn1s/B
/q7WuDOU/e95B/tm6Q9Kz1R6nzrPKiPt3Wa/+r3qSHtH2r9+rzbS3pF2q98r
jrT3w13q9woj7f1qwRrnP3lPO6hsa4y0d6fD6vdaI+3daXZj188/6nMdUr/X
HGnvS/+sn5/Wdb1Y9unLNl39vFR6obL/YpymF/TM4rNknWvCvCMdUb5rj7R3
pG+4lvp5uXwWrv9/zThNL1r6unHaeedyL+vn1dJ71e+VR9r70mL18+txmn2R
0r8q/UrpWXzWkabn9Tnq57XSH5XP3XlGe5RtpZH2zrNA/Z6/fl53nfX/by2f
N0p/s2xL1M+bpZcq++3jNL106f8r/a/S4w61a/536cXKd9GRduwK5fOH2L9Z
+pbS/yy9XP33Zb1Hlv409+cd9tL3R3+Re/hu6WVK3zVO81++9O9jX7rGWGqk
XcPwUPvs/ym9Wvk8Wfq/pScfap/lo9Irlf1Ppd8rvXLpR0q/X3qC8vlN6Q9K
jzfU7if7EuVz0zjtnixc51lopF1/P9Sei3FW9O6e865S+i8ZZ/XST+e8Uw21
+/Zx6cVHtXN5FmuU/mvsq5Z+vPSHpSccauelJxlq981neaDW3feGW0xs2qF2
/z8p+5p17HPRa5f+e+nPSs861O7n56XXKftL0XMMtXv4Rem5h9oz6upnpqG2
fh27Ufm/U3qoftYt/Y/4Lz7UPiP7gkPtfo7r3wLl82b0IkPt3o4S6yv7W9Hz
DbV7NY5/R5T9tZx3yaH22YfrZ+Oy/zt67aH2Wcarn02Gmv8E9bP8ULu3Y+pn
paF2D/v62ayO/W/0pqU/iM8mo9r7wGjvA0NtbtCrDrX7NuI9vHw+jt6y9Oc5
73pD7b59tX7Wt+Zz/VsJJI/b7FuU/rR+f6V+1ij/v0VvONTu2/j1s9aoZv+0
Dtu69Khxm/208hm/9AzGHGr38Ov1s51/i47b9LZD7R5OWD/b+/fquE3vMKod
OxGf0mN833vnH2qfZXI+Q+058tmlfCYtn8lK71R6wnHbO9KeQ+1eTer937+N
x216n6F2P/nvWPavlX1iPkPtGdG7ln3ycdu5vj3U7sMU9bN32Wc2T93boXbf
XNvuZZ+67FOW3qP0tN4FSh851O7J1KUPG2r3lv3gofYs+O9W/lOO28bfs/QM
8T+mfIZLT1P6pKF236Zz/f72RG8zqvmYP98Zavdw+tLHD7X75jr38l2ccfb1
vR+f/UrPmWf0LX/DvMOWfrKOXb70EqXPHGr3babSB5TP/NE/GWr3fObS5w21
ezVL6UPLZ+nSc5Tev/S8pb9R+udD7RrmLP2jofaM2A8sn4Vz7MGlF/cuXPry
oXYPZy99iL+L0RcOtXs1a+krh9q9cq5v+5uX6znM3+yc67ahdg3zu59lXzP6
2qF2D+cu/euhdk/m8bzKZ+XoI0qvGJ8Zhtp3tXl+31C75oXq/x8+qt2ruUpf
M9TmBn3jULu385b+v6F23xYofWz5rx19yVCbMz7v3UPt+hcsfctQexbzlT6q
/FfNOEeXXj32g0ovmvtwXOl1c+zxpdfPtZ1YeuPSi5R+eKjdw0XNpbJvGn1y
6S1KL1b6haF2rqVK/2GoPQvHnuBdtvTCpR8Zas+X/2ND7T4vbu6VzzaZM88M
tfv2Td8DZd8pY55aervYTym9VY79bukdSi9Z+rmhdv/ppeu94uv1XjG/7/ih
9tmXLvv7Q+1zrVj6+96BSi9T+gel9yi9bOk3h9o9Wa7060PtnrP/YKitd/P8
gaF2D32ufwy1uWGc73mXyrlOL71Xxvmxd6+c979D7R6uZD57Pyu9QukzSn87
9h96hyu9fOm3h9pzof891O4n/8+H2r/t9qp59clQexbeCb0fsh9e9rNLH156
1bIPDbd7uJo1WPYjo8cMt3u4eumvDLd7vkbpcYbbc3HsheX/ndLrlD6n9NHx
n2y4fUb2rw+3+7lW6fPL58ToiYfbvV279AVlPzl6/OF2r9YsfW7Zj815pxxu
n33d0heV/bvRcw23z7Jx6YWHm/9mpacfbvd2/dLfGG73cIPSl9axP4y+pPQP
4nNx6e+VXq/0NMPt/tOzDLf36g1LX1Y+Z0RfUfonOe+8w+2+beK7q+zH5/p/
Wvrc2C8vfVbpjUrPXv6HRi8w3O7bpqX/Vj5fd02+i+r3+bHvUT4/Lb1H6W8O
t3u4he/A8rk0eunhdg+3LP2Lsl8effWoduxWpa8qfXHpzUuvO9w+y/allxtu
z5HPteXzy9Lblf5l6Z+X3qb06sPtXm1b+ldlvzp6reF2P/lf4x219NalVxxu
z4i+ruzX5VwbDLf7sEPpm7wnl9619GLD7b65tl979yu9Y+kbvFuW3qn0lsPt
nuxcerPhdm/ZNx5uz4L/9eX/64z/G+/S8d+mfC4svUvpnYbbfdut9M3ez6N/
Nqr5mD+7Drd7uHvp7YfbfXOdN5bPrRnnFu/b8VlluM0f9+q3Zb8nz+s3ZX+m
9PGlbyv776zN0gcMt3u4d+nbvatHHzTc7v8+pQ8dbvdt39L7Dbdn4dh7yv+J
0geUvqP0H+J/4nD7vOxHD7d7+K3Sd5XPo9HHDbf7ub+/EWV/LPqI4Xbf9iv9
f2V/OOc9Zbh93m+XvrfsT0WfO9w+y2HWxXDzP9L353C7nwf5vhpu9+fg0r+r
Y5+Pvr/0s/G5b1S7Pwf63h5u84E+Y7jdw0N8r5bPC9EPln45571guN23w0vf
WfY/5/r/4D089t+XfrH0oaXPLv/7oi8ebvftiNK3jmr2PUv/0ft27HsPt/nM
ftVwu4dHl/5T+bwdffVwu4fHlP5z2d+NfqT0f0ofW/rh0v8qfZTnNdw+y0nW
0XB7jnweL59PSp9Y+i+lP8ycuXm43asTSj9W9o+ibx1u95P/o2V/v/Rx5v9w
e0b0E2X/LOe6a7jdh5NLP1v2r9TPab6jhtt9c21PlW2c+jml9NPevX2/u+fD
7Z6c6jkOt3vLfu9wexb8nyzfLzL+M94hRzX/h8rnjbJ/1+cabvfte6Wfq//+
1VFNPzSq+Zg/Twy3e/h993O43TfX+dfy6Ue1cZ6v3xOMaj7+TScmPVf9XXt6
uN1z359b9K1uwb95/l4+k/jeL/3icLuHP6LLNtmopl8Zbvf/x6VfG2737Qzf
ycPtWTj2Ne+9vvdLv1S/pxjV/N8bbp+X/a3hdg/PKv2P+j1d9LvD7X6eXfrV
+j1D9BvD7b6dWfrlsk01qp33w+H2ec/xXVT/np5opOlRo9tnuaj0yOjmf2np
T4bb/Tyv9GfD7f6cbw7XcZOONL1n/Z5kpPnsXr8nrp9zS3803OYD/cVw+xt0
Qel9679PNtL0AfV7ipF23uHR7b5d7L7V72lGtes/sP77lCPN/q36PXn9XFh6
nPKfaFTTY0a3+3ZJ6RdGNfvppQ8u36lGmn3q0S0X5t//449u9/Dy0kfWf592
pOmvjW738IrSr9fvBaLFkeTfJqz5cHj5TlM/l43T4kXybxN3raZJPGpccZK+
1R2JoUwyusWq5PLEpuTuJupa3IkuUzfZ6Jbj4z9xcn/iMuJaV2bMWVIn5Z9n
k49ueUBxn3lTGyUEP97odt9c2+yppRL2XLFvNUtiNOJaco+Tln2K0S2HyC5+
xX8SsaO+1VMZf67UYZVrN+XolqMUf5lqdMtjites3Lc6JfrQ8p96pM0f8Rb5
xsm7FitznZOJBfWtbso4C6RWyy17drh953h2q/StDsrz2qhv9UviHav2rZ5K
jEZcS+5xysS+6K+UnnZ0y0WK3YinyWdOVfZpRrccqGOXSy3Y+GJWfau/4i+2
xj5NYm7ynFMn3kV/VbxxdMuTiiut0bc6Lnq60S0fKub1zdSOjVf+M4xuOVMx
ozX7VsdFz5E8qTjR+n2rHxMb+sbolnv1b7mZRrf6NHHDmUe3OK9atbX6VgPG
R1xRbnaCxOvoacWgkrcVV1qnb7Ve9Lp9qwFz3jlHtzigXO3qfatPc/1ifXKt
MyYeeF/m/3LRMyT2+EDm88Kpy5Mmnzc5X59FHI99irJv0LdaNTEvsTv555kS
0/tj5t7CyfmKVYkZyhXPXPYFkv91rBjdo5lXG/at5o2/GCD7rIkxyi3Pkhjj
nzP3vpkctBjZxn2reaMXS07cHBOHfDhrZOnkqcXdNulbLRy9SmoDxMLEPx/M
98ByyV+LqYmFqh2YPbHQJzJXN+1bfSAfMcbHcn/EIenZrNnkuMXLNutbPRi9
ed/q05xXDFOOdM7Ee13DN7oWn3wm81b886nMf3FReg46uXJ/y8QNns2cXyu5
V7G5V5MP9e9k8cnnM6/WTd5WTG2rvtX+0RskVy5uuEXy7GJw4m+OnbuO3b5v
NX7sW/athtC5tulb3aBjt+1b3aDY3yajWyxV7l4sVK5+/sRU5fDnSxz1lczV
9Ua3OKyaRnFO+fwFyr5T32oCxfjEReXYFy77Dn2rSxTfFFN9PXNyu9QDiJ2J
PbIvWPaTkpcXLxM7fTvzbevUEhhHrPXVPIsd+1Z/aBzx239lTu6SGgOxxY1T
n+Dz7ty3+j12sdw3Mv/FeOmFjJnaA5/lW32rOXQ9YssvZm3unloC8ce9UmMg
brhr3+onabFZdQqLlf++yeOL1e7Rt9pL8Ucx23czJ8Vp1Sx8s2uxYvZFS+/W
tzpMx+7etzpMMU0xYfUOS3Qt3vth5qr4sJqIxUsfmBoJ5xJb/k/Wi1iuc3kH
E8v9Is/62NRg+KMo9qvmYkl/l1NTIQa6V9/qPGlx7E8y98Sx1VCYP7v0rabU
/dmzbzWo4raHpE6DPmJ0i0erZd23b/Wcznvc6BabVgciVm8OLJLYsvGXLb1P
3+pLxU+PSn0ILXbtsyxTPvunVsS9EiNVf7Fc2a9JrYXYojizOo6V+PetHlUs
Vbxa7YY5eVrqN8RSxaLZly/7d1I3wv+sUS0+sMo4LSbsXNaFWLeakRW6Fq9W
G2Jd/Cj1JGK1B/at3pX+QepGxHnFxh1rTh7QtzpY1yBG7Zrdk4P6VvsqVn5h
akvEas9MLQr7T1KvIuYlNq72ZJWuxcZp8/PgvtXN8lFjoJ7F3BMbp1cufV5q
XcRtD+lbfSx9aN/qZp1XHF4dympdi+f7vCt2LW7Pbq6Kvat5MT/F5OlVS1+S
ehgxZTFz9S+e47f7VhvsnojJq3lZvWvxc3U65ueVqYcRFz6ib7W+9M9TzyPG
en3qasSLxdsdu4Y537e6a/bD+1YzLJZ9VN9qgx17dN9qgM2ZX45ucXy1OmL1
6nHW6VrM3zWv3bW4/fSZqz8b3XIDaqHF4dXmrFv2E/pWjyoGLSavTmSDsh/X
t7pisXIx/5ky325ObY/4shwE+3pdy024J743Lk8tkOv/TeqFjCMXMGPm//F9
q3c1jhzNbHlGd6TeSRz8sL7VbHsWJ/atJpldfmGWzGc5CHr90remvshnkbd6
P38H5RfU4GzYtbjrHFlr4v9zZV7dm1od8e6T+1YvTcsdqEvauHx+l1ojcXx5
CsduVPZT+1YXLW4uTzFP5vZDqWVifzA1TuLv3+lb3TUtX6C+adOu5S8WyLyV
41ADtUnpU/pWs+288hRqoDbrWg5iocxDOYgl8tyfT52S+Lj4vBqozcv+l9RQ
iTWf1re6a1r8f5HMw+/2rQ5cXuHPqb+iHxvd8iJq1J9IbZW4/NOpxRLT/0Hf
6qJpeZn5sqaeGd3yKOq15FBc51Zl/37f6sCNI1+jxmprf3/7VrsubyFfs1Tm
9kepuRJP/3vqssT9f9S3mnNaHkRt17Zdy60sl/n5477VosuRyI8sk/kvr6HO
a4fSL49u9YR8zuxbfbscwBl9q133jiQvo0Zs+67lVlbKevlnasn4y+OskDkp
d0Nv17V8yiqZh/9KvZk8h5zLWnnWckaubZuu5YxWyxw7u2+18XIP8kdq3HYq
+zupVWOXl+G/Y9nP6lvdvvHlfdbIHP5PauHkGD5IvZycxDl9q4enf9i3en7z
R05HXdsuXcsZuc6dS/+kb/X5xpGHWidz+Ny+1dh7RvIa62WuyomoR/t21/I4
6tp261p+Z4PMzy9S5yYn4R+78kYYAfmdzTM3zutbzb8cxldSLydX8Wlq8NjH
HdNq5+RmhlN3J0dyUd+4AHr0mJaLUo93Yd/YAf7yUM4lD3J+39gB13NJ3xgB
55o4NXjyH5f3reafHj91ffJJ8lBq9PbpWh5q68zJS/vGF/C5K7V55rn8lFq8
b3Ut77ll5oD8FL136a+nVlAeRa5Kvd5+XcuXbZ85KS+2SdbXZKkPlI+R81In
uG/ZL+sbm2Acea5tMz/l4xy7Z+kr+sZcOFbOa8esEfmpnTPHpkkNobzLlX3j
I2h5rl0zP2dJLaK8jnyWY/cv+0/7xlbID8md8T+g7NOnflLuR+5s98y3b6S+
Ue7n533jJox5Vd/YCvaf9Y3FcKw8156Zt3Jn9IFdy3O5996R5MXUOR7UtZzX
Afnsv+gbYyJvJMe3b+bqXKmNlOORa2M/uGu5TvN819JTppbS55o99ZbGkWvb
Oz5X941BMM4CYQrkmX7VN3aDlr9zPYeV/4JjWp4PdzBvWAM5qrnHtFwg5uWX
fWMr2JftG+MmvrRoajjlosRixGTU1cjHHZJ5tURqO707Xt833oSW71ObeWT9
56VSkyln5j3TsUeU/Td940rkouQED8ucXyF1oezLps5TruuGvnErtNyfWtGj
u5YrPCrzWT5RPelRpX/dN+bFeeX11JMe07V83zFZL/KA6kOPL71+6kXlpeTU
1HseW/bVUo8qV3RT37gVWp7xuMzJG/vG0cgFrpxaVlr+Ue3qcV3LP56QuSpf
eVK+09ZJjatcmhzoEVlrt/SNyWK/uW/sjDzcmqlHpeVD1aueUP739Y1zka+S
uzwl83af1Meyb5QaV3myW/vG7NBykWpFT+paHvO0zM/b+sbyyDPJUZ6aOS8v
qWb21NKbpkZ0bC5qTMt9qrOV91Rj+52u5TRPz5zcOrW4cnj/1zeeiN4iNaty
fpuNablSvI/cpXPJI++Q2l15RHnMc/Ks5Wdd24ldy8+emTl2d9/YIvk/+VO1
w6d5b0/dL7s8Kf/vlv2uvnFPxpdjPTtzeLfUA8v57Zk6ZLnAe/vGE9G/7RsP
Zf7IpaoR/n7XcrKu83ul7+kb32QcuePzMofv6Bsn5bPLCarz/UHX8o835tj7
+8Y9yRfKdV6R5y7Hqkb4dO/SqROWO/xd3xgo+lupW3asfO5FmdvyueqUf1j6
4NQby1PKz16WdXFY6pnlJn/fN8aKlud1DT8unwf6xmE5Vl74ksx5MVv1p7eW
PjI1z3LD8rbqoM8o+zGpkZb3erBvTBafP/SNyWKXC74q8/P41FHLTcqBXpnn
/se+sVfsJ4xpOWPc2Umpl5b7lGtW+/yTruWjr8n8lL/2eX9U+jupi5YTPXVM
yzerkX64b5yXcf7UNzaNjzzyBflukXdWQ32Od9TUWsunyhdfnzn2w9Ray30+
2je+jJaDVj9+Xvmckdpy+VT5ZceeW/bH+8aOybnKR9+Q+Xxu6sDZz04tupzr
Y31j0Gi5abXhF3QtN31z5qd8tzl2vvf8vnFtzivvrGb8wq7lo3+bOSkHrQb8
Eu8MfWPlfEa5dTXLF5X94tScy60+2TcGh5YHvy1z9Ym+ccRyvRekdp2WH1f/
fnHXcuJ3ZH6qSbgzz+inqZOX65XfvzbfRU/3jYNjf6pv3Jbc8GWpqablytVo
X9q1egPz6syu5V7vznx+pm8snnzw1anrlq/9a9+4PFpuXQ375V3Lrd+fcZ7t
G68nVy2Hfm/muRy3uviflf5Vat353Dim5eDV0sutq6O/smu5+AczV3+Tenv5
47/1jemjr08tvZz0tWNaXh+HKLf+UObhb1OfL18uX/+XPOtX+sYAygfL3f8p
c+zFvvF9crTy+Or3f17221Pbzy73zf+qsv+9bxyi8eX6H8kcvjO193LY94QF
kLd+uW8sHv1833hG16/GQP3+1V2rE3Cdvyj9Ut/YQ+OoDXg8c1gO3b29zHdj
eAGf5cUxLdeOKfhH39hG+Wl5f3Xxv+xazcDTmat/TO2umgB1AjiDX5X992EK
HCuP/7fMmVf7xkjyVyfAfl3X6g1wCdd2rZbguayRR8MvyJ2/3jcGk/5TavXl
2tUt/DVz/vEwDnL2/+wby0m/1Tf+US5c3cKTWZtPhYOQa1ergLH4dddqFV7K
/Hyjb5wmH3UUf899U6tAX1/6r+Em5Nff7BvLSatPwEzc2LW6i1czP9VmuIZr
zIFwHHL2z4f1cJ3Pjmm1EXjVt/vGcvK5KiyJ9SUXj424ybtc31gMeWs1DPiJ
m7tWC/Fm5tvr4Snk6f/dN1aUVhfxVubqu33jTOX4/x1eQ55eHQWfW7pWt/Dv
zDd1Ee9kvr0dBkRNwHt941Jp9RX8/S37T9/YVbUFb4b1oN/vG5fqXGok8CK3
lf9/+8aZqgNQF/Fp5swHfWNX5TXVXXyQ+fnf8CbqANRmsN9e9vfDpPBX5/Ne
7v+HfWNX+avZwIXc0bUaD7zI/3WtDuTjzE91Iz7vb0t/HpZELcIn4VNcp3qP
/2YtfNQ3npfPP8LRuLfqPXyWO7tW1/HPfL+p0/g882qob3yKmoNP+sbk0mo/
JLjvrl9j+sbjqGNQ1+HYu8o+Qd9qQTAy6kD4m9tf9I3DVQPxed9YXXNGHQiG
5r6u1YHQ5u34fWNt+Pd9qzXBEX/aNxbYedV74Gzu71odCG1Oqv3AQv2+9Md9
44vVaqhpwf38ruyT9o3TUdMwbnhVWv0JH3N4nHDQaiwm6hvvQ6tLwX490LVa
FNr8VFvivJ7R1H1jxNRYjNM3Dsg1DIUdZh8VVldNxhR945JoNX7ewR7sGgd8
SeoZpusb56X2Ql0EducP5TNj37ghdRKjwzLTalpwP3/sWk0LbU6OCeOsRkTt
inHMebUlWKI/lZ65b3wQn5FwzWoy+jDRajvUt2CMHu5aPQxt3s7ZN0aJv5oZ
rJK5rZaGfqhrNS3OZR7O0zdeSZ3Kon1jiNRtHDXS6lpwRmpmsE3m2HhhotVG
qJ/BGz1S9vn7xkOxqznh/2ffUWG3ja/GZtrM4YX6xkypHZlgpNX9Oq8aHjzT
Y+UzW9/4KZ9Xvc2MmasL961GB2/+1fDaxlm8byyVGiB1FOok5KmX6FsNEMZK
Dxx2nNFxI63mBn+kJmfWzKsTRlpdDg5Lvc1smc/qZGbP3FDPM0vm8+kjrVYD
Y3XSSKvL4af+Z+48IzU5c2Y+nDbSanHwWept5spz+f5Iq7NxjDqiOTLHThlp
9Tr+v7qUeTJPfjTSamiwV+pM1NDImx8z0uqHXJ86nPnyjDBb6nBe6FrvILU4
L5Zeqm81OuquzxhpdTyOUdszb56jWAd/dQv6Bam/ealrvYbUu7zStdoYWu2B
mqWZ8/2gB5FamX90rU+R63y5a7U9xlHzoI6FjzqBU0daPZP7pQeR2pfXupZf
loeWa1O7oh5Crl8NhlqKGbrWX0gtC75J3yE1Kxgu9Ri03L3eR47FQ6lX4a+W
QJ8fdSq4MD2O1K9gstSHqAWRr58ldSO4M3Ug9HRd63fkGjBf6lIcqwZATYsx
1Q8MK+gY3b5D9FNSF4L/0nNJzQG+TE8k9Rw4LHUsfOTi1Wawz9S1Gh71HDN3
ra+R+gycl5oQ43yja/UY7LN0rQ+Seg48l7oLWp5d7YQ6CflofZPUWOCz9HTy
eXFq6iXYZ+9avYS6B7kevZgci+3Si4kdI6bWyPNST6Ivk7oKXJieS2oBsV3q
HNQxyCOvnxoDrJa6BXqervVWUpeA89IPSr0Cbku/JsfiMuT31R/Isapz4C+v
rf8SO1ZLHyc1B1gn9QO0PK8+TuoAcF7qGWi5Vz2gzDE8l/oK55Xj1rtJfhov
Jt9Ny8nq1yR3/pXUYPiM8uz6DqkJwGfpgyRPPyY5fVo+VK6fj5ysWgJ1APKw
el7R2DH9neT++9QS0PKq8vLOKx96ZHLrOC91le652gB5c/alupaXV3Mgb6jf
FI0R01dKHv2rycvT8rD6R8nBj5+6CFp+U95cfn25rvWDkiPHQ8lZ03KXekbJ
hWO+5HPpFbrWT0meGPMlD06v2LWeVHLz2C45blreUH8qOWl8lpw1vXLXelXJ
bWO+5KZpeUB9q+SYMV/y1LS8mP5XctX4L7lOerWu9csay32N0/pZjc0Tj9Ny
oHK08k3yy+xydnLEcrtrdq0nlRwwtkse2Tjyg3LH7PKDeljJGWO75J1p+TU5
X7lheTE9r+R3cVt6YTnvWJ6rb3Y5Nblj+Vd5Ln20HIvt0keLHRd2VfLO+DI9
suRicV7ycXJ1ciL6ZcmnYmHkXmk5L/2v5F/xWXKgtByWHlnyo/gvuVRa7kyP
L/lU7JWcLC0npQeXvCm2S36TlpPSj0t+FLskH0rLQz2eXCceSo6S3qJrPbjk
L/Ffcp20PIueafKX+C+5M1quSl5SPk8eR07TZ5f70+vJZ8dn6QclR4jtkmek
t+taXy/HYsf045J3xILJS9JyPXp8yV9isvT4kv/DZMkV0jt2La8nb7dz13p/
yR3izvT+Ysd/yRUaZ4eu5fX4yN3o52ZNYfr0/pILxHbpFSbnge3Sv0s+D7sk
X0bv1rUeX/J3uC35NXr3ruXg5JnkWeTyjCMnop+YnBbeSn8tPrgw+TW5K7F0
uTP5MDkLvcXk2HBe8lm0vIM+Y/yxXXJ28nlyeXqU0XgxuS3nkmvQ30zuDRcm
7yMnJDYuFyMHI9YttyV3JUcgxyRfJf6vh5i8Jp5LvzJ23JY+ZvxxW/Jcxpen
kKviL1+gF5m8FJ5LjzL5JByW3BAtbq+Xms+LTZsnuR7Ml75nrhPDJRdmHDkC
OSA+h3StB5rrx3/pb4bjwnPJz3qO8mJyPXI5Yuz6lcn34LPkXGgxcz3N5GOw
XfqwydlgtfRJc6w8mpwOHzF8+aCxTFfX+p7JzeCz5FbG5m+61ktNbgbrJD/C
5/iu5WXYxbTlSuRdjutaHzbH4rn0W2PHgr3Wt95WYi96qcmjYMf0TJMPwEld
17fPLu+g95ccCT5r8+QmMFzi9vTJXcuV8BGjlluRkzixa33naOyYHmvyIlgw
uQ9a/FmewnnFh/Vqk6vAeckpuDZxfrkDdvFeeQo5GDFPPd9ojJjebvINm+T6
9YKTv5OnYJdHkCeSnxD71YdN/gADJV9Ai83q1SY3gPMS26fFYMX/xcrFYOUj
5CrEhPWFE1vHZOklyAcLJmYuDn9W1+L54v5ioXrEib1il8TtabHTExO3x3nJ
BcgxiMfqNUfjxcTenUtcVJ86MXecl3iymLWYmDiwOPXY+FvfYuhim+Lb4uzi
k3rBiX3jufSdY8dz6UfHH88lvm18cVSxdP5ip3rKiafjvPSaE/vGaol10+KK
euL5vHg0ferEtTFf+te5TjyXeL5xxDPFq/lc3LWaevXz/u2gr53PgvkSAxRP
u6FrsWgx0Mu61ndOPBqrJf5Mi/tdl5gwzks/PfFl3JZ+d47FGYnHireKfYnH
8r+ia/3r2LFa+uCJ+WKdxIdpsTh98MSIcV7itLT4mx564t14LvFq5x0bMxzT
4rx4MfFnWvxNvzuxSJyU2LsYvVir/l3itvgsfdjEZw/K+qXFpsRj+YibifeK
S4qJ6VNKY8f0xxOfxYKJwdLiYOKizitOpc+e+CnOS29A14CnEwtlF3cSjxXz
FbvTr4/GiD2XOCf+SzzcZ/9Z1/rviZ9iu8QNxET8O1cPPfFNDJQYJi1GpM+e
GCXOS4yRFgsShxSzEwsS2xQzFZvS00+MD5Olxx0fLJh4ozigOIkYo1ikmIz+
fuKJOC8xQ1oMR68//jgvMUyxTnFOfQJpvJgYoHOJyegxKPaH8xLXEjvz72Lx
KPEysQWxPrG8u7oWZxPvEyfRx0/8Dc81HDuea9z447nE2Yx/Z9fie/zv6Vo/
QDE+nJc+gWJwWC0xN1rsQj9DnxePpseg+BrmS+9B14nn+iLjiL2Im/F5oGs9
Fd1bXJiehD4L5kvs2nMUSxQTEy8Tx9AzUFwMqyUORouH6CsoPoXz0gtRbAu3
pVehYzEsYkRiPo92LQ7GX8xE70F2rJYehmJPWCdxKlrsQg9DsSqcl3gRLR6i
/6E5hucSZ3NesRp9C8Wh8GJiSbR4FMYIKyRe4d/yYoViQcv0jUsap2uMEX6p
/oyMZZhoMRZ9CP8ZPeFIi7f8vWvMO42NWq5vvNLXu1ZT8mb8r8l5xUxwSzgj
cR59HV0Dnu5XsYvDYJ8wUC/lemhxG0wS5kh8Bluh5l4c4LrYxWfUcKt19+9c
LBHGx7/lb4oWM8GgYILEXm6JFm/BumB2xFuwRhix10qv3Tfu5mtd44r4iLfo
hYi3EUvB8OB6xFswQ5gd8ZO7osUicDv8sTkYIdyQWM1vo6eKz8cZE7uD2Zk2
9wTw9W7uJyZLvEV/RczOO7nnn0Wv1zeeaPquMTqf5R5OHH/P6N6M71xj+9Pk
WAzaF/F3LH5nhq4xPOPkGm7L5xUXwqDhf8yrB3Kd9OwZh/888XHN1+feim0+
mM8ycZ4F9koMR79HLI04Eh4Is+a5/yr6PzkWHyRehEfr4zNFjjUmDg2PJr70
UPwd++fYJ8v4eJ+Zusb8fCW1T7g2/I+/y4tGGwcPNBL7Qjnve7HjicS1Honm
j0OaOHMVszSU+8COa5s814MtEu/6S/QHmYdfi9Ync4LoqaNdP5ZtwoyzVLS4
1uM5L42DwxdNkWfkGmbsWv/MSXLPrZGJ4v9YNP8n8lymzP30rvJqfHBJ4m9Y
F8yLLxFcEXZsqqwp+qOMg5OavWvM0pSx69WJTRJn02d18thxS/gjsaDp4zNV
1hpuTiwOszRNjsXW4Z3MydWi+Twb/2my7qaO/zPR/J/Lufhj7maIPwYJxyS+
h8nB5nyedY25E8fDO30jGmeHj5o252UXT3s+/uxrZnz+68Tf+Fv3jcsTj8UD
Yp2s302jnfepfF4xTHzPbFmbz+c65866njlj3h8fx06Xe+s5bte3zzJv11iy
yTIHrHHs4RcZH7clJvmPaHb83dyZP9imebIGX8mx7BgnzJS45ebxNzdejV0M
HN83X47dKpo/vmr+rMeHotlfyRybP+tonoyJ11sw/ttGi4vi9RbPmtLrdY5c
v/ExU+KoGMBFsmZ3iBZ3fTM+xvGdsFD0G9H88VuLZvxHoh27c87rbxAeaIms
/XlzDTNkjS8RH3zXYjn2jeiFMr6/ZeLDu+XvnZgq1mqprDssifp+sTsc19Lx
wQwuE589o8VyPetlo3F/K2UuvZ1jxYS/FbuY7eM51+C8uDAxXszECjn26Wjx
YcwWjklM+L34O9cHsQ98ls33AA5s5axxvXCxXmLROK01M5/xYKvkevTOxY+J
/WLCVsv6Wit24+B4tst9048X9yW2/H7GWTzfGytnzOcyjjH/lvN+JePjyMSc
9fJdPtf/aex8sGGr59gPo8W3181ncW2er+sRN14l4/jse/eNc5QvwP2tl/V4
fLSYNj5s/azB/frGuy3dtT7AGDYxNyzZuvmMWK5Ns74+iV2M3QvdBhnTWsZd
jp/xMYxi5rjBjWPHbG6Y826dc82f78D1M47v/E1zDdivrTNvrR16bP+00Y0x
cz1YtC2y7nw/0GLvp8SH1rt429wr373r5HPh1jbLucaNFs/3efFuy2V8PNry
XeOvtsk1bJA5YC7tkvEH7ORWuZ4xGcc1fDf2r+dcG+Wz+4w4OLkAnBVWS7wa
l7Z75ry+ytg5uQDvojtGm5MYtxW7xsPtmLW2e/zNVf35xVj0hxkv53IfMJs7
xx/zho+TU8Bp7pb1eHa0nAIGbpfYz8ix/MfPNbiesXxm/HFxe0Tj23Bt8g4T
xC5nwb5X1o7Pi92Ts5g4etKs8b2i9Y7eM3r/aPcH47lPxrkgWl5j0pyXxl1+
K+voq/m8K3WtdzS7fIfvhH3jj9XbN/7Ysv2zZqfIM1oj34275D7wx52t1rW1
PHYfkHHasQflu3TKaHZ9tg/Osz6mbzzmWhn/wKwvrB27fIp+19/OsUf2jf2U
w8KrHpb1+6to/ji8w7MGreVDcq4udj5H5RqcC3d8ZPzxcrg5+RTs5/FZC9Yy
FljuBit4dDQO9JisnWlil+uZPPfEvT081+8eTp9x+F+d8xrnuozjvDfkvHJA
OL8TsgZ9N+6fMcfEPm3W8rE5dsbo5XIun0WO6Zh8/4wfHyyhfNPM0caxxrGW
0+W8mD75plmj2bGr38maxQ6emjU4S45lx9Xga+Sbfht/OazZYpdHw6ielmNv
j+aPEfxe5uf40ezGxyfKeY2X8xoT3/qD+N8ZLZ+Fhz0zawpb+pOsQePjDeWD
MK0/ynq8J1rOa+74GMf3w+nRc0Xzxxr+OONPGO3Y+3NeOTIc3lk57+y5ftc8
cex8sIVn5Ni5ojfK+LhFeTf920/K/Z8/dsdiPH+e5+tcmEf5uAWj5eMwoedl
bf4xWj7O/Dw/2nfFOfHHzF6SNb5QfKxfvCKGUc7uT3lHovGLF8V/ymj2heIv
34djvCDnWiBafvDRnEu+73t9423lUvV7x1XOEf9zcv14xcvirxc9tlFOENd4
RdbdNbH7Plkk/pvn78ulOXba+Dv29L5xlFt2jXf8We7nDNGu4feZPzPnXBhP
+cfrc53Oi738acZcOj6OfS7PSD7Rd8svonF79+Q+YHuvyXp8IVqOEkP5y6xB
bCJGUk5T/3yso7wk9vLqjImJvCHra6nY5UOXz7HGtJZxx3NnfD0o5IJXjGbH
816b896Rc62f74pfZpzZcy7XgH38bebt3NHyoTi7G3M9+Mubsu7mjJY/fT0+
9A8yz33X4SZvz/zHdv4m51oheruufV4s5/YZH4+5Q9eYzFtzDSvk87p+HPFt
uU7c8S25nlUzjmt4M3bHvpT74J68nWPnz5q9PdreBzhP+VyM5p1Zg/NHs2M7
74rGq92fdfFgjvUZ8Zx3ZMw14r9T11jmu/9nXY/lnXMuTO7OWV/GlBdeN3Y+
7+dY2l4J98Xnz9Hmnv2J5LM2zZzEcu7SNTYUy7lb1/ZBwJTKNfse+H20z4Ib
3TX+v89aWybz3HxeLZ9rx65x0A/ks6+fc7meDTOOMTfOeeWvMc4PZ21a+3+M
3Z4O7PLU9mv4Q+xPRLuGC/rmr34AW/mnrNlvRjv24r4xqnt0jd1+JD72g6Dl
rDGpj2YdLR3NbkwMrHz6FtHs+OjH4m+/CVoeGUv6eNbvstGLZ3zsqlz5VtHs
mOgn42+vClrOHc/6VNbs8tFLZHyMqhz9NtHs9q3AwcrLY1UxkvLv2NO/Zh0Z
E1crj79dNH89ap7JuXDWz8Xf/hf0khnz+axBY+Je1QzsEM3H+sJEy/Xjr1+I
/46x75A1/nz87YvxQvxXzHW6np1y/ez4VHyrnL49NbCy8v4415cz31aPZncu
zKx6gF2i2XHZ/4i/PURotQS42FezBteMXibj42TVJOwWzY7pfj3+9gShl811
/jPrdO3oZTM+rlY9wx7R7Fj7N+OPnf1X1iPe/KXcq3VjV8OwV+4DjcV+O/72
InkzdvuPsKtbwMK+kzW7fjQ7VvbdaDz4v+PDH3urNsMeJewrZM3+J3rPHKsW
Yt/YfW/gcLGU7OtFy+Pbtwvfq6bimr4x4GpUrP0PYjcO3lY9xv7R7Ljy/2bN
LhSt1gKz+1HW46bR7Nf2jfM9tGt878exY9g/if/80eo09Nz9NOtxi+iVMz6e
V13KwdHs2PPP479ItNoMa/mLaDw4NtW6MD7mV10ErhwPbM0uHq0O5JAcy47r
xYzvk3U97v/44ILVkODih+KzZLS6Eazv6Ghc7HCu4bDY1ZkcnnGMuV18+O+X
5+75LpPrV3+CB8fiHpA13sdufNyxWpSjo9lx2Rhj3znLR6snwRDj0K3HnaLZ
scj4X3Usx0azY97Hj/9K0epYMMT49/2zrieI3fhj98HpGm/8tdhx7l+P/6rR
alqwxRPmcxkTI3xs166nz/WfGDv/NXIf1NhgkbHw3853woTx2SP2tTM+Tvm4
rjHJk8Zunx08s/oZzPHkWS/jZo1YR3vFzgcfO0X0LDnWeU+K/fiuMeTmmLmH
68XUW7/4WJzstjkXlvmErjHMU2dtYu2nif+G0ep2MM3Yeetxv+j1Mj5+Wa3O
96LZ8fLTx3+TaDU/t/eNlz8k63qG2I2PXz4p1zlj7Dh9TLT1u220+h88NGb/
sKzrmWLHQs8cjT+eO/Mcjz9L/PHQs2YNHhyt/ufOvh17StfGx0qrLzojmg9m
f/Yci3ueI2vw0Gi1T/Y/wlGrQXIurLRao6Vi5799xuF/VnzorXKdznV4rt84
mOPFMyfxz/PEjvGfN59x12j1S5jp+bIej4zeJPcEfz2We41m1zdggfjvEe2d
EGO9YNbj0dGbZnxcvJqo86PZ8fsLx3/vaPE3jO8iWY/HRm+W8bHV6qn0Clgs
PmfmM6rp2i92dVbH5z5snjHx2mqoLsw4xrw4dj54/2/mvh0QrS7LWl4y2r3F
bqvdwjEvk3V0aex87EuFzVaXdUmOtZbXiZ3G+OJ21VDtk3VnTeG9l82x+iQs
N1in0eqysODLZz1+J5rd9eC+x3K70ex6EawY/yOi1UrhuVfKevxu9NYZHyeu
Huxn0ez6D6wS/6Oj1ZXhelfNevxe9DYZHz+uDu3n0ez21Vo93y24cOy2GrOH
+vadc3LXxsSSq1W7Opr/FjnWufQ3WCtr8LvR22XMtbMe/9w3xvzsrjHk68TH
OtV/QD2bXgfrxv/a2K3BH2Yc/qfEh//Jee6e0XW5fnZsNzZc3Zp9vvDSatsw
5Rtmfp4Vze5c+HQ1b7+OZtcDYeP4nx49tl/6uK2nwWlZ15vEbnwMu7q730Sz
65+wWfx/HL1TrnPzrMdzo3fK+Hh2NXs3RbPra7Fl/LHsW2UN7pzPeGrWNbs6
vVtyH2j9ELaJ/1kZh/2c2NXmWQvb/s/a3DZ2jPp20fotbB+fS7JG1EmeH/uu
Wcs7RN+cY9X73Ra7NXt71h0ffRh2iv2iaHWD1vLO0Y7Fs6sz/L9odr0ads01
YOV3y7q7I8eyY26xt2rbLo2/2sI7Y7+ka70a9sixV0Tzx8fvmTX402h24+Px
L+7ad8VuGVNvh70HazZazaGeDAdkHem3cFDWgvGx9pd2rc/Dflmnv4hW33hf
fIzje2Cf6Huj+WPxv5Xxfx7t2F/mvOohn+tbPwe1qXfl+l2zdf3t+ODz98+x
90ZflvFx95d3be85XLo6w9/H7tgLYvesX+gbv//TrnH7tDpMPSIOzffMDdH7
Zv0eFu374eD46wtxdNbUQ/GxTsf2Ux9u9Zn24DsiGqN/ZPx/Hc3+UPzVKOL2
D8+5Hoy+smt75zmX2k5M/zFZg/bm00fggPgfnOvH5x8bf3v/6QWgdhTHf3y+
f86O3Th/iv9V+X44JsfeFP/9c159A9SU4v5Pyv28Jdo13JT5s0/OpQ+AWtZz
c53O+1jGMeYT8XHsD3Ov3EMsu34UF+YZ6bGgbhP/f2qer70IsfrqSPW4+G78
9RI4Levx9mg1q4/nWDWuD8Sf3bn0HFCnqjfF9/9nLetZocbVmPoDqGt9Npr9
p7kGa+0POZb9mYxpfJwi1vj+rvUh+FHWtR4DehGom8XgnxH7XfHxuR6JXV2r
74ozo42jL4G62eczDv8XYuejV8bZWb+PRR+aNfuTaP0S9Cu4Ltfzg3yWF2Pn
Yw9HfQrU4v49x1p3v4qdvjXPy3PR5+C8rEf++hio6bXvpD4I6nL/1bdeE1d0
bZ1eGLtj9StQ36vPxsVZp9fn2MuzRvS4UBf6j/g79p+xW0fv9K0Hwm+61uPg
0swf/Tcuy5p6Ido4r2aOsb+U8x4RO75erekb0fz1P9BnQJ3wy/mMh8V+ZdbR
WP5+uNUG/ytajfGf40Pbj/Kn0bdHu379Oq7KOK9Fq0N+O+el9fG4Ouvxd7nn
ruGN2NUe+x74efzfiuav38A1WZuPRR8TH/0W1Dm/Gz3WPqb1ZVB7rO/CtVlH
T0SzG1NvB3XR/4lm17vj+vi/G60eWL+EX2fdPRV9XMbXV0HN8/vR7HqD/Cb+
70WrndaP4caszWeij8/4+jaotf4wml2vj5vjr6fCLVmDGH4svzrqZ2NXg63/
wm+j9Q+5Nf4fZhz2j2NX+62vw23/szZvi12/htuj9RW5Iz4f57xquT+L/aSs
5f+L/m+OVUP+aexje1bk2tSN6z1yV+x6K+ixoDZb/4a7swZfjFbXbRy9IO7s
Wg+Ie2LXe+Te+NublVYTrt/DfVmb5vx9sRtfv4i7uta74f7Y9R75Xfzt60qr
M/+sb71TcBPW7wOxG1+/kbu71j/i97HrZ/Jg1rJ9Wh/M57Ku/xBtU4K7cv0a
2/vs93atP8ZDWb/2daXVnOtF8YfY9ZZ4OOvUGn/4f3z0hbiva31O/hwf+8DS
at31lXg0Wm+JR/KdMCZ23/l9xjGm74FH4n9/1pQ1qG/JX3KsnhOPZQ0aU++I
33WtfwStfl5flCfiY89iWm28NftktO+Kx+KvV8mzWVP6WDyZdYoV13dCjbe9
hp+O1qPimfhby8/EPn78MQX6XDyVc40XrW7fXrfOpa5e/4nnsgbtV6tXhTp8
e93qH6EOXz+L5+Nv71p9K9Tw62nxQua2Hix/yzhfi/+D+X54Lsda4y/kWOfV
4wIXoC/FS1k71vJLuQa9aJ7OfXAuvSDwAvquvJjzTpJxjDlZfByrT8srGVNv
jH9k/dqD+C+553pkvJrPqE/Ia/GZIxoXoE/G61mDxtEr4+Fcs2MfyvfS6/Gf
Kj60Pi1vZd3ZL1jfDWyC3hhvxj5ffLAJ1vib8dFH41/RQznWNUwZOy7G/r/6
Yth3Rl+Nt7M29cl4P+tibA+afEb9gt6Nz/gjrQ/MPVnLNIZiwfjQemq8k2ub
OhpP4Vz6hGAoZojmP5zz4ia+NtJ6cfwl3zlvZxw8xQfxsffxe9HjR/tO0O/l
w1z/3/JOdWnW6X/zebHLeGY1FPZE1m/C/jh6Xnyc9fiVaHY9Xj6J3X7BtH12
9Pz4NOviq9Hsesh8Frt9iml79OgF8vn/rK/PY9cf5ovY7eNM25dHHxA9Hx7M
WqbZ9Y0ZJ3Z7PdP239HjQw8Z60IfmFHR5pU+KvaCsR80u71+zP+haP1S9Bmx
RibKOMa0hzW7fX/0GtFDxrydLJrdntF6kdjfR/8RPWfM83lyXvNtitj52D96
JNej58yYjKmfzEiOnTPX5nr0hxkv42BZMA8YB/1F9JMxr6aJtueO/jDjx26P
aVofHn1J9Hsx96aLZte75muxLxmNqfl6ess8mrn69dj1OdEP5YWu9USZMHa8
jt4oL3at3wmNocHiYD9wH59G40UwPfYl8meNz6Q5FnODA8GA2IN7vHyuL2LH
o+A53Ac8CnYHd4G5+GfGsc8RDoMdt4HRwWlgNDATNHYHV4G1wBbgQrANuAZc
Dm4Bg4B1YMdD4BswD3gFLIJjsRj4HnYchHpnNdDqnfEHenxgCtS/q4PHJWBu
xnIFXWMLaHwArgVLgAvAENBj93ge1ZgfvMxH0RgdfA9mAC+grp/GB+B47NmD
G9JnxZ49avvZZ8k4y0bfk/HxAxgBTAA9dh/oUa0/y2BvbnrA5WBs8DWey+yx
YwXwA2r/1d2r11cv77nP+T9zADtkrx+8ztwZBwPkWNyB3i3sA14Ew4NbGTea
XT27unbcAI5nvvgM5bwzdq2nC/uDmQ/zR4+TY2foGpfDjs3Bo3jueCCsz4Kx
q6lX0692HqODvXkvc4nG8RgHV/CNrvEENIYAr7NI/PWeoQe8DrYHpzNe9MMZ
H1cwU9d4AhoHgBlaPP7609ADdgef80Hm6hKxGx9jMHPX2AIaK4DpWTL++tnQ
j2ZuLxWtX86C+Vxfz2efpWtcjv41OB09bGgszsQ5lh3Pge35b+7nsv/jg52b
tWtMz/Lx0SOHxujg26wRnAhGZ4WsncmypmbrGotgHHzA5PFx7OeZV+aqnjrW
HWZFfb2+LerkrbWVYze+mnj18MtH4wlwOfrvjO29M6rpAQ+E7fkka3O12DEx
eAY8wkrRavxxP2uM/nJ/dnrA5eBwPs2aXTN242MJcASrRuMDsDtrx1//HnrA
3GB4sDbGVPev5t8axO3Yq2iN2LEFuJz1469XEG1/opkyzmBMNevq1deOVguP
49FXCMuDxcG04FnmiMbrzJ7z8qFxBfPmejbJutZnaMP4rxcfdf2ux55JeAQc
z2YZXy28Wnl1/fgbPE+X7xYal+N6MAN4gQ2jcQYYnS3jry8RPWCAMD+4nvmi
X834eAP19ptE4wwwQNvEXw8kesDxYH6wOQtGv57xx+7b1DW2gMYcYHe2j7+e
STTmxtrcIVrPpM3yuRbOZ8cI4Hv0ZsLp6M9EY3QWy7HseB38D65n8eiBD/YA
d4D72TU++jDR+BscAB4AN4DFwfwMZ0z2sX2iMg6mZMn4OFYdonpENdHTZH1Z
O/gb/A8GZ5nodzM+rgBTsHO0Gnlczt7x19uJHjA9GBj8y/LR7MbHIYzd+yka
W4AH2i/++kXRA/4GX4S7WSn6/YyPE8AI7BmNJ8DoHBB/vaPoAWfz7XyfGBNX
gCnAi+gnhRnZJ3asgH5Rvn8GTA/WCL+zasb5MOv04PgYH4eAKfhWtHp2Pav0
zBqwNYflXPpU2SNqqazZw+Kjjl49Pc4AV3RozrtW7Grs8VV75Fkbx/XbZ0p9
vXp99fJq/zEA+AD8jb5XGBz9rugBx6NuXs38htHsuB/sAe7gsGhsgbV/XL4f
+ByfMdeLHrun1VDrpWVMPbToAX+DQcLjbBLN7hrwCdiEI6OxCDihk+OvVxCN
3bE2T4leN58R47BZPjvuACekVxc2R48uGuuzZY5lx/rgdjA7W0UPfHARy3WN
SfpefPT0ojE9epXtkXWBucEgTZgxranlu8Y3GGfsvlrxcSyu6/T46wdGD1gf
LNBEGROHsELX2AIaE4AB+nF89Ayj8S7W4xnRO2QcY+J19A7D6ewaHzwLhgBX
oPZfjzF9xwbsztnx3y2afdf4r9Q1jgHbMGCD6BW71pPMuQasD54Hy6P3mH5k
GBo9w/Qgw81gEfAJ2AJ9y/QyG7BEOB+cDjbo/IyzR/xXzno/N+faJ/4T5by4
iFW6xqbgf7Ak34p2DZies3IfnAs7sWrXeKCLct4zMw6O4SfxwRDgUfQvw5Lg
VC7N+OrfsQrq3/EHmAT8AdZHnzVcj55qY/W4jTHCCGF2MEOYzNVzzY7FAuBs
8DPYmYPj71i91vRiw+Lof6YP2lQZE9uAU7gkGhOAB+KPCeJvvy4MwoU5L6bh
yJzLmJgkjAG+AGej/9o0+V66LM+Oz68yJtbn2lynfm80Luew+EwX/ct8n1ye
8TEK2J3rMv4x0Y7V7815BxzPDbnnB+Ua3M/jY+eDUcAqDLglGrNwXJ4L3gEj
dVXuuT5zniMGCMOB98B0OBdWQV03LkdfOWzONbHjA/Sf04duwOvgf6bP39Ob
MiZOiA+e5Tvx4a/WHnuAUcAJ3Z7xT4ueLWNiEsb2vovGIuCBbsu5Tsk4+AW9
hT9KXFcfONeMAbLG74zGH2AVcAk/jB3vg/W5OxqXgxHC6fwoeq5cp2MxDo7F
FWAKbonGQ2CD7sux2B2M0ExZRzTWR5+/2/IZnQurgFPACT0Qf3347ov/bfHB
IpySe+t+6snHf76szd9HY2j06cOw6M9HD1gcXBA257xodtwA9gBzgFHAKmAa
8DS4HRzNufHBJujhp68f5ubCzJmFMj7eAGtwXzReASf0SOaVvoAPj/6SN3o4
13NJzrVI5iF+ADuAs8EG4ALOzrVhKPA9j+faXCceAAvwh2gMgZ6CfBaLtr8a
RuCBjI9vwAbpOYjl0WuQxv08nPNiCKzTZ/I9cG7us3vr2v6aY627p0Z/yQzR
mKDL42NfNozRs7HrX0gP2B3sEK7HsfgEbMIj0VgEjMXf4qNnIT3ghHBEc2Vt
vhC7MfEJ2ITHorEImJ4X468/Ij1ggzAw+Jdro5fL+PgEbMKT0VgEnM0r8ddP
kR7wOpgl/M6vo9mxBRgDNf4YEYwN/gVX9Fr8cTkYIWzOjdEr5doci00wPj5h
u65xCTSeAGP0Ro7FA2F7cD23RGOG9GvUwxGn4lz4hO27xjC9FX89Gt+I/wvx
wTToB/larue2XL9xsCyYGTyLmn21+1gEzNC7+Yx6PdID1gdHhA/6v+g1ck/w
CTt2jUugsQi4ovfir5ckPeCBMD94n7uj18r4+ISdusYl0FgELNGH8debkB4w
QHghbM590etkfHzCzl3jjT6Oz635jDt0ra8kOzbogdyH9TImPmGXrnEJxsEx
vB07FgE/9Fnum36WNK7I+v082r3FJ+zatd6W+l3aq+7fseMScD/smKCHcizN
3/52WIOfZ31Za3zUW6u1xgbpg4kPwvRggXA9j0TjfjBDOAQMwn+jN419TI7V
R3NU/PWS1FNyy3yH2APPdxcGiB3vg/sZiX4sGhvkGrAKOIVPonEJOKQ+1/Zw
zmtPPdwPXgj782S082JxcDv4GgwNxgZHgx+aIP64H7wQ1uaZaGyQHp8TROMb
MA8DVonGPjgvngGzgGOgB/vcOS82yPhYBZyCnqB9PiNegR1/oIfohGO+5JMm
zPVggybJ9eshSm+f9Thp9Pt5jjgSXNHk+Yz6gNIDBggvtHTW5hSx4xKwClgE
rANmA9/gXrGr/8cSTZVj9RzVexTHgwHCDuGA/hGNE8L0YIFwPc6LYcAvYImm
jb9+pVPFH9PAB8eAvcDb4C9ezzi7Zr3gefbMM3WdmA79TfVFxRtZXzNGuwbM
Bq7hrdgxQTikGXJtGAhcBHYB08Afu4Axmin+jsUbYA0wB/Re+eyOxVNgifRI
xRC9m+uk9UmdKdesfyofXNFgzVgv/87nZccJYYfUUOvJqk/rgAfCDuGA3o/e
N/cKt4BZ0IfV/nz4AhzSHLmHuB8sAY4A08Afx2BN4X/wPRgF3AIuAT+klytW
SD/X+cZ8yQDxx/44l/6w9gHELc2Ta8MoOBcuwffDgvmuwNngfLA2+BusDtYG
Y7RwxsRt4IiwG9YajRnSS3XhaGNin+xL+HG063RtOAeMA4aAxjeMk/NihoyP
YcAvuJ8+L0Zj9thxDPrLLjbmSw5psVwP9uibuX519Orp1c7rWcuOK8KgYFrw
KViipfMZ9amlB5wQpggfNCaaHbuAZ8Ar4CTwEhgI7A7mZ83ct7E+XetNq0ft
MVm/+KKjMj6eAcuwQDR2AWPEH0+kV+5yY77ke5bL9YyfcxkTe4RnwDJYF5gf
HM+oXBuOQ99cfXUxQ9bRqtGuGc9wTNeYIXZMED5plXyWhTM+HmKx+OMb8EOr
x9+xGIZju3bP6RPznblk7jnGSM9fPNGkuU5av97Vc816/fI5KZ9r+dyHyfK8
2LEgGBI8iL65evsOOCH8HpZhyuhT8qzxDMd3jXXYID5YpXUzB6wp/A++Z7n4
4xtmjB3jY3w8wwld4xho7ALGSO9gPJHewBtnHIzRhrHrDey8Aw4Jz3Bi1zgG
GruAIcAVqP3H2WBvsDZ6D+tHbJ9E/AEOAXuEJdJrGEM0Y+wndY1V2jzX7Fj7
LJ7ctT7E/AfMEIZnw3wPbJPvHFzRthlzmly/a/5G7PZ8nDnXeUrW71YZE5+0
XcbEmmBO8Ar6FrNjjCaN/biucUg75jPqi0wPeBpsEm5ormh29f7q/nEMeAjs
BJYC04MFwvXMGR9cgF7IeiWfkzVrzpyd8XEOGIeNozEN2KPdM6/0YN5lzJds
1i65ngVyrnMyD3EOGAfrAv9zQe6ta8N0YNax6/gh62jvaNeMbcA1LBo7Jgi3
tFc+y2YZHyexZfyxDpikfePvWJwDxmGbaBzD7Jk/7jkOSQ9onNESuU5az6F9
c816Qu+f70m122q71WUvle9PbNEJsauv1ita/+gBD4E72jLP/aDYHYtzwDhg
Vg6JDybpwIxpHeGCcD87xR8DsXLs2B/jYx5wDbtG4w+wR3pG44z0jT4842CP
Do1dj2rnHfBJmAe8wx7R+AZsEA4BU4AbwC1cHTvWCDfkenAOGIe9o3EJq8QH
b6QP9FFjvmSbjsr1Y5KOzTh6YNMYo/1yXuyCftj2s8QpLJfrd82YJP2y8UfW
/nFjvuSTjovdsXzsg4lHwatcHB+fBR+BR8G94FmsHUwRVgmThM3AZRwU/ct8
F52aNU5jnOyPuX6OxRxhfTBCeJ914oNX0ld7bH/trFk80rU5FguBIzg0GgOB
SeKPP9KH+7QxX7JQp+VcG+dcxsQqqelXz29dYHtwRfqFn5zPpc+3ft+4Iuvo
x9GuGV+BldgidpwRnulH+SxHZHwsxdHxxy5glc6Mv2NxDhiH46IxDZitk3Mf
MEl6iGOOts510vqLn5lr1hecD2ZoiTy7H2QtnxO7+nR16urZ9RTXW3zA8GGQ
8ETbR7OPZY/GNIYCe3RhfLBN52UOWEe4IEzPKfFXa7977BgZ4+MfsA/fjcY9
YIz0Osci6WV+ScYZyyrFrj+68w4YJvwD9uH70RgIHBI+4ZKusT64gku7Zh/L
I43TrgcLcXHXeAgax7BHfPBM+qZfPuZLFuryXD9u6cqMo883jT06I+fFPWCJ
9EnHFu2U63fN+qaz44Gs95+N+ZJb+ln8cUKYJdwQBgWLckvW9S9y7Nax41Mw
Q9gk3NAB0Rgj42AeLusa90Cru8cnXRd/vd6viT+GAMOAX9HH3Z6gV3SNN2L/
add4Hb3g8TL6stMD7geDhAM6NJr9wMyxy7s2pvPaY9R3wo35fjD+TRnTusAO
4XtwV9fkPuiJri889sg6uiXaeTESV3aNSWLHKGGbbs71HJTx7ZF6WfwxGXim
W+PvWDwDluGn0biHszN/MCgYIz3rcUbH5jpp/exvzTXrYc/H3zg+Y7mIrvEQ
NL5BraJaRrWKWCJM1AF51jQOyd9EvAT2Aat0b3ysFywQBkh//bvijxPCLWAW
8E/s/p7qke9YLJHabTXcGAjsix73+Bd97n+XMY1zX+zfy7kwQVfnerAX1+dc
GAhcET4Bm3Bz9IA3whcdlHGwEDiI30TjHr4fH6ySe44twaBgg3ALmAW9+R8c
8yUj9WCuB/fzUMbHHunRjyfSm5/GG52cz6teHWOETcIZGf/h+NsHwDhYoh/G
TuNm1OKrtz8l98Q9vDXX9nzmBk5JTa7xMRL4iDui8RD2B7A/wYArwirgFM7J
sXile2PHKNgT4C8Zkz+WCSODlXk62n4C9IA9winhic6N/9/z3f5MfPBPT+Rc
9hmwryqWwXp/Mesab4QjwhAZEwuBg8AY/S12PexpjNHv4oOH+FmeHSZIbfJf
cp+dy94G9m/FSz2X63RvsUy4pItzXvvtYqFejv2MPC/PUU/9lzM3XCe+Altx
WcZxPQ/GjrHAVWBLsCMP5TniJDAo9h7Ap1gLGKGx+7YON2YJc+SzYCdwE3+O
xkBcFR+8lP0WXo1WS2aPMbVhGKlXcx/svWA/BnwSVsn+Crgkeyz8a8yX7JFr
ODbr640xX/JMb8Qf//TPXBs7jgJDgWF6J8diF/AS2IIn4vNu1il+CZ+EG8AP
YCNwS/Y5wChdFzum4Ib4s9u34Z0caz8E/gM+CcuES8ItfRA9dp/ZMY3vwRPg
Q/AcWB/cEebohlznrfkeeC9j3hwfx2IUsAqf5LkYB2OCpcBUfJgxMQ94hxej
cRK4JXta4JXG7nGaZ41dwDN8lvWLfcIn4YrsG4HBuT12x96RY3FO9pEwZwbs
URf/u6LZb881YyvuzLlwE/a7+DTj2JvCubBH9qOwj+w9XWOJ7GmBGzI+tuHO
rrFK9rfAJdnjgsYbvREfbATe66PcW/tvfJTP5ftkVP8l5zQq4+CTRudcrsF5
7WPLjoW4u2vP133GrbwbOx7COPiNu7q29kfnet6KHdNwTtYdngurZL8NrJO9
Mmh8EqYB24CNsGbt0Wst45++Fv8Ho+3ba88Ne2/gk/6YY+/tGqskt31/1/gn
Pnglcw/TgkPCTGAncBIYJnt+4Jjs9TFx/yWrxB//Yr1P2H/JQk0Y/49yLvwE
Pmmy+GMgcBG4B3wD5gHTYA1inDBGuAqsBZYCw2RfEPzR47H/rmsc0uSx20tk
shxr/xD+A4YJ74RpwjZNE22/Cxpj9Kd83vu6xhvhmnBGT+U6sRtPZxxjPhsf
x/qe/Gqe0V/zWbAb6vSxClgEaxDvhFUyPmYDr4HVoDEWeCb7muCPsEcYKvzR
33MsO/YCm4G3sOcJ/wHPxI6PwDzNkmPtbUIPGCMsFn7nlWh243un+kO+E2bK
mFif2eNvPxMat4Qrsj8KnsieKtPncxkfv4HdwDDZEwW7ZF8UGm+E7eCD//Dd
Mkf/JQs1R/wxSXNn/DeiHWsPFucd8EN4JxwQJmz6PK+3YueDHcGQDDgqGkti
fM8FP4IlWiDjYI8wS/gjNcb2alX/jxfBkGBE7A9jz2AMCM5pkfg7FjeCGcGL
4Ebmy3U6Fntibxb74/493w/OhX/i79gZssaXyDrFNuGaME3vRdt3GBe1WOwT
5lx4E9fmeuxljE1ZOnZ1+/bTxXrYF9f+uFgPTIq9eAf7w9gzBidiH1376eJK
PosP9uRPmee+K9TM258V34ExsW+NPWp8Rue1/y+WwTjYHDX/zosNsWeyPZUx
Jj6jvZaxXer52fEm+AX7EGNY7PFLY1vsCeyzYFjspeM+YNTsE+t6MCn247Wn
LybFPr326x3sfUFjTOyjaz9djIn9de2ziytRM2+/FiyGmnx7+qq9t68vjYNQ
D+9YTIqadsfiTbAk9qfBj2BJ7OmLGcFu2H8Xl6HmnB17Yl9ccwyfop7c3sMz
dI0roTEj4ipiNeIw6sCNM2PX6lTtuTtb19gEe/piK/AU9vQd7JNAz9y1mm0+
M3Vtz6IFMvfwC+4Vrkd9uH1/v9E1ToTGqmAr7AGMlcAm2Md3sHcBPXvX2AfX
g0HAGtjfFzuAp7BPME5EzbZxZula3TX7rF2rT+aPF1Bj7J1Qzb88oFyenmbq
/O31O9gTgFaT737aq0Pdvpp5+/6O7VU/qu3jq5Ye72A/XSyAOnN79KqfV5/M
X429ulZ7+qotV2drv1517+rk7RU96K9Pq2NX985fHbvafnt44AvUAzvv2F79
Q+1c6szVqNtjWK24ekj776pnVmNsb121xGpQ7QesDlwtpX181XKr/ba/r1pu
9bHs6sPVq/NXo6721fjq0tWm8le/rd7bPsHqt9Vd27t30AucVvOsxt7nxQio
qbYfsBppNd6uU822elHjqOtWe8lHbbDcsT0y5XzdT/soqJdWm2SfWvWB6pnt
l6CGWd2yPYAHPdFpdcXqkO0HrL5aXbE9gNX3qrG0l7AaZjV19u5duWv1k/yX
61qdLbuaW3W/9gMe9PmmV+xaTa/9gAd9wemVulZ7bF9htfpqUJ13+a7V3NoP
eNCfm16la3Vi9u5V56ne27Wp31aLaz9gtaxqce3jO+iTTatBVUfHZ7Wu1ebZ
V3jVrtXo0mpi1bLaJ3jQD5tWd6o21X7Ag/7TtDpMtZfmj1p3taN64qsLVY/q
OtWp8tH7Xi2rOlLPRT2nWkqffYWu1YXaS1idrVy8fV537VpNpj2DB72fafWT
ag7tbTzo5UyrY1Q3Zd9cdYxqw+w9rJZSnZ59fNXvqaXko2ZSHZF9f9X4qXGy
Z7B6PLWI9gke9EKm1QqqP+SvtlCdlb2H1TpieGk1k+qLnEu9n9pC+wSrzVMz
Y39ftWdqQuzLu33XavnsGazGT82efYIHvX5ptXPqgvhskTmg57g6QHVHxlcr
qH5PT3C1eerx7Cus1k5dnL2TBz13abVnajJ9XnWYat7sJayeTT2e61Rfp1bH
OOru1LTw2a5rdbburbpZtWQ+i7o1dX2eozpbNSf2Fd6xazVj9gke9KOld+pa
DZj9htV0qeOy16zaKrVtjlV7ph7JHsBqLtR+8N+5a3UL9glWE6Xmyl7Cg96u
9G65b/opq7NSQ8VfjY1aL3NM7ZZaEedV36V2wrnULKnv0GdZbZI6HPvyqrFR
n2P/4x26Vh9lj2E1RWqN7Cs86HVKqxdSh8BHfZF6CXsMqztSR0SriVI7ZN/i
QR9TWm2MvL/zqr1Rb2NfYTU26vpcg1o+eXl2dSzqAexVrOZHrRGtFkjNj32I
Bz0+aXU18u++P9XGeP+3N6R/m8uD2yfY3z51L/Y5HvQFpNWrqG+x9/CgpyZ9
cJ6L3rhqS9SZ2GN40C+TVt+iLsV+yYP+l7TaDzUh+t6qD1E3Yi/bQZ9LWu2H
Gg/7EA/6VtLqGdRy2Id40HuSVmuhfsN+w2oz1E7Yb1hNhRycvXvlx+VYx9q7
lku19/AxXauRsMew2ga5YOOozZA/ZT+2a7UK9h4e9GWkj+taftNexcd3rSbB
nr7qB9QDOK/8vnwlu/oB+UH7B5/YtZoHx8qVqxNgV1egbsS1HZv7qSepGgA5
Dnv0ymPKD9qf+OSu5fftNzzoHUjLQcvX6xkqdy8Xb1/hQQ9CWq5c/t3+xIMe
gbT8uDy4PYkHPf9o+W65dfsND3r40XLZ8t32Hh705KPlpuWa7SU86LFHy3PJ
O9uTeNA/j5YvlmOyJ7GcrxoGn1HNg3yuzy7/K+dr/+BBjzpaflZu2rHyyHKy
9iQe9JCj5XnlYe1JLPfqHur/KH8ql2o/Y/lfOU09HOU95WLY5WflVuxPLI8p
92EcOVb5R3b5U7Vk1pTaMznNsXsMj9tyo/YqlluUo7RX8aAvGi2fKD9oH+JB
jzRa/kh+wV7C8npyIsaRx5Tbsp+ufJZ8Ih95KPF2eyRf0rWYvH2L5eDk7OxD
POhDRl/ctTwaf/k1eQd7Lcv9yTnS8oPixs51addyZPYnlnMRE7Yn7s+6Fke1
37B4vni4vYoHeSV7Dw/6ctFXdO3e6tMn3yTPxV/+Szzc+Jd1LYdlj+FBzzb6
yq7ldOxVPOh9RcvjyD/6vPKVcj32LZbTkZ9ynfJK8ll69sk3id/ykceRr3H9
cijyMvYwlouRq/Icx/bMHG77EMuVyH3Yn3jQI4qWZ5GzsIexPIt8hz2J5SPk
cRwrLyM2yEcORVyUj9yE+6OXmZi8eLg9icXr5CnsZyxmLm5vr2ixfTFSdjkL
MUn7GcsLyFM4Vo5DPoJd/kIc0v7B4rFim8aRaxBPtjew+LPYtc8uVyW2b0/i
sX2MRrX9jAc9h2ixX/E9PmLy4v96pckXiDHaW1eORrzdnseDHkK0OLlYmfOK
OYtj289YnFwuw7HyBWIv7GKeYnT2SxYPF6unxdLFt/1dE3/G+vs3KvZfnMrn
FftdaaT1UtEvRezIPsR3di32az/jQT8bWhxV3Mbexnd3LSZpH2IxRjFnx4pX
69fCLk4olmUfZbFl91ZfKvFbsRR7Et/XtRipflKD2Kn9lcU/xXvthSyWq2cM
u9ip2LJrEL8Ve7SfsVilPij2FRYHEzezH7B4l/4u9mkWG9S7xb6/YoBiaPY2
FgMUk2QXC52tfs8+MrbscmwvE/sQiyOJbRpH7FSPGed9oGs9Wowjjqe3ivOK
d4m/2QNbHEw82ecVQ9aLhV0cTG8V+yiLH4or0nKs4oc+i3jjRrmef3Qt9uWe
3NO1eIK9kMXHxJ3sryw+Jrajd89MseufIi60gs860vZBXrN+T20f6K7Frxwr
DrZW/Z7GntY5lx5D4lor1u+J6+fxsq9avyevn6dLr+Ye188zpVev31PaGzvz
apL6ecLfZffAftVdi1PZO1m/lrXr97T2YC77rPV75txzv2cZGRvG6tZx/pG2
D/J0rjF6pvo9Y3zs6cxeQ3ZzjLTnVx97bF8Z9+eRHGucmp5jfaeLvzG+Eb1B
zvtK1/ZZnjXXI/5pDognu7ZZ42Mf55lyDetlnJcz5kzRq3iG9fNU1/a4nyPX
Nmn9Xnmk9R2av34vONL2ZZ6zfs8VH3sEzz0yFn8Ya6dfLb1JfGi2OeOjt4N4
i14N7sEcmTPz1O954+NcC4yMTQN1W0Q7r/2gXcNI1/aMni8+m+XY17pmmyf2
Rer3QtZ+6a3q98Ijbf9oeyIvaT127b8vnDEXr/9ZtH7GK71N/V5spO0xbd/n
xWNfNPav5NhFMqb9pheJnc/iOdZ5lsi5/Pb/7SW9TP1eqn7G79pnmj/XwLZ0
/Ler39+M/xLRrmGH+NjD+rg8oydzD+fLfTDOMvFZtn4vP9L2tp4xa8z6ss5o
fa6sG+tHD6tTRtqasV70zXGsvbCniF0PqJ3q93IZ85iRtpasoxNG2nwylyaL
1ofqpJG2Jq3HSeLv+3zy2PWPOirXYP2eOtLWqnVqTVhjV2YNrTvS1pf1at3q
E+V7wveFPlGnj7TvCN8P34/dd4jPsWw+y7K5fvf/tIxj7U+Z8+pVNU3GuSxx
b+cd7M1uLVk79hBfJuNYW+vFx3eG7w49o34U7TtEv6Z1cv2e26R5dtbi+hlT
TJu+OjHtDUe+3FN9o6wX37UbxW4NbRy7PkvW3qv5vnKs7wFryFqybsT5+Vvr
ejGxv961nk6bZf5YT/T1WWebxy6WvnnGsa43zbms9U0ypvm8ZcYUb6dvzJrb
PvNZL6adMn+sm62zjvS02SZrxzqjrS0x9q2jrdetRr7cH36rHGvNbZtjxfZp
a1c833kHe6HvkHUh17BpPqP1tEN8rLPtRr7c7327kS/X7I451nfwBnlGcgTs
5oJ5dFDmpLW1S9aXnClt/Z1Vv3eN/ehoc14+VI85fYLF/3ceaevvnPq990j7
HrY++Fin8qR6xuktJx/qHUlfup/U7z2zvo6PfjLzba+Mc2z93n2krdmzo415
Ys71VP4u6DFn/X63fh+Q9Wgd7Zxnd3L93nekrWv5Sj3m9KI7r35/a6Sta+t7
v+hz429MuV3j63X3nfg/k7/Xes/5nrEWv531KL9J6/dm7e6Ue35B/T4wPufn
Oh2rHsw4et19Lz7WuDyjZ6RH3Q/q98Ej7ftBvky/Nrm5i+r3oSPt++SH0b5P
fB/os+Y74eL6fXi0+3dM7qfcor51+tutFLvn4nvokIz54xzrO+HM+n3kSOsR
Zy4clfmwYvTMeQ/Rn873CR/zxve3PLLr0T/PNXiuvsvdw1Py2d1X93fyzAVz
wnew53tC7r9n7tlPmud/QuaAfnHm+St5Rzot981cOi5zb89oc8yzPSnzwXM4
NXNm9WjP7pJ8Xp+Fj7k1ReaF+eTvxqoZZ/Zc/ymZG/Kt7oN+fgfmejxT2jOe
Ms/q9P95Xqfn/rB7lv5WuJ8/yjjek60Z68VcMCf8bfG8vp/neHj8PS/a85sm
n8Pz833v/d/atq7dk5/k/nheZ+U58j8jz9rzOnvky16StDWovsW/R9Tq+HeB
9W/Neie/KPPHvTr3f+7PeXnW3tXPz/z3zs9u3V2YeX5JPuP3M+e9xBnHevTc
z8l88FzOz/Ny3y7KPfRvjYsz541z4f/cn4v/57lcMPJlD0ja2vTvjgtzDe6D
eWCt/T8cCt32
           "]]]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJzVfXd8TlnXth6E0aL3zqijDCbhDqJGRnQGo0Z0RplomTC6qIPRQhBEjxKE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        "]]}, {{{1., 0., 0.}, {0., 0.9486832980505138, 
      0.31622776601683794`}, {0., -0.31622776601683794`, 
      0.9486832980505138}}, {0., 0., 0.}}], {{{1., 0., 0.}, {0., 1., 0.}, {0.,
      0., 1.}}, {-1.5, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[{
      CylinderBox[
       NCache[{{0, 0, Rational[-3, 2] Pi}, {0, 0, Rational[3, 2] Pi}}, {{
         0, 0, -4.71238898038469}, {0, 0, 4.71238898038469}}], 1], 
      GraphicsComplex3DBox[CompressedData["
1:eJx1nHlcTtv3x5MGKjJUZAxlHi6lDLFDpYRICIVCxoypEIlIyBAiUTKlTAmR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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnQnYVdMXxvd3zxGZh0TGRjKTJiHNZEwqQ2kkKaSSeaiIyJSMZUzmMTRo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           "]]]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJx1XHlcjV3XTpEpQ4mQqdJAGSIy1NmZp4iQMkWGRKKUzBQhUknKTHOkKM3R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        "]], GraphicsComplex3DBox[CompressedData["
1:eJxdnXlcjs33x2nVplARspbszzdFljShUqIoWbNlDVlTlkhklyUqa8meXRKt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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnQnYVdMXxvd3zxGZh0TGRjKTJiHNZEwqQ2kkKaSSeaiIyJSMZUzmMTRo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           "]]]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJxdXXdcjm8XT8jKKKWUWUrDljKqK9lkk8zISCRK2aRkRCpJZUbbCC1Nz9Xe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        "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nXd8T9cbx9UMNWKrGXuF2iIiN3YokqKKErNGjBIjQeyd2Hvvqs2P2OEb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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3XW8LlX1x/GBe869c0RQuku6u6S7u7s7BeluRFRUQrpFFBQQCYkfLaKg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           "]]]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJzVfXd8TlnXth6E0aL3zqijDCbhDqJGRnQGo0Z0RplomTC6qIPRQhBEjxKE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        "]]}, {{{1., 0., 0.}, {0., 
      0.9486832980505138, -0.31622776601683794`}, {0., 0.31622776601683794`, 
      0.9486832980505138}}, {0., 0., 0.}}], {{{1., 0., 0.}, {0., 1., 0.}, {0.,
      0., 1.}}, {1.5, 0., 0.}}]},
  Boxed->False,
  ViewPoint->{0, 3, 0},
  ViewVertical->{1, 0, 0}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 10.25: Director configuration in a chiral nematic or cholesteric phase.\
\>", "Subsection"],

Cell[BoxData[
 Graphics3DBox[
  {Thickness[0.007], 
   Line3DBox[{{0, 0, -2.4499999999999997`}, {0, 0, 2.4499999999999997`}}], {{
     Line3DBox[{{1, 1, -2.0999999999999996`}, {1, -1, -2.0999999999999996`}}],
      Line3DBox[{{
       1, -1, -2.0999999999999996`}, {-1, -1, -2.0999999999999996`}}], 
     Line3DBox[{{-1, -1, -2.0999999999999996`}, {-1, 
        1, -2.0999999999999996`}}], 
     Line3DBox[{{-1, 1, -2.0999999999999996`}, {1, 1, -2.0999999999999996`}}], 
     {RGBColor[0.24720000000000014`, 0.24, 0.6], Arrowheads[{-0.03, 0.03}], 
      Arrow3DBox[TubeBox[{{0.5, 
       6.123233995736766*^-17, -2.0999999999999996`}, {-0.5, \
-6.123233995736766*^-17, -2.0999999999999996`}}]], 
      {GrayLevel[0], 
       Line3DBox[{{1.4999999999999998`, 
        1.2500000000000002`, -2.0999999999999996`}, {-1.5000000000000002`, 
        1.2499999999999998`, -2.0999999999999996`}}], 
       Line3DBox[{{1.4999999999999998`, 
        1.0000000000000002`, -2.0999999999999996`}, {-1.5000000000000002`, 
        0.9999999999999998, -2.0999999999999996`}}], 
       Line3DBox[{{1.5, 0.7500000000000002, -2.0999999999999996`}, {-1.5, 
        0.7499999999999998, -2.0999999999999996`}}], 
       Line3DBox[{{1.5, 0.5000000000000002, -2.0999999999999996`}, {-1.5, 
        0.49999999999999983`, -2.0999999999999996`}}], 
       Line3DBox[{{1.5, 0.25000000000000017`, -2.0999999999999996`}, {-1.5, 
        0.2499999999999998, -2.0999999999999996`}}], 
       Line3DBox[{{1.5, 
        1.8369701987210297`*^-16, -2.0999999999999996`}, {-1.5, \
-1.8369701987210297`*^-16, -2.0999999999999996`}}], 
       Line3DBox[{{
        1.5, -0.2499999999999998, -2.0999999999999996`}, {-1.5, \
-0.25000000000000017`, -2.0999999999999996`}}], 
       Line3DBox[{{
        1.5, -0.49999999999999983`, -2.0999999999999996`}, {-1.5, \
-0.5000000000000002, -2.0999999999999996`}}], 
       Line3DBox[{{
        1.5, -0.7499999999999998, -2.0999999999999996`}, {-1.5, \
-0.7500000000000002, -2.0999999999999996`}}], 
       Line3DBox[{{
        1.5000000000000002`, -0.9999999999999998, -2.0999999999999996`}, \
{-1.4999999999999998`, -1.0000000000000002`, -2.0999999999999996`}}], 
       Line3DBox[{{
        1.5000000000000002`, -1.2499999999999998`, -2.0999999999999996`}, \
{-1.4999999999999998`, -1.2500000000000002`, -2.0999999999999996`}}]}}}, {
     Line3DBox[{{1, 1, -1.3999999999999997`}, {1, -1, -1.3999999999999997`}}],
      Line3DBox[{{
       1, -1, -1.3999999999999997`}, {-1, -1, -1.3999999999999997`}}], 
     Line3DBox[{{-1, -1, -1.3999999999999997`}, {-1, 
        1, -1.3999999999999997`}}], 
     Line3DBox[{{-1, 1, -1.3999999999999997`}, {1, 1, -1.3999999999999997`}}], 
     {RGBColor[0.24720000000000014`, 0.24, 0.6], Arrowheads[{-0.03, 0.03}], 
      Arrow3DBox[TubeBox[{{0.2499999999999999, 
       0.43301270189221935`, -1.3999999999999997`}, {-0.2499999999999999, \
-0.43301270189221935`, -1.3999999999999997`}}]], 
      {GrayLevel[0], 
       Line3DBox[{{-0.33253175473054875`, 
        1.9240381056766578`, -1.3999999999999997`}, {-1.8325317547305482`, \
-0.6740381056766582, -1.3999999999999997`}}], 
       Line3DBox[{{-0.11602540378443904`, 
        1.7990381056766578`, -1.3999999999999997`}, {-1.6160254037844384`, \
-0.7990381056766582, -1.3999999999999997`}}], 
       Line3DBox[{{0.10048094716167066`, 
        1.6740381056766578`, -1.3999999999999997`}, {-1.3995190528383286`, \
-0.9240381056766582, -1.3999999999999997`}}], 
       Line3DBox[{{0.3169872981077803, 
        1.549038105676658, -1.3999999999999997`}, {-1.183012701892219, \
-1.049038105676658, -1.3999999999999997`}}], 
       Line3DBox[{{0.53349364905389, 
        1.424038105676658, -1.3999999999999997`}, {-0.9665063509461094, \
-1.174038105676658, -1.3999999999999997`}}], 
       Line3DBox[{{0.7499999999999997, 
        1.299038105676658, -1.3999999999999997`}, {-0.7499999999999997, \
-1.299038105676658, -1.3999999999999997`}}], 
       Line3DBox[{{0.9665063509461094, 
        1.174038105676658, -1.3999999999999997`}, {-0.53349364905389, \
-1.424038105676658, -1.3999999999999997`}}], 
       Line3DBox[{{1.183012701892219, 
        1.049038105676658, -1.3999999999999997`}, {-0.3169872981077803, \
-1.549038105676658, -1.3999999999999997`}}], 
       Line3DBox[{{1.3995190528383286`, 
        0.9240381056766582, -1.3999999999999997`}, {-0.10048094716167066`, \
-1.6740381056766578`, -1.3999999999999997`}}], 
       Line3DBox[{{1.6160254037844384`, 
        0.7990381056766582, -1.3999999999999997`}, {
        0.11602540378443904`, -1.7990381056766578`, -1.3999999999999997`}}], 
       Line3DBox[{{1.8325317547305482`, 
        0.6740381056766582, -1.3999999999999997`}, {
        0.33253175473054875`, -1.9240381056766578`, \
-1.3999999999999997`}}]}}}, {
     Line3DBox[{{1, 1, -0.6999999999999997}, {1, -1, -0.6999999999999997}}], 
     Line3DBox[{{1, -1, -0.6999999999999997}, {-1, -1, -0.6999999999999997}}],
      Line3DBox[{{-1, -1, -0.6999999999999997}, {-1, 
        1, -0.6999999999999997}}], 
     Line3DBox[{{-1, 1, -0.6999999999999997}, {1, 1, -0.6999999999999997}}], 
     {RGBColor[0.24720000000000014`, 0.24, 0.6], Arrowheads[{-0.03, 0.03}], 
      Arrow3DBox[TubeBox[{{-0.25000000000000017`, 
       0.43301270189221924`, -0.6999999999999997}, {
       0.25000000000000017`, -0.43301270189221924`, -0.6999999999999997}}]], 
      {GrayLevel[0], 
       Line3DBox[{{-1.8325317547305486`, 
        0.6740381056766573, -0.6999999999999997}, {-0.33253175473054775`, \
-1.9240381056766582`, -0.6999999999999997}}], 
       Line3DBox[{{-1.6160254037844388`, 
        0.7990381056766575, -0.6999999999999997}, {-0.11602540378443804`, \
-1.799038105676658, -0.6999999999999997}}], 
       Line3DBox[{{-1.3995190528383294`, 
        0.9240381056766576, -0.6999999999999997}, {
        0.10048094716167155`, -1.674038105676658, -0.6999999999999997}}], 
       Line3DBox[{{-1.1830127018922196`, 
        1.0490381056766576`, -0.6999999999999997}, {
        0.3169872981077812, -1.549038105676658, -0.6999999999999997}}], 
       Line3DBox[{{-0.96650635094611, 
        1.1740381056766578`, -0.6999999999999997}, {
        0.5334936490538909, -1.4240381056766578`, -0.6999999999999997}}], 
       Line3DBox[{{-0.7500000000000004, 
        1.2990381056766578`, -0.6999999999999997}, {
        0.7500000000000004, -1.2990381056766578`, -0.6999999999999997}}], 
       Line3DBox[{{-0.5334936490538909, 
        1.4240381056766578`, -0.6999999999999997}, {
        0.96650635094611, -1.1740381056766578`, -0.6999999999999997}}], 
       Line3DBox[{{-0.3169872981077812, 
        1.549038105676658, -0.6999999999999997}, {
        1.1830127018922196`, -1.0490381056766576`, -0.6999999999999997}}], 
       Line3DBox[{{-0.10048094716167155`, 
        1.674038105676658, -0.6999999999999997}, {
        1.3995190528383294`, -0.9240381056766576, -0.6999999999999997}}], 
       Line3DBox[{{0.11602540378443804`, 
        1.799038105676658, -0.6999999999999997}, {
        1.6160254037844388`, -0.7990381056766575, -0.6999999999999997}}], 
       Line3DBox[{{0.33253175473054775`, 
        1.9240381056766582`, -0.6999999999999997}, {
        1.8325317547305486`, -0.6740381056766573, -0.6999999999999997}}]}}}, {
     Line3DBox[{{1, 1, 0.}, {1, -1, 0.}}], 
     Line3DBox[{{1, -1, 0.}, {-1, -1, 0.}}], 
     Line3DBox[{{-1, -1, 0.}, {-1, 1, 0.}}], 
     Line3DBox[{{-1, 1, 0.}, {1, 1, 0.}}], 
     {RGBColor[0.24720000000000014`, 0.24, 0.6], Arrowheads[{-0.03, 0.03}], 
      Arrow3DBox[TubeBox[{{-0.5, 0., 0.}, {0.5, 0., 0.}}]], 
      {GrayLevel[0], Line3DBox[{{-1.5, -1.25, 0.}, {1.5, -1.25, 0.}}], 
       Line3DBox[{{-1.5, -1., 0.}, {1.5, -1., 0.}}], 
       Line3DBox[{{-1.5, -0.75, 0.}, {1.5, -0.75, 0.}}], 
       Line3DBox[{{-1.5, -0.5, 0.}, {1.5, -0.5, 0.}}], 
       Line3DBox[{{-1.5, -0.25, 0.}, {1.5, -0.25, 0.}}], 
       Line3DBox[{{-1.5, 0., 0.}, {1.5, 0., 